// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/securitycentermanagement/v1/security_center_management.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SECURITYCENTERMANAGEMENT_V1_INTERNAL_SECURITY_CENTER_MANAGEMENT_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SECURITYCENTERMANAGEMENT_V1_INTERNAL_SECURITY_CENTER_MANAGEMENT_CONNECTION_IMPL_H

#include "google/cloud/securitycentermanagement/v1/internal/security_center_management_retry_traits.h"
#include "google/cloud/securitycentermanagement/v1/internal/security_center_management_stub.h"
#include "google/cloud/securitycentermanagement/v1/security_center_management_connection.h"
#include "google/cloud/securitycentermanagement/v1/security_center_management_connection_idempotency_policy.h"
#include "google/cloud/securitycentermanagement/v1/security_center_management_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace securitycentermanagement_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class SecurityCenterManagementConnectionImpl
    : public securitycentermanagement_v1::SecurityCenterManagementConnection {
 public:
  ~SecurityCenterManagementConnectionImpl() override = default;

  SecurityCenterManagementConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<
          securitycentermanagement_v1_internal::SecurityCenterManagementStub>
          stub,
      Options options);

  Options options() override { return options_; }

  StreamRange<google::cloud::securitycentermanagement::v1::
                  EffectiveSecurityHealthAnalyticsCustomModule>
  ListEffectiveSecurityHealthAnalyticsCustomModules(
      google::cloud::securitycentermanagement::v1::
          ListEffectiveSecurityHealthAnalyticsCustomModulesRequest request)
      override;

  StatusOr<google::cloud::securitycentermanagement::v1::
               EffectiveSecurityHealthAnalyticsCustomModule>
  GetEffectiveSecurityHealthAnalyticsCustomModule(
      google::cloud::securitycentermanagement::v1::
          GetEffectiveSecurityHealthAnalyticsCustomModuleRequest const& request)
      override;

  StreamRange<google::cloud::securitycentermanagement::v1::
                  SecurityHealthAnalyticsCustomModule>
  ListSecurityHealthAnalyticsCustomModules(
      google::cloud::securitycentermanagement::v1::
          ListSecurityHealthAnalyticsCustomModulesRequest request) override;

  StreamRange<google::cloud::securitycentermanagement::v1::
                  SecurityHealthAnalyticsCustomModule>
  ListDescendantSecurityHealthAnalyticsCustomModules(
      google::cloud::securitycentermanagement::v1::
          ListDescendantSecurityHealthAnalyticsCustomModulesRequest request)
      override;

  StatusOr<google::cloud::securitycentermanagement::v1::
               SecurityHealthAnalyticsCustomModule>
  GetSecurityHealthAnalyticsCustomModule(
      google::cloud::securitycentermanagement::v1::
          GetSecurityHealthAnalyticsCustomModuleRequest const& request)
      override;

  StatusOr<google::cloud::securitycentermanagement::v1::
               SecurityHealthAnalyticsCustomModule>
  CreateSecurityHealthAnalyticsCustomModule(
      google::cloud::securitycentermanagement::v1::
          CreateSecurityHealthAnalyticsCustomModuleRequest const& request)
      override;

  StatusOr<google::cloud::securitycentermanagement::v1::
               SecurityHealthAnalyticsCustomModule>
  UpdateSecurityHealthAnalyticsCustomModule(
      google::cloud::securitycentermanagement::v1::
          UpdateSecurityHealthAnalyticsCustomModuleRequest const& request)
      override;

  Status DeleteSecurityHealthAnalyticsCustomModule(
      google::cloud::securitycentermanagement::v1::
          DeleteSecurityHealthAnalyticsCustomModuleRequest const& request)
      override;

  StatusOr<google::cloud::securitycentermanagement::v1::
               SimulateSecurityHealthAnalyticsCustomModuleResponse>
  SimulateSecurityHealthAnalyticsCustomModule(
      google::cloud::securitycentermanagement::v1::
          SimulateSecurityHealthAnalyticsCustomModuleRequest const& request)
      override;

  StreamRange<google::cloud::securitycentermanagement::v1::
                  EffectiveEventThreatDetectionCustomModule>
  ListEffectiveEventThreatDetectionCustomModules(
      google::cloud::securitycentermanagement::v1::
          ListEffectiveEventThreatDetectionCustomModulesRequest request)
      override;

  StatusOr<google::cloud::securitycentermanagement::v1::
               EffectiveEventThreatDetectionCustomModule>
  GetEffectiveEventThreatDetectionCustomModule(
      google::cloud::securitycentermanagement::v1::
          GetEffectiveEventThreatDetectionCustomModuleRequest const& request)
      override;

  StreamRange<google::cloud::securitycentermanagement::v1::
                  EventThreatDetectionCustomModule>
  ListEventThreatDetectionCustomModules(
      google::cloud::securitycentermanagement::v1::
          ListEventThreatDetectionCustomModulesRequest request) override;

  StreamRange<google::cloud::securitycentermanagement::v1::
                  EventThreatDetectionCustomModule>
  ListDescendantEventThreatDetectionCustomModules(
      google::cloud::securitycentermanagement::v1::
          ListDescendantEventThreatDetectionCustomModulesRequest request)
      override;

  StatusOr<google::cloud::securitycentermanagement::v1::
               EventThreatDetectionCustomModule>
  GetEventThreatDetectionCustomModule(
      google::cloud::securitycentermanagement::v1::
          GetEventThreatDetectionCustomModuleRequest const& request) override;

  StatusOr<google::cloud::securitycentermanagement::v1::
               EventThreatDetectionCustomModule>
  CreateEventThreatDetectionCustomModule(
      google::cloud::securitycentermanagement::v1::
          CreateEventThreatDetectionCustomModuleRequest const& request)
      override;

  StatusOr<google::cloud::securitycentermanagement::v1::
               EventThreatDetectionCustomModule>
  UpdateEventThreatDetectionCustomModule(
      google::cloud::securitycentermanagement::v1::
          UpdateEventThreatDetectionCustomModuleRequest const& request)
      override;

  Status DeleteEventThreatDetectionCustomModule(
      google::cloud::securitycentermanagement::v1::
          DeleteEventThreatDetectionCustomModuleRequest const& request)
      override;

  StatusOr<google::cloud::securitycentermanagement::v1::
               ValidateEventThreatDetectionCustomModuleResponse>
  ValidateEventThreatDetectionCustomModule(
      google::cloud::securitycentermanagement::v1::
          ValidateEventThreatDetectionCustomModuleRequest const& request)
      override;

  StatusOr<google::cloud::securitycentermanagement::v1::SecurityCenterService>
  GetSecurityCenterService(
      google::cloud::securitycentermanagement::v1::
          GetSecurityCenterServiceRequest const& request) override;

  StreamRange<
      google::cloud::securitycentermanagement::v1::SecurityCenterService>
  ListSecurityCenterServices(
      google::cloud::securitycentermanagement::v1::
          ListSecurityCenterServicesRequest request) override;

  StatusOr<google::cloud::securitycentermanagement::v1::SecurityCenterService>
  UpdateSecurityCenterService(
      google::cloud::securitycentermanagement::v1::
          UpdateSecurityCenterServiceRequest const& request) override;

 private:
  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<
      securitycentermanagement_v1_internal::SecurityCenterManagementStub>
      stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace securitycentermanagement_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SECURITYCENTERMANAGEMENT_V1_INTERNAL_SECURITY_CENTER_MANAGEMENT_CONNECTION_IMPL_H
