// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/resourcemanager/v3/projects.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RESOURCEMANAGER_V3_PROJECTS_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RESOURCEMANAGER_V3_PROJECTS_CLIENT_H

#include "google/cloud/resourcemanager/v3/projects_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace resourcemanager_v3 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Manages Google Cloud Projects.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class ProjectsClient {
 public:
  explicit ProjectsClient(std::shared_ptr<ProjectsConnection> connection,
                          Options opts = {});
  ~ProjectsClient();

  ///@{
  /// @name Copy and move support
  ProjectsClient(ProjectsClient const&) = default;
  ProjectsClient& operator=(ProjectsClient const&) = default;
  ProjectsClient(ProjectsClient&&) = default;
  ProjectsClient& operator=(ProjectsClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(ProjectsClient const& a, ProjectsClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(ProjectsClient const& a, ProjectsClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Retrieves the project identified by the specified `name` (for example,
  /// `projects/415104041262`).
  ///
  /// The caller must have `resourcemanager.projects.get` permission
  /// for this project.
  ///
  /// @param name  Required. The name of the project (for example, `projects/415104041262`).
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.resourcemanager.v3.Project])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.resourcemanager.v3.GetProjectRequest]: @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L386}
  /// [google.cloud.resourcemanager.v3.Project]: @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L295}
  ///
  // clang-format on
  StatusOr<google::cloud::resourcemanager::v3::Project> GetProject(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Retrieves the project identified by the specified `name` (for example,
  /// `projects/415104041262`).
  ///
  /// The caller must have `resourcemanager.projects.get` permission
  /// for this project.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.resourcemanager.v3.GetProjectRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.resourcemanager.v3.Project])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.resourcemanager.v3.GetProjectRequest]: @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L386}
  /// [google.cloud.resourcemanager.v3.Project]: @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L295}
  ///
  // clang-format on
  StatusOr<google::cloud::resourcemanager::v3::Project> GetProject(
      google::cloud::resourcemanager::v3::GetProjectRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists projects that are direct children of the specified folder or
  /// organization resource. `list()` provides a strongly consistent view of the
  /// projects underneath the specified parent resource. `list()` returns
  /// projects sorted based upon the (ascending) lexical ordering of their
  /// `display_name`. The caller must have `resourcemanager.projects.list`
  /// permission on the identified parent.
  ///
  /// @param parent  Required. The name of the parent resource whose projects are being listed.
  ///  Only children of this parent resource are listed; descendants are not
  ///  listed.
  ///  @n
  ///  If the parent is a folder, use the value `folders/{folder_id}`. If the
  ///  parent is an organization, use the value `organizations/{org_id}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.resourcemanager.v3.Project], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.resourcemanager.v3.ListProjectsRequest]: @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L399}
  /// [google.cloud.resourcemanager.v3.Project]: @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L295}
  ///
  // clang-format on
  StreamRange<google::cloud::resourcemanager::v3::Project> ListProjects(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists projects that are direct children of the specified folder or
  /// organization resource. `list()` provides a strongly consistent view of the
  /// projects underneath the specified parent resource. `list()` returns
  /// projects sorted based upon the (ascending) lexical ordering of their
  /// `display_name`. The caller must have `resourcemanager.projects.list`
  /// permission on the identified parent.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.resourcemanager.v3.ListProjectsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.resourcemanager.v3.Project], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.resourcemanager.v3.ListProjectsRequest]: @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L399}
  /// [google.cloud.resourcemanager.v3.Project]: @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L295}
  ///
  // clang-format on
  StreamRange<google::cloud::resourcemanager::v3::Project> ListProjects(
      google::cloud::resourcemanager::v3::ListProjectsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Search for projects that the caller has both `resourcemanager.projects.get`
  /// permission on, and also satisfy the specified query.
  ///
  /// This method returns projects in an unspecified order.
  ///
  /// This method is eventually consistent with project mutations; this means
  /// that a newly created project may not appear in the results or recent
  /// updates to an existing project may not be reflected in the results. To
  /// retrieve the latest state of a project, use the
  /// [GetProject][google.cloud.resourcemanager.v3.Projects.GetProject] method.
  ///
  /// @param query  Optional. A query string for searching for projects that the caller has
  ///  `resourcemanager.projects.get` permission to. If multiple fields are
  ///  included in the query, then it will return results that match any of the
  ///  fields.
  ///  @n
  ///  For more information, see [SearchProjectsRequest][google.cloud.resourcemanager.v3.SearchProjectsRequest].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.resourcemanager.v3.Project], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.resourcemanager.v3.Project]: @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L295}
  /// [google.cloud.resourcemanager.v3.Projects.GetProject]: @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L49}
  /// [google.cloud.resourcemanager.v3.SearchProjectsRequest]: @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L457}
  ///
  // clang-format on
  StreamRange<google::cloud::resourcemanager::v3::Project> SearchProjects(
      std::string const& query, Options opts = {});

  // clang-format off
  ///
  /// Search for projects that the caller has both `resourcemanager.projects.get`
  /// permission on, and also satisfy the specified query.
  ///
  /// This method returns projects in an unspecified order.
  ///
  /// This method is eventually consistent with project mutations; this means
  /// that a newly created project may not appear in the results or recent
  /// updates to an existing project may not be reflected in the results. To
  /// retrieve the latest state of a project, use the
  /// [GetProject][google.cloud.resourcemanager.v3.Projects.GetProject] method.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.resourcemanager.v3.SearchProjectsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.resourcemanager.v3.Project], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.resourcemanager.v3.Project]: @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L295}
  /// [google.cloud.resourcemanager.v3.Projects.GetProject]: @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L49}
  /// [google.cloud.resourcemanager.v3.SearchProjectsRequest]: @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L457}
  ///
  // clang-format on
  StreamRange<google::cloud::resourcemanager::v3::Project> SearchProjects(
      google::cloud::resourcemanager::v3::SearchProjectsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Request that a new project be created. The result is an `Operation` which
  /// can be used to track the creation process. This process usually takes a few
  /// seconds, but can sometimes take much longer. The tracking `Operation` is
  /// automatically deleted after a few hours, so there is no need to call
  /// `DeleteOperation`.
  ///
  /// @param project  Required. The Project to create.
  ///  @n
  ///  Project ID is required. If the requested ID is unavailable, the request
  ///  fails.
  ///  @n
  ///  If the `parent` field is set, the `resourcemanager.projects.create`
  ///  permission is checked on the parent resource. If no parent is set and
  ///  the authorization credentials belong to an Organization, the parent
  ///  will be set to that Organization.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.resourcemanager.v3.Project] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.resourcemanager.v3.CreateProjectRequest]: @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L533}
  /// [google.cloud.resourcemanager.v3.Project]: @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L295}
  ///
  // clang-format on
  future<StatusOr<google::cloud::resourcemanager::v3::Project>> CreateProject(
      google::cloud::resourcemanager::v3::Project const& project,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateProject
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateProject(
      NoAwaitTag, google::cloud::resourcemanager::v3::Project const& project,
      Options opts = {});

  // clang-format off
  ///
  /// Request that a new project be created. The result is an `Operation` which
  /// can be used to track the creation process. This process usually takes a few
  /// seconds, but can sometimes take much longer. The tracking `Operation` is
  /// automatically deleted after a few hours, so there is no need to call
  /// `DeleteOperation`.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.resourcemanager.v3.CreateProjectRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.resourcemanager.v3.Project] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.resourcemanager.v3.CreateProjectRequest]: @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L533}
  /// [google.cloud.resourcemanager.v3.Project]: @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L295}
  ///
  // clang-format on
  future<StatusOr<google::cloud::resourcemanager::v3::Project>> CreateProject(
      google::cloud::resourcemanager::v3::CreateProjectRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateProject
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateProject(
      NoAwaitTag,
      google::cloud::resourcemanager::v3::CreateProjectRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateProject
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::resourcemanager::v3::Project>> CreateProject(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Updates the `display_name` and labels of the project identified by the
  /// specified `name` (for example, `projects/415104041262`). Deleting all
  /// labels requires an update mask for labels field.
  ///
  /// The caller must have `resourcemanager.projects.update` permission for this
  /// project.
  ///
  /// @param project  Required. The new definition of the project.
  /// @param update_mask  Optional. An update mask to selectively update fields.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.resourcemanager.v3.Project] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.resourcemanager.v3.Project]: @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L295}
  /// [google.cloud.resourcemanager.v3.UpdateProjectRequest]: @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L569}
  ///
  // clang-format on
  future<StatusOr<google::cloud::resourcemanager::v3::Project>> UpdateProject(
      google::cloud::resourcemanager::v3::Project const& project,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateProject
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateProject(
      NoAwaitTag, google::cloud::resourcemanager::v3::Project const& project,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the `display_name` and labels of the project identified by the
  /// specified `name` (for example, `projects/415104041262`). Deleting all
  /// labels requires an update mask for labels field.
  ///
  /// The caller must have `resourcemanager.projects.update` permission for this
  /// project.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.resourcemanager.v3.UpdateProjectRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.resourcemanager.v3.Project] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.resourcemanager.v3.Project]: @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L295}
  /// [google.cloud.resourcemanager.v3.UpdateProjectRequest]: @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L569}
  ///
  // clang-format on
  future<StatusOr<google::cloud::resourcemanager::v3::Project>> UpdateProject(
      google::cloud::resourcemanager::v3::UpdateProjectRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateProject
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateProject(
      NoAwaitTag,
      google::cloud::resourcemanager::v3::UpdateProjectRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateProject
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::resourcemanager::v3::Project>> UpdateProject(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Move a project to another place in your resource hierarchy, under a new
  /// resource parent.
  ///
  /// Returns an operation which can be used to track the process of the project
  /// move workflow.
  /// Upon success, the `Operation.response` field will be populated with the
  /// moved project.
  ///
  /// The caller must have `resourcemanager.projects.move` permission on the
  /// project, on the project's current and proposed new parent.
  ///
  /// If project has no current parent, or it currently does not have an
  /// associated organization resource, you will also need the
  /// `resourcemanager.projects.setIamPolicy` permission in the project.
  ///
  ///
  ///
  /// @param name  Required. The name of the project to move.
  /// @param destination_parent  Required. The new parent to move the Project under.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.resourcemanager.v3.Project] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.resourcemanager.v3.MoveProjectRequest]: @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L585}
  /// [google.cloud.resourcemanager.v3.Project]: @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L295}
  ///
  // clang-format on
  future<StatusOr<google::cloud::resourcemanager::v3::Project>> MoveProject(
      std::string const& name, std::string const& destination_parent,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief MoveProject
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> MoveProject(
      NoAwaitTag, std::string const& name,
      std::string const& destination_parent, Options opts = {});

  // clang-format off
  ///
  /// Move a project to another place in your resource hierarchy, under a new
  /// resource parent.
  ///
  /// Returns an operation which can be used to track the process of the project
  /// move workflow.
  /// Upon success, the `Operation.response` field will be populated with the
  /// moved project.
  ///
  /// The caller must have `resourcemanager.projects.move` permission on the
  /// project, on the project's current and proposed new parent.
  ///
  /// If project has no current parent, or it currently does not have an
  /// associated organization resource, you will also need the
  /// `resourcemanager.projects.setIamPolicy` permission in the project.
  ///
  ///
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.resourcemanager.v3.MoveProjectRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.resourcemanager.v3.Project] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.resourcemanager.v3.MoveProjectRequest]: @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L585}
  /// [google.cloud.resourcemanager.v3.Project]: @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L295}
  ///
  // clang-format on
  future<StatusOr<google::cloud::resourcemanager::v3::Project>> MoveProject(
      google::cloud::resourcemanager::v3::MoveProjectRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief MoveProject
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> MoveProject(
      NoAwaitTag,
      google::cloud::resourcemanager::v3::MoveProjectRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief MoveProject
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::resourcemanager::v3::Project>> MoveProject(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Marks the project identified by the specified
  /// `name` (for example, `projects/415104041262`) for deletion.
  ///
  /// This method will only affect the project if it has a lifecycle state of
  /// [ACTIVE][google.cloud.resourcemanager.v3.Project.State.ACTIVE].
  ///
  /// This method changes the Project's lifecycle state from
  /// [ACTIVE][google.cloud.resourcemanager.v3.Project.State.ACTIVE]
  /// to
  /// [DELETE_REQUESTED][google.cloud.resourcemanager.v3.Project.State.DELETE_REQUESTED].
  /// The deletion starts at an unspecified time,
  /// at which point the Project is no longer accessible.
  ///
  /// Until the deletion completes, you can check the lifecycle state
  /// checked by retrieving the project with [GetProject]
  /// [google.cloud.resourcemanager.v3.Projects.GetProject],
  /// and the project remains visible to [ListProjects]
  /// [google.cloud.resourcemanager.v3.Projects.ListProjects].
  /// However, you cannot update the project.
  ///
  /// After the deletion completes, the project is not retrievable by
  /// the  [GetProject]
  /// [google.cloud.resourcemanager.v3.Projects.GetProject],
  /// [ListProjects]
  /// [google.cloud.resourcemanager.v3.Projects.ListProjects], and
  /// [SearchProjects][google.cloud.resourcemanager.v3.Projects.SearchProjects]
  /// methods.
  ///
  /// This method behaves idempotently, such that deleting a `DELETE_REQUESTED`
  /// project will not cause an error, but also won't do anything.
  ///
  /// The caller must have `resourcemanager.projects.delete` permissions for this
  /// project.
  ///
  /// @param name  Required. The name of the Project (for example, `projects/415104041262`).
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.resourcemanager.v3.Project] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.resourcemanager.v3.DeleteProjectRequest]: @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L607}
  /// [google.cloud.resourcemanager.v3.Project]: @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L295}
  /// [google.cloud.resourcemanager.v3.Project.State.ACTIVE]: @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L309}
  /// [google.cloud.resourcemanager.v3.Project.State.DELETE_REQUESTED]: @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L317}
  /// [google.cloud.resourcemanager.v3.Projects.SearchProjects]: @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L79}
  ///
  // clang-format on
  future<StatusOr<google::cloud::resourcemanager::v3::Project>> DeleteProject(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteProject
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteProject(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Marks the project identified by the specified
  /// `name` (for example, `projects/415104041262`) for deletion.
  ///
  /// This method will only affect the project if it has a lifecycle state of
  /// [ACTIVE][google.cloud.resourcemanager.v3.Project.State.ACTIVE].
  ///
  /// This method changes the Project's lifecycle state from
  /// [ACTIVE][google.cloud.resourcemanager.v3.Project.State.ACTIVE]
  /// to
  /// [DELETE_REQUESTED][google.cloud.resourcemanager.v3.Project.State.DELETE_REQUESTED].
  /// The deletion starts at an unspecified time,
  /// at which point the Project is no longer accessible.
  ///
  /// Until the deletion completes, you can check the lifecycle state
  /// checked by retrieving the project with [GetProject]
  /// [google.cloud.resourcemanager.v3.Projects.GetProject],
  /// and the project remains visible to [ListProjects]
  /// [google.cloud.resourcemanager.v3.Projects.ListProjects].
  /// However, you cannot update the project.
  ///
  /// After the deletion completes, the project is not retrievable by
  /// the  [GetProject]
  /// [google.cloud.resourcemanager.v3.Projects.GetProject],
  /// [ListProjects]
  /// [google.cloud.resourcemanager.v3.Projects.ListProjects], and
  /// [SearchProjects][google.cloud.resourcemanager.v3.Projects.SearchProjects]
  /// methods.
  ///
  /// This method behaves idempotently, such that deleting a `DELETE_REQUESTED`
  /// project will not cause an error, but also won't do anything.
  ///
  /// The caller must have `resourcemanager.projects.delete` permissions for this
  /// project.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.resourcemanager.v3.DeleteProjectRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.resourcemanager.v3.Project] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.resourcemanager.v3.DeleteProjectRequest]: @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L607}
  /// [google.cloud.resourcemanager.v3.Project]: @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L295}
  /// [google.cloud.resourcemanager.v3.Project.State.ACTIVE]: @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L309}
  /// [google.cloud.resourcemanager.v3.Project.State.DELETE_REQUESTED]: @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L317}
  /// [google.cloud.resourcemanager.v3.Projects.SearchProjects]: @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L79}
  ///
  // clang-format on
  future<StatusOr<google::cloud::resourcemanager::v3::Project>> DeleteProject(
      google::cloud::resourcemanager::v3::DeleteProjectRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteProject
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteProject(
      NoAwaitTag,
      google::cloud::resourcemanager::v3::DeleteProjectRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteProject
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::resourcemanager::v3::Project>> DeleteProject(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Restores the project identified by the specified
  /// `name` (for example, `projects/415104041262`).
  /// You can only use this method for a project that has a lifecycle state of
  /// [DELETE_REQUESTED]
  /// [Projects.State.DELETE_REQUESTED].
  /// After deletion starts, the project cannot be restored.
  ///
  /// The caller must have `resourcemanager.projects.undelete` permission for
  /// this project.
  ///
  /// @param name  Required. The name of the project (for example, `projects/415104041262`).
  ///  @n
  ///  Required.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.resourcemanager.v3.Project] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.resourcemanager.v3.Project]: @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L295}
  /// [google.cloud.resourcemanager.v3.UndeleteProjectRequest]: @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L624}
  ///
  // clang-format on
  future<StatusOr<google::cloud::resourcemanager::v3::Project>> UndeleteProject(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UndeleteProject
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UndeleteProject(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Restores the project identified by the specified
  /// `name` (for example, `projects/415104041262`).
  /// You can only use this method for a project that has a lifecycle state of
  /// [DELETE_REQUESTED]
  /// [Projects.State.DELETE_REQUESTED].
  /// After deletion starts, the project cannot be restored.
  ///
  /// The caller must have `resourcemanager.projects.undelete` permission for
  /// this project.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.resourcemanager.v3.UndeleteProjectRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.resourcemanager.v3.Project] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.resourcemanager.v3.Project]: @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L295}
  /// [google.cloud.resourcemanager.v3.UndeleteProjectRequest]: @googleapis_reference_link{google/cloud/resourcemanager/v3/projects.proto#L624}
  ///
  // clang-format on
  future<StatusOr<google::cloud::resourcemanager::v3::Project>> UndeleteProject(
      google::cloud::resourcemanager::v3::UndeleteProjectRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UndeleteProject
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UndeleteProject(
      NoAwaitTag,
      google::cloud::resourcemanager::v3::UndeleteProjectRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UndeleteProject
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::resourcemanager::v3::Project>> UndeleteProject(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Returns the IAM access control policy for the specified project, in the
  /// format `projects/{ProjectIdOrNumber}` e.g. projects/123.
  /// Permission is denied if the policy or the resource do not exist.
  ///
  /// @param resource  REQUIRED: The resource for which the policy is being requested.
  ///  See the operation documentation for the appropriate value for this field.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.iam.v1.Policy])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.iam.v1.GetIamPolicyRequest]: @googleapis_reference_link{google/iam/v1/iam_policy.proto#L123}
  /// [google.iam.v1.Policy]: @googleapis_reference_link{google/iam/v1/policy.proto#L102}
  ///
  // clang-format on
  StatusOr<google::iam::v1::Policy> GetIamPolicy(std::string const& resource,
                                                 Options opts = {});

  // clang-format off
  ///
  /// Returns the IAM access control policy for the specified project, in the
  /// format `projects/{ProjectIdOrNumber}` e.g. projects/123.
  /// Permission is denied if the policy or the resource do not exist.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.iam.v1.GetIamPolicyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.iam.v1.Policy])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.iam.v1.GetIamPolicyRequest]: @googleapis_reference_link{google/iam/v1/iam_policy.proto#L123}
  /// [google.iam.v1.Policy]: @googleapis_reference_link{google/iam/v1/policy.proto#L102}
  ///
  // clang-format on
  StatusOr<google::iam::v1::Policy> GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const& request, Options opts = {});

  // clang-format off
  ///
  /// Sets the IAM access control policy for the specified project, in the
  /// format `projects/{ProjectIdOrNumber}` e.g. projects/123.
  ///
  /// CAUTION: This method will replace the existing policy, and cannot be used
  /// to append additional IAM settings.
  ///
  /// Note: Removing service accounts from policies or changing their roles can
  /// render services completely inoperable. It is important to understand how
  /// the service account is being used before removing or updating its roles.
  ///
  /// The following constraints apply when using `setIamPolicy()`:
  ///
  /// + Project does not support `allUsers` and `allAuthenticatedUsers` as
  /// `members` in a `Binding` of a `Policy`.
  ///
  /// + The owner role can be granted to a `user`, `serviceAccount`, or a group
  /// that is part of an organization. For example,
  /// group@myownpersonaldomain.com could be added as an owner to a project in
  /// the myownpersonaldomain.com organization, but not the examplepetstore.com
  /// organization.
  ///
  /// + Service accounts can be made owners of a project directly
  /// without any restrictions. However, to be added as an owner, a user must be
  /// invited using the Cloud Platform console and must accept the invitation.
  ///
  /// + A user cannot be granted the owner role using `setIamPolicy()`. The user
  /// must be granted the owner role using the Cloud Platform Console and must
  /// explicitly accept the invitation.
  ///
  /// + Invitations to grant the owner role cannot be sent using
  /// `setIamPolicy()`;
  /// they must be sent only using the Cloud Platform Console.
  ///
  /// + If the project is not part of an organization, there must be at least
  /// one owner who has accepted the Terms of Service (ToS) agreement in the
  /// policy. Calling `setIamPolicy()` to remove the last ToS-accepted owner
  /// from the policy will fail. This restriction also applies to legacy
  /// projects that no longer have owners who have accepted the ToS. Edits to
  /// IAM policies will be rejected until the lack of a ToS-accepting owner is
  /// rectified. If the project is part of an organization, you can remove all
  /// owners, potentially making the organization inaccessible.
  ///
  /// @param resource  REQUIRED: The resource for which the policy is being specified.
  ///  See the operation documentation for the appropriate value for this field.
  /// @param policy  REQUIRED: The complete policy to be applied to the `resource`. The size of
  ///  the policy is limited to a few 10s of KB. An empty policy is a
  ///  valid policy but certain Cloud Platform services (such as Projects)
  ///  might reject them.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.iam.v1.Policy])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.iam.v1.Policy]: @googleapis_reference_link{google/iam/v1/policy.proto#L102}
  /// [google.iam.v1.SetIamPolicyRequest]: @googleapis_reference_link{google/iam/v1/iam_policy.proto#L101}
  ///
  // clang-format on
  StatusOr<google::iam::v1::Policy> SetIamPolicy(
      std::string const& resource, google::iam::v1::Policy const& policy,
      Options opts = {});

  // clang-format off
  ///
  /// Sets the IAM access control policy for the specified project, in the
  /// format `projects/{ProjectIdOrNumber}` e.g. projects/123.
  ///
  /// CAUTION: This method will replace the existing policy, and cannot be used
  /// to append additional IAM settings.
  ///
  /// Note: Removing service accounts from policies or changing their roles can
  /// render services completely inoperable. It is important to understand how
  /// the service account is being used before removing or updating its roles.
  ///
  /// The following constraints apply when using `setIamPolicy()`:
  ///
  /// + Project does not support `allUsers` and `allAuthenticatedUsers` as
  /// `members` in a `Binding` of a `Policy`.
  ///
  /// + The owner role can be granted to a `user`, `serviceAccount`, or a group
  /// that is part of an organization. For example,
  /// group@myownpersonaldomain.com could be added as an owner to a project in
  /// the myownpersonaldomain.com organization, but not the examplepetstore.com
  /// organization.
  ///
  /// + Service accounts can be made owners of a project directly
  /// without any restrictions. However, to be added as an owner, a user must be
  /// invited using the Cloud Platform console and must accept the invitation.
  ///
  /// + A user cannot be granted the owner role using `setIamPolicy()`. The user
  /// must be granted the owner role using the Cloud Platform Console and must
  /// explicitly accept the invitation.
  ///
  /// + Invitations to grant the owner role cannot be sent using
  /// `setIamPolicy()`;
  /// they must be sent only using the Cloud Platform Console.
  ///
  /// + If the project is not part of an organization, there must be at least
  /// one owner who has accepted the Terms of Service (ToS) agreement in the
  /// policy. Calling `setIamPolicy()` to remove the last ToS-accepted owner
  /// from the policy will fail. This restriction also applies to legacy
  /// projects that no longer have owners who have accepted the ToS. Edits to
  /// IAM policies will be rejected until the lack of a ToS-accepting owner is
  /// rectified. If the project is part of an organization, you can remove all
  /// owners, potentially making the organization inaccessible.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.iam.v1.SetIamPolicyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.iam.v1.Policy])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.iam.v1.Policy]: @googleapis_reference_link{google/iam/v1/policy.proto#L102}
  /// [google.iam.v1.SetIamPolicyRequest]: @googleapis_reference_link{google/iam/v1/iam_policy.proto#L101}
  ///
  // clang-format on
  StatusOr<google::iam::v1::Policy> SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const& request, Options opts = {});

  // clang-format off
  ///
  /// Returns permissions that a caller has on the specified project, in the
  /// format `projects/{ProjectIdOrNumber}` e.g. projects/123..
  ///
  /// @param resource  REQUIRED: The resource for which the policy detail is being requested.
  ///  See the operation documentation for the appropriate value for this field.
  /// @param permissions  The set of permissions to check for the `resource`. Permissions with
  ///  wildcards (such as '*' or 'storage.*') are not allowed. For more
  ///  information see
  ///  [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.iam.v1.TestIamPermissionsResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.iam.v1.TestIamPermissionsRequest]: @googleapis_reference_link{google/iam/v1/iam_policy.proto#L136}
  /// [google.iam.v1.TestIamPermissionsResponse]: @googleapis_reference_link{google/iam/v1/iam_policy.proto#L151}
  ///
  // clang-format on
  StatusOr<google::iam::v1::TestIamPermissionsResponse> TestIamPermissions(
      std::string const& resource, std::vector<std::string> const& permissions,
      Options opts = {});

  // clang-format off
  ///
  /// Returns permissions that a caller has on the specified project, in the
  /// format `projects/{ProjectIdOrNumber}` e.g. projects/123..
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.iam.v1.TestIamPermissionsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.iam.v1.TestIamPermissionsResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.iam.v1.TestIamPermissionsRequest]: @googleapis_reference_link{google/iam/v1/iam_policy.proto#L136}
  /// [google.iam.v1.TestIamPermissionsResponse]: @googleapis_reference_link{google/iam/v1/iam_policy.proto#L151}
  ///
  // clang-format on
  StatusOr<google::iam::v1::TestIamPermissionsResponse> TestIamPermissions(
      google::iam::v1::TestIamPermissionsRequest const& request,
      Options opts = {});

 private:
  std::shared_ptr<ProjectsConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace resourcemanager_v3
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RESOURCEMANAGER_V3_PROJECTS_CLIENT_H
