// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/recaptchaenterprise/v1/recaptchaenterprise.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RECAPTCHAENTERPRISE_V1_RECAPTCHA_ENTERPRISE_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RECAPTCHAENTERPRISE_V1_RECAPTCHA_ENTERPRISE_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/recaptchaenterprise/v1/recaptchaenterprise.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace recaptchaenterprise_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class RecaptchaEnterpriseServiceConnectionIdempotencyPolicy {
 public:
  virtual ~RecaptchaEnterpriseServiceConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<RecaptchaEnterpriseServiceConnectionIdempotencyPolicy>
  clone() const;

  virtual google::cloud::Idempotency CreateAssessment(
      google::cloud::recaptchaenterprise::v1::CreateAssessmentRequest const&
          request);

  virtual google::cloud::Idempotency AnnotateAssessment(
      google::cloud::recaptchaenterprise::v1::AnnotateAssessmentRequest const&
          request);

  virtual google::cloud::Idempotency CreateKey(
      google::cloud::recaptchaenterprise::v1::CreateKeyRequest const& request);

  virtual google::cloud::Idempotency ListKeys(
      google::cloud::recaptchaenterprise::v1::ListKeysRequest request);

  virtual google::cloud::Idempotency RetrieveLegacySecretKey(
      google::cloud::recaptchaenterprise::v1::
          RetrieveLegacySecretKeyRequest const& request);

  virtual google::cloud::Idempotency GetKey(
      google::cloud::recaptchaenterprise::v1::GetKeyRequest const& request);

  virtual google::cloud::Idempotency UpdateKey(
      google::cloud::recaptchaenterprise::v1::UpdateKeyRequest const& request);

  virtual google::cloud::Idempotency DeleteKey(
      google::cloud::recaptchaenterprise::v1::DeleteKeyRequest const& request);

  virtual google::cloud::Idempotency MigrateKey(
      google::cloud::recaptchaenterprise::v1::MigrateKeyRequest const& request);

  virtual google::cloud::Idempotency AddIpOverride(
      google::cloud::recaptchaenterprise::v1::AddIpOverrideRequest const&
          request);

  virtual google::cloud::Idempotency GetMetrics(
      google::cloud::recaptchaenterprise::v1::GetMetricsRequest const& request);

  virtual google::cloud::Idempotency CreateFirewallPolicy(
      google::cloud::recaptchaenterprise::v1::CreateFirewallPolicyRequest const&
          request);

  virtual google::cloud::Idempotency ListFirewallPolicies(
      google::cloud::recaptchaenterprise::v1::ListFirewallPoliciesRequest
          request);

  virtual google::cloud::Idempotency GetFirewallPolicy(
      google::cloud::recaptchaenterprise::v1::GetFirewallPolicyRequest const&
          request);

  virtual google::cloud::Idempotency UpdateFirewallPolicy(
      google::cloud::recaptchaenterprise::v1::UpdateFirewallPolicyRequest const&
          request);

  virtual google::cloud::Idempotency DeleteFirewallPolicy(
      google::cloud::recaptchaenterprise::v1::DeleteFirewallPolicyRequest const&
          request);

  virtual google::cloud::Idempotency ReorderFirewallPolicies(
      google::cloud::recaptchaenterprise::v1::
          ReorderFirewallPoliciesRequest const& request);

  virtual google::cloud::Idempotency ListRelatedAccountGroups(
      google::cloud::recaptchaenterprise::v1::ListRelatedAccountGroupsRequest
          request);

  virtual google::cloud::Idempotency ListRelatedAccountGroupMemberships(
      google::cloud::recaptchaenterprise::v1::
          ListRelatedAccountGroupMembershipsRequest request);

  virtual google::cloud::Idempotency SearchRelatedAccountGroupMemberships(
      google::cloud::recaptchaenterprise::v1::
          SearchRelatedAccountGroupMembershipsRequest request);
};

std::unique_ptr<RecaptchaEnterpriseServiceConnectionIdempotencyPolicy>
MakeDefaultRecaptchaEnterpriseServiceConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace recaptchaenterprise_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_RECAPTCHAENTERPRISE_V1_RECAPTCHA_ENTERPRISE_CONNECTION_IDEMPOTENCY_POLICY_H
