// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/pubsub/v1/pubsub.proto

#include "google/cloud/pubsub/admin/subscription_admin_connection.h"
#include "google/cloud/pubsub/admin/internal/subscription_admin_connection_impl.h"
#include "google/cloud/pubsub/admin/internal/subscription_admin_option_defaults.h"
#include "google/cloud/pubsub/admin/internal/subscription_admin_stub_factory.h"
#include "google/cloud/pubsub/admin/internal/subscription_admin_tracing_connection.h"
#include "google/cloud/pubsub/admin/subscription_admin_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace pubsub_admin {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

SubscriptionAdminConnection::~SubscriptionAdminConnection() = default;

StatusOr<google::pubsub::v1::Subscription>
SubscriptionAdminConnection::CreateSubscription(
    google::pubsub::v1::Subscription const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::pubsub::v1::Subscription>
SubscriptionAdminConnection::GetSubscription(
    google::pubsub::v1::GetSubscriptionRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::pubsub::v1::Subscription>
SubscriptionAdminConnection::UpdateSubscription(
    google::pubsub::v1::UpdateSubscriptionRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::pubsub::v1::Subscription>
SubscriptionAdminConnection::ListSubscriptions(
    google::pubsub::v1::
        ListSubscriptionsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::pubsub::v1::Subscription>>();
}

Status SubscriptionAdminConnection::DeleteSubscription(
    google::pubsub::v1::DeleteSubscriptionRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status SubscriptionAdminConnection::ModifyPushConfig(
    google::pubsub::v1::ModifyPushConfigRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::pubsub::v1::Snapshot> SubscriptionAdminConnection::GetSnapshot(
    google::pubsub::v1::GetSnapshotRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::pubsub::v1::Snapshot>
SubscriptionAdminConnection::ListSnapshots(
    google::pubsub::v1::
        ListSnapshotsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::pubsub::v1::Snapshot>>();
}

StatusOr<google::pubsub::v1::Snapshot>
SubscriptionAdminConnection::CreateSnapshot(
    google::pubsub::v1::CreateSnapshotRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::pubsub::v1::Snapshot>
SubscriptionAdminConnection::UpdateSnapshot(
    google::pubsub::v1::UpdateSnapshotRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status SubscriptionAdminConnection::DeleteSnapshot(
    google::pubsub::v1::DeleteSnapshotRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::pubsub::v1::SeekResponse> SubscriptionAdminConnection::Seek(
    google::pubsub::v1::SeekRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::Policy> SubscriptionAdminConnection::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::Policy> SubscriptionAdminConnection::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
SubscriptionAdminConnection::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<SubscriptionAdminConnection> MakeSubscriptionAdminConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 SubscriptionAdminPolicyOptionList>(options,
                                                                    __func__);
  options = pubsub_admin_internal::SubscriptionAdminDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = pubsub_admin_internal::CreateDefaultSubscriptionAdminStub(
      std::move(auth), options);
  return pubsub_admin_internal::MakeSubscriptionAdminTracingConnection(
      std::make_shared<pubsub_admin_internal::SubscriptionAdminConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace pubsub_admin
}  // namespace cloud
}  // namespace google
