// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_OSCONFIG_AGENTENDPOINT_V1_INTERNAL_AGENT_ENDPOINT_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_OSCONFIG_AGENTENDPOINT_V1_INTERNAL_AGENT_ENDPOINT_TRACING_CONNECTION_H

#include "google/cloud/osconfig/agentendpoint/v1/agent_endpoint_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace osconfig_agentendpoint_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class AgentEndpointServiceTracingConnection
    : public osconfig_agentendpoint_v1::AgentEndpointServiceConnection {
 public:
  ~AgentEndpointServiceTracingConnection() override = default;

  explicit AgentEndpointServiceTracingConnection(
      std::shared_ptr<osconfig_agentendpoint_v1::AgentEndpointServiceConnection>
          child);

  Options options() override { return child_->options(); }

  StreamRange<google::cloud::osconfig::agentendpoint::v1::
                  ReceiveTaskNotificationResponse>
  ReceiveTaskNotification(
      google::cloud::osconfig::agentendpoint::v1::
          ReceiveTaskNotificationRequest const& request) override;

  StatusOr<google::cloud::osconfig::agentendpoint::v1::StartNextTaskResponse>
  StartNextTask(
      google::cloud::osconfig::agentendpoint::v1::StartNextTaskRequest const&
          request) override;

  StatusOr<
      google::cloud::osconfig::agentendpoint::v1::ReportTaskProgressResponse>
  ReportTaskProgress(google::cloud::osconfig::agentendpoint::v1::
                         ReportTaskProgressRequest const& request) override;

  StatusOr<
      google::cloud::osconfig::agentendpoint::v1::ReportTaskCompleteResponse>
  ReportTaskComplete(google::cloud::osconfig::agentendpoint::v1::
                         ReportTaskCompleteRequest const& request) override;

  StatusOr<google::cloud::osconfig::agentendpoint::v1::RegisterAgentResponse>
  RegisterAgent(
      google::cloud::osconfig::agentendpoint::v1::RegisterAgentRequest const&
          request) override;

  StatusOr<google::cloud::osconfig::agentendpoint::v1::ReportInventoryResponse>
  ReportInventory(
      google::cloud::osconfig::agentendpoint::v1::ReportInventoryRequest const&
          request) override;

 private:
  std::shared_ptr<osconfig_agentendpoint_v1::AgentEndpointServiceConnection>
      child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<osconfig_agentendpoint_v1::AgentEndpointServiceConnection>
MakeAgentEndpointServiceTracingConnection(
    std::shared_ptr<osconfig_agentendpoint_v1::AgentEndpointServiceConnection>
        conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace osconfig_agentendpoint_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_OSCONFIG_AGENTENDPOINT_V1_INTERNAL_AGENT_ENDPOINT_TRACING_CONNECTION_H
