// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/optimization/v1/fleet_routing.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_OPTIMIZATION_V1_MOCKS_MOCK_FLEET_ROUTING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_OPTIMIZATION_V1_MOCKS_MOCK_FLEET_ROUTING_CONNECTION_H

#include "google/cloud/optimization/v1/fleet_routing_connection.h"
#include <gmock/gmock.h>

namespace google {
namespace cloud {
namespace optimization_v1_mocks {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/**
 * A class to mock `FleetRoutingConnection`.
 *
 * Application developers may want to test their code with simulated responses,
 * including errors, from an object of type `FleetRoutingClient`. To do so,
 * construct an object of type `FleetRoutingClient` with an instance of this
 * class. Then use the Google Test framework functions to program the behavior
 * of this mock.
 *
 * @see [This example][bq-mock] for how to test your application with GoogleTest.
 * While the example showcases types from the BigQuery library, the underlying
 * principles apply for any pair of `*Client` and `*Connection`.
 *
 * [bq-mock]: @cloud_cpp_docs_link{bigquery,bigquery-read-mock}
 */
class MockFleetRoutingConnection
    : public optimization_v1::FleetRoutingConnection {
 public:
  MOCK_METHOD(Options, options, (), (override));

  MOCK_METHOD(
      StatusOr<google::cloud::optimization::v1::OptimizeToursResponse>,
      OptimizeTours,
      (google::cloud::optimization::v1::OptimizeToursRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// BatchOptimizeTours(Matcher<google::cloud::optimization::v1::BatchOptimizeToursRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<
                  google::cloud::optimization::v1::BatchOptimizeToursResponse>>,
              BatchOptimizeTours,
              (google::cloud::optimization::v1::BatchOptimizeToursRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, BatchOptimizeTours(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>, BatchOptimizeTours,
              (NoAwaitTag,
               google::cloud::optimization::v1::BatchOptimizeToursRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// BatchOptimizeTours(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(future<StatusOr<
                  google::cloud::optimization::v1::BatchOptimizeToursResponse>>,
              BatchOptimizeTours,
              (google::longrunning::Operation const& operation), (override));
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace optimization_v1_mocks
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_OPTIMIZATION_V1_MOCKS_MOCK_FLEET_ROUTING_CONNECTION_H
