// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/networkservices/v1/network_services.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKSERVICES_V1_NETWORK_SERVICES_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKSERVICES_V1_NETWORK_SERVICES_CLIENT_H

#include "google/cloud/networkservices/v1/network_services_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace networkservices_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Service describing handlers for resources.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class NetworkServicesClient {
 public:
  explicit NetworkServicesClient(
      std::shared_ptr<NetworkServicesConnection> connection, Options opts = {});
  ~NetworkServicesClient();

  ///@{
  /// @name Copy and move support
  NetworkServicesClient(NetworkServicesClient const&) = default;
  NetworkServicesClient& operator=(NetworkServicesClient const&) = default;
  NetworkServicesClient(NetworkServicesClient&&) = default;
  NetworkServicesClient& operator=(NetworkServicesClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(NetworkServicesClient const& a,
                         NetworkServicesClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(NetworkServicesClient const& a,
                         NetworkServicesClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Lists EndpointPolicies in a given project and location.
  ///
  /// @param parent  Required. The project and location from which the EndpointPolicies should
  ///  be listed, specified in the format `projects/*/locations/global`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.networkservices.v1.EndpointPolicy], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.EndpointPolicy]: @googleapis_reference_link{google/cloud/networkservices/v1/endpoint_policy.proto#L49}
  /// [google.cloud.networkservices.v1.ListEndpointPoliciesRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/endpoint_policy.proto#L139}
  ///
  // clang-format on
  StreamRange<google::cloud::networkservices::v1::EndpointPolicy>
  ListEndpointPolicies(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists EndpointPolicies in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkservices.v1.ListEndpointPoliciesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.networkservices.v1.EndpointPolicy], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.EndpointPolicy]: @googleapis_reference_link{google/cloud/networkservices/v1/endpoint_policy.proto#L49}
  /// [google.cloud.networkservices.v1.ListEndpointPoliciesRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/endpoint_policy.proto#L139}
  ///
  // clang-format on
  StreamRange<google::cloud::networkservices::v1::EndpointPolicy>
  ListEndpointPolicies(
      google::cloud::networkservices::v1::ListEndpointPoliciesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single EndpointPolicy.
  ///
  /// @param name  Required. A name of the EndpointPolicy to get. Must be in the format
  ///  `projects/*/locations/global/endpointPolicies/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.networkservices.v1.EndpointPolicy])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.EndpointPolicy]: @googleapis_reference_link{google/cloud/networkservices/v1/endpoint_policy.proto#L49}
  /// [google.cloud.networkservices.v1.GetEndpointPolicyRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/endpoint_policy.proto#L171}
  ///
  // clang-format on
  StatusOr<google::cloud::networkservices::v1::EndpointPolicy>
  GetEndpointPolicy(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single EndpointPolicy.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkservices.v1.GetEndpointPolicyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.networkservices.v1.EndpointPolicy])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.EndpointPolicy]: @googleapis_reference_link{google/cloud/networkservices/v1/endpoint_policy.proto#L49}
  /// [google.cloud.networkservices.v1.GetEndpointPolicyRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/endpoint_policy.proto#L171}
  ///
  // clang-format on
  StatusOr<google::cloud::networkservices::v1::EndpointPolicy>
  GetEndpointPolicy(
      google::cloud::networkservices::v1::GetEndpointPolicyRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new EndpointPolicy in a given project and location.
  ///
  /// @param parent  Required. The parent resource of the EndpointPolicy. Must be in the
  ///  format `projects/*/locations/global`.
  /// @param endpoint_policy  Required. EndpointPolicy resource to be created.
  /// @param endpoint_policy_id  Required. Short name of the EndpointPolicy resource to be created.
  ///  E.g. "CustomECS".
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkservices.v1.EndpointPolicy] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.CreateEndpointPolicyRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/endpoint_policy.proto#L183}
  /// [google.cloud.networkservices.v1.EndpointPolicy]: @googleapis_reference_link{google/cloud/networkservices/v1/endpoint_policy.proto#L49}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::EndpointPolicy>>
  CreateEndpointPolicy(
      std::string const& parent,
      google::cloud::networkservices::v1::EndpointPolicy const& endpoint_policy,
      std::string const& endpoint_policy_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateEndpointPolicy
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateEndpointPolicy(
      NoAwaitTag, std::string const& parent,
      google::cloud::networkservices::v1::EndpointPolicy const& endpoint_policy,
      std::string const& endpoint_policy_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new EndpointPolicy in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkservices.v1.CreateEndpointPolicyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkservices.v1.EndpointPolicy] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.CreateEndpointPolicyRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/endpoint_policy.proto#L183}
  /// [google.cloud.networkservices.v1.EndpointPolicy]: @googleapis_reference_link{google/cloud/networkservices/v1/endpoint_policy.proto#L49}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::EndpointPolicy>>
  CreateEndpointPolicy(
      google::cloud::networkservices::v1::CreateEndpointPolicyRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateEndpointPolicy
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateEndpointPolicy(
      NoAwaitTag,
      google::cloud::networkservices::v1::CreateEndpointPolicyRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateEndpointPolicy
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::EndpointPolicy>>
  CreateEndpointPolicy(google::longrunning::Operation const& operation,
                       Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a single EndpointPolicy.
  ///
  /// @param endpoint_policy  Required. Updated EndpointPolicy resource.
  /// @param update_mask  Optional. Field mask is used to specify the fields to be overwritten in the
  ///  EndpointPolicy resource by the update.
  ///  The fields specified in the update_mask are relative to the resource, not
  ///  the full request. A field will be overwritten if it is in the mask. If the
  ///  user does not provide a mask then all fields will be overwritten.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkservices.v1.EndpointPolicy] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.EndpointPolicy]: @googleapis_reference_link{google/cloud/networkservices/v1/endpoint_policy.proto#L49}
  /// [google.cloud.networkservices.v1.UpdateEndpointPolicyRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/endpoint_policy.proto#L202}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::EndpointPolicy>>
  UpdateEndpointPolicy(
      google::cloud::networkservices::v1::EndpointPolicy const& endpoint_policy,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateEndpointPolicy
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateEndpointPolicy(
      NoAwaitTag,
      google::cloud::networkservices::v1::EndpointPolicy const& endpoint_policy,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a single EndpointPolicy.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkservices.v1.UpdateEndpointPolicyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkservices.v1.EndpointPolicy] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.EndpointPolicy]: @googleapis_reference_link{google/cloud/networkservices/v1/endpoint_policy.proto#L49}
  /// [google.cloud.networkservices.v1.UpdateEndpointPolicyRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/endpoint_policy.proto#L202}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::EndpointPolicy>>
  UpdateEndpointPolicy(
      google::cloud::networkservices::v1::UpdateEndpointPolicyRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateEndpointPolicy
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateEndpointPolicy(
      NoAwaitTag,
      google::cloud::networkservices::v1::UpdateEndpointPolicyRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateEndpointPolicy
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::EndpointPolicy>>
  UpdateEndpointPolicy(google::longrunning::Operation const& operation,
                       Options opts = {});

  // clang-format off
  ///
  /// Deletes a single EndpointPolicy.
  ///
  /// @param name  Required. A name of the EndpointPolicy to delete. Must be in the format
  ///  `projects/*/locations/global/endpointPolicies/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkservices.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.DeleteEndpointPolicyRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/endpoint_policy.proto#L216}
  /// [google.cloud.networkservices.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/networkservices/v1/common.proto#L31}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
  DeleteEndpointPolicy(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteEndpointPolicy
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteEndpointPolicy(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single EndpointPolicy.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkservices.v1.DeleteEndpointPolicyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkservices.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.DeleteEndpointPolicyRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/endpoint_policy.proto#L216}
  /// [google.cloud.networkservices.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/networkservices/v1/common.proto#L31}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
  DeleteEndpointPolicy(
      google::cloud::networkservices::v1::DeleteEndpointPolicyRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteEndpointPolicy
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteEndpointPolicy(
      NoAwaitTag,
      google::cloud::networkservices::v1::DeleteEndpointPolicyRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteEndpointPolicy
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
  DeleteEndpointPolicy(google::longrunning::Operation const& operation,
                       Options opts = {});

  // clang-format off
  ///
  /// Lists Gateways in a given project and location.
  ///
  /// @param parent  Required. The project and location from which the Gateways should be
  ///  listed, specified in the format `projects/*/locations/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.networkservices.v1.Gateway], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.Gateway]: @googleapis_reference_link{google/cloud/networkservices/v1/gateway.proto#L36}
  /// [google.cloud.networkservices.v1.ListGatewaysRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/gateway.proto#L108}
  ///
  // clang-format on
  StreamRange<google::cloud::networkservices::v1::Gateway> ListGateways(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists Gateways in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkservices.v1.ListGatewaysRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.networkservices.v1.Gateway], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.Gateway]: @googleapis_reference_link{google/cloud/networkservices/v1/gateway.proto#L36}
  /// [google.cloud.networkservices.v1.ListGatewaysRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/gateway.proto#L108}
  ///
  // clang-format on
  StreamRange<google::cloud::networkservices::v1::Gateway> ListGateways(
      google::cloud::networkservices::v1::ListGatewaysRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single Gateway.
  ///
  /// @param name  Required. A name of the Gateway to get. Must be in the format
  ///  `projects/*/locations/*/gateways/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.networkservices.v1.Gateway])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.Gateway]: @googleapis_reference_link{google/cloud/networkservices/v1/gateway.proto#L36}
  /// [google.cloud.networkservices.v1.GetGatewayRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/gateway.proto#L139}
  ///
  // clang-format on
  StatusOr<google::cloud::networkservices::v1::Gateway> GetGateway(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single Gateway.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkservices.v1.GetGatewayRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.networkservices.v1.Gateway])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.Gateway]: @googleapis_reference_link{google/cloud/networkservices/v1/gateway.proto#L36}
  /// [google.cloud.networkservices.v1.GetGatewayRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/gateway.proto#L139}
  ///
  // clang-format on
  StatusOr<google::cloud::networkservices::v1::Gateway> GetGateway(
      google::cloud::networkservices::v1::GetGatewayRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new Gateway in a given project and location.
  ///
  /// @param parent  Required. The parent resource of the Gateway. Must be in the
  ///  format `projects/*/locations/*`.
  /// @param gateway  Required. Gateway resource to be created.
  /// @param gateway_id  Required. Short name of the Gateway resource to be created.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkservices.v1.Gateway] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.CreateGatewayRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/gateway.proto#L151}
  /// [google.cloud.networkservices.v1.Gateway]: @googleapis_reference_link{google/cloud/networkservices/v1/gateway.proto#L36}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::Gateway>> CreateGateway(
      std::string const& parent,
      google::cloud::networkservices::v1::Gateway const& gateway,
      std::string const& gateway_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateGateway
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateGateway(
      NoAwaitTag, std::string const& parent,
      google::cloud::networkservices::v1::Gateway const& gateway,
      std::string const& gateway_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new Gateway in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkservices.v1.CreateGatewayRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkservices.v1.Gateway] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.CreateGatewayRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/gateway.proto#L151}
  /// [google.cloud.networkservices.v1.Gateway]: @googleapis_reference_link{google/cloud/networkservices/v1/gateway.proto#L36}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::Gateway>> CreateGateway(
      google::cloud::networkservices::v1::CreateGatewayRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateGateway
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateGateway(
      NoAwaitTag,
      google::cloud::networkservices::v1::CreateGatewayRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateGateway
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::Gateway>> CreateGateway(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a single Gateway.
  ///
  /// @param gateway  Required. Updated Gateway resource.
  /// @param update_mask  Optional. Field mask is used to specify the fields to be overwritten in the
  ///  Gateway resource by the update.
  ///  The fields specified in the update_mask are relative to the resource, not
  ///  the full request. A field will be overwritten if it is in the mask. If the
  ///  user does not provide a mask then all fields will be overwritten.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkservices.v1.Gateway] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.Gateway]: @googleapis_reference_link{google/cloud/networkservices/v1/gateway.proto#L36}
  /// [google.cloud.networkservices.v1.UpdateGatewayRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/gateway.proto#L169}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::Gateway>> UpdateGateway(
      google::cloud::networkservices::v1::Gateway const& gateway,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateGateway
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateGateway(
      NoAwaitTag, google::cloud::networkservices::v1::Gateway const& gateway,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a single Gateway.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkservices.v1.UpdateGatewayRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkservices.v1.Gateway] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.Gateway]: @googleapis_reference_link{google/cloud/networkservices/v1/gateway.proto#L36}
  /// [google.cloud.networkservices.v1.UpdateGatewayRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/gateway.proto#L169}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::Gateway>> UpdateGateway(
      google::cloud::networkservices::v1::UpdateGatewayRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateGateway
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateGateway(
      NoAwaitTag,
      google::cloud::networkservices::v1::UpdateGatewayRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateGateway
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::Gateway>> UpdateGateway(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single Gateway.
  ///
  /// @param name  Required. A name of the Gateway to delete. Must be in the format
  ///  `projects/*/locations/*/gateways/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkservices.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.DeleteGatewayRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/gateway.proto#L183}
  /// [google.cloud.networkservices.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/networkservices/v1/common.proto#L31}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
  DeleteGateway(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteGateway
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteGateway(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single Gateway.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkservices.v1.DeleteGatewayRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkservices.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.DeleteGatewayRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/gateway.proto#L183}
  /// [google.cloud.networkservices.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/networkservices/v1/common.proto#L31}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
  DeleteGateway(
      google::cloud::networkservices::v1::DeleteGatewayRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteGateway
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteGateway(
      NoAwaitTag,
      google::cloud::networkservices::v1::DeleteGatewayRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteGateway
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
  DeleteGateway(google::longrunning::Operation const& operation,
                Options opts = {});

  // clang-format off
  ///
  /// Lists GrpcRoutes in a given project and location.
  ///
  /// @param parent  Required. The project and location from which the GrpcRoutes should be
  ///  listed, specified in the format `projects/*/locations/global`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.networkservices.v1.GrpcRoute], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.GrpcRoute]: @googleapis_reference_link{google/cloud/networkservices/v1/grpc_route.proto#L35}
  /// [google.cloud.networkservices.v1.ListGrpcRoutesRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/grpc_route.proto#L340}
  ///
  // clang-format on
  StreamRange<google::cloud::networkservices::v1::GrpcRoute> ListGrpcRoutes(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists GrpcRoutes in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkservices.v1.ListGrpcRoutesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.networkservices.v1.GrpcRoute], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.GrpcRoute]: @googleapis_reference_link{google/cloud/networkservices/v1/grpc_route.proto#L35}
  /// [google.cloud.networkservices.v1.ListGrpcRoutesRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/grpc_route.proto#L340}
  ///
  // clang-format on
  StreamRange<google::cloud::networkservices::v1::GrpcRoute> ListGrpcRoutes(
      google::cloud::networkservices::v1::ListGrpcRoutesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single GrpcRoute.
  ///
  /// @param name  Required. A name of the GrpcRoute to get. Must be in the format
  ///  `projects/*/locations/global/grpcRoutes/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.networkservices.v1.GrpcRoute])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.GetGrpcRouteRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/grpc_route.proto#L371}
  /// [google.cloud.networkservices.v1.GrpcRoute]: @googleapis_reference_link{google/cloud/networkservices/v1/grpc_route.proto#L35}
  ///
  // clang-format on
  StatusOr<google::cloud::networkservices::v1::GrpcRoute> GetGrpcRoute(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single GrpcRoute.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkservices.v1.GetGrpcRouteRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.networkservices.v1.GrpcRoute])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.GetGrpcRouteRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/grpc_route.proto#L371}
  /// [google.cloud.networkservices.v1.GrpcRoute]: @googleapis_reference_link{google/cloud/networkservices/v1/grpc_route.proto#L35}
  ///
  // clang-format on
  StatusOr<google::cloud::networkservices::v1::GrpcRoute> GetGrpcRoute(
      google::cloud::networkservices::v1::GetGrpcRouteRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new GrpcRoute in a given project and location.
  ///
  /// @param parent  Required. The parent resource of the GrpcRoute. Must be in the
  ///  format `projects/*/locations/global`.
  /// @param grpc_route  Required. GrpcRoute resource to be created.
  /// @param grpc_route_id  Required. Short name of the GrpcRoute resource to be created.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkservices.v1.GrpcRoute] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.CreateGrpcRouteRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/grpc_route.proto#L383}
  /// [google.cloud.networkservices.v1.GrpcRoute]: @googleapis_reference_link{google/cloud/networkservices/v1/grpc_route.proto#L35}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::GrpcRoute>>
  CreateGrpcRoute(
      std::string const& parent,
      google::cloud::networkservices::v1::GrpcRoute const& grpc_route,
      std::string const& grpc_route_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateGrpcRoute
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateGrpcRoute(
      NoAwaitTag, std::string const& parent,
      google::cloud::networkservices::v1::GrpcRoute const& grpc_route,
      std::string const& grpc_route_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new GrpcRoute in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkservices.v1.CreateGrpcRouteRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkservices.v1.GrpcRoute] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.CreateGrpcRouteRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/grpc_route.proto#L383}
  /// [google.cloud.networkservices.v1.GrpcRoute]: @googleapis_reference_link{google/cloud/networkservices/v1/grpc_route.proto#L35}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::GrpcRoute>>
  CreateGrpcRoute(
      google::cloud::networkservices::v1::CreateGrpcRouteRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateGrpcRoute
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateGrpcRoute(
      NoAwaitTag,
      google::cloud::networkservices::v1::CreateGrpcRouteRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateGrpcRoute
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::GrpcRoute>>
  CreateGrpcRoute(google::longrunning::Operation const& operation,
                  Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a single GrpcRoute.
  ///
  /// @param grpc_route  Required. Updated GrpcRoute resource.
  /// @param update_mask  Optional. Field mask is used to specify the fields to be overwritten in the
  ///  GrpcRoute resource by the update.
  ///  The fields specified in the update_mask are relative to the resource, not
  ///  the full request. A field will be overwritten if it is in the mask. If the
  ///  user does not provide a mask then all fields will be overwritten.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkservices.v1.GrpcRoute] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.GrpcRoute]: @googleapis_reference_link{google/cloud/networkservices/v1/grpc_route.proto#L35}
  /// [google.cloud.networkservices.v1.UpdateGrpcRouteRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/grpc_route.proto#L401}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::GrpcRoute>>
  UpdateGrpcRoute(
      google::cloud::networkservices::v1::GrpcRoute const& grpc_route,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateGrpcRoute
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateGrpcRoute(
      NoAwaitTag,
      google::cloud::networkservices::v1::GrpcRoute const& grpc_route,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a single GrpcRoute.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkservices.v1.UpdateGrpcRouteRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkservices.v1.GrpcRoute] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.GrpcRoute]: @googleapis_reference_link{google/cloud/networkservices/v1/grpc_route.proto#L35}
  /// [google.cloud.networkservices.v1.UpdateGrpcRouteRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/grpc_route.proto#L401}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::GrpcRoute>>
  UpdateGrpcRoute(
      google::cloud::networkservices::v1::UpdateGrpcRouteRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateGrpcRoute
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateGrpcRoute(
      NoAwaitTag,
      google::cloud::networkservices::v1::UpdateGrpcRouteRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateGrpcRoute
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::GrpcRoute>>
  UpdateGrpcRoute(google::longrunning::Operation const& operation,
                  Options opts = {});

  // clang-format off
  ///
  /// Deletes a single GrpcRoute.
  ///
  /// @param name  Required. A name of the GrpcRoute to delete. Must be in the format
  ///  `projects/*/locations/global/grpcRoutes/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkservices.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.DeleteGrpcRouteRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/grpc_route.proto#L415}
  /// [google.cloud.networkservices.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/networkservices/v1/common.proto#L31}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
  DeleteGrpcRoute(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteGrpcRoute
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteGrpcRoute(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single GrpcRoute.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkservices.v1.DeleteGrpcRouteRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkservices.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.DeleteGrpcRouteRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/grpc_route.proto#L415}
  /// [google.cloud.networkservices.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/networkservices/v1/common.proto#L31}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
  DeleteGrpcRoute(
      google::cloud::networkservices::v1::DeleteGrpcRouteRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteGrpcRoute
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteGrpcRoute(
      NoAwaitTag,
      google::cloud::networkservices::v1::DeleteGrpcRouteRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteGrpcRoute
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
  DeleteGrpcRoute(google::longrunning::Operation const& operation,
                  Options opts = {});

  // clang-format off
  ///
  /// Lists HttpRoute in a given project and location.
  ///
  /// @param parent  Required. The project and location from which the HttpRoutes should be
  ///  listed, specified in the format `projects/*/locations/global`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.networkservices.v1.HttpRoute], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.HttpRoute]: @googleapis_reference_link{google/cloud/networkservices/v1/http_route.proto#L35}
  /// [google.cloud.networkservices.v1.ListHttpRoutesRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/http_route.proto#L541}
  ///
  // clang-format on
  StreamRange<google::cloud::networkservices::v1::HttpRoute> ListHttpRoutes(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists HttpRoute in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkservices.v1.ListHttpRoutesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.networkservices.v1.HttpRoute], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.HttpRoute]: @googleapis_reference_link{google/cloud/networkservices/v1/http_route.proto#L35}
  /// [google.cloud.networkservices.v1.ListHttpRoutesRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/http_route.proto#L541}
  ///
  // clang-format on
  StreamRange<google::cloud::networkservices::v1::HttpRoute> ListHttpRoutes(
      google::cloud::networkservices::v1::ListHttpRoutesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single HttpRoute.
  ///
  /// @param name  Required. A name of the HttpRoute to get. Must be in the format
  ///  `projects/*/locations/global/httpRoutes/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.networkservices.v1.HttpRoute])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.GetHttpRouteRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/http_route.proto#L572}
  /// [google.cloud.networkservices.v1.HttpRoute]: @googleapis_reference_link{google/cloud/networkservices/v1/http_route.proto#L35}
  ///
  // clang-format on
  StatusOr<google::cloud::networkservices::v1::HttpRoute> GetHttpRoute(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single HttpRoute.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkservices.v1.GetHttpRouteRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.networkservices.v1.HttpRoute])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.GetHttpRouteRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/http_route.proto#L572}
  /// [google.cloud.networkservices.v1.HttpRoute]: @googleapis_reference_link{google/cloud/networkservices/v1/http_route.proto#L35}
  ///
  // clang-format on
  StatusOr<google::cloud::networkservices::v1::HttpRoute> GetHttpRoute(
      google::cloud::networkservices::v1::GetHttpRouteRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new HttpRoute in a given project and location.
  ///
  /// @param parent  Required. The parent resource of the HttpRoute. Must be in the
  ///  format `projects/*/locations/global`.
  /// @param http_route  Required. HttpRoute resource to be created.
  /// @param http_route_id  Required. Short name of the HttpRoute resource to be created.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkservices.v1.HttpRoute] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.CreateHttpRouteRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/http_route.proto#L584}
  /// [google.cloud.networkservices.v1.HttpRoute]: @googleapis_reference_link{google/cloud/networkservices/v1/http_route.proto#L35}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::HttpRoute>>
  CreateHttpRoute(
      std::string const& parent,
      google::cloud::networkservices::v1::HttpRoute const& http_route,
      std::string const& http_route_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateHttpRoute
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateHttpRoute(
      NoAwaitTag, std::string const& parent,
      google::cloud::networkservices::v1::HttpRoute const& http_route,
      std::string const& http_route_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new HttpRoute in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkservices.v1.CreateHttpRouteRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkservices.v1.HttpRoute] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.CreateHttpRouteRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/http_route.proto#L584}
  /// [google.cloud.networkservices.v1.HttpRoute]: @googleapis_reference_link{google/cloud/networkservices/v1/http_route.proto#L35}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::HttpRoute>>
  CreateHttpRoute(
      google::cloud::networkservices::v1::CreateHttpRouteRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateHttpRoute
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateHttpRoute(
      NoAwaitTag,
      google::cloud::networkservices::v1::CreateHttpRouteRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateHttpRoute
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::HttpRoute>>
  CreateHttpRoute(google::longrunning::Operation const& operation,
                  Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a single HttpRoute.
  ///
  /// @param http_route  Required. Updated HttpRoute resource.
  /// @param update_mask  Optional. Field mask is used to specify the fields to be overwritten in the
  ///  HttpRoute resource by the update.
  ///  The fields specified in the update_mask are relative to the resource, not
  ///  the full request. A field will be overwritten if it is in the mask. If the
  ///  user does not provide a mask then all fields will be overwritten.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkservices.v1.HttpRoute] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.HttpRoute]: @googleapis_reference_link{google/cloud/networkservices/v1/http_route.proto#L35}
  /// [google.cloud.networkservices.v1.UpdateHttpRouteRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/http_route.proto#L602}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::HttpRoute>>
  UpdateHttpRoute(
      google::cloud::networkservices::v1::HttpRoute const& http_route,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateHttpRoute
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateHttpRoute(
      NoAwaitTag,
      google::cloud::networkservices::v1::HttpRoute const& http_route,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a single HttpRoute.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkservices.v1.UpdateHttpRouteRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkservices.v1.HttpRoute] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.HttpRoute]: @googleapis_reference_link{google/cloud/networkservices/v1/http_route.proto#L35}
  /// [google.cloud.networkservices.v1.UpdateHttpRouteRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/http_route.proto#L602}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::HttpRoute>>
  UpdateHttpRoute(
      google::cloud::networkservices::v1::UpdateHttpRouteRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateHttpRoute
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateHttpRoute(
      NoAwaitTag,
      google::cloud::networkservices::v1::UpdateHttpRouteRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateHttpRoute
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::HttpRoute>>
  UpdateHttpRoute(google::longrunning::Operation const& operation,
                  Options opts = {});

  // clang-format off
  ///
  /// Deletes a single HttpRoute.
  ///
  /// @param name  Required. A name of the HttpRoute to delete. Must be in the format
  ///  `projects/*/locations/global/httpRoutes/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkservices.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.DeleteHttpRouteRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/http_route.proto#L616}
  /// [google.cloud.networkservices.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/networkservices/v1/common.proto#L31}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
  DeleteHttpRoute(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteHttpRoute
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteHttpRoute(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single HttpRoute.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkservices.v1.DeleteHttpRouteRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkservices.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.DeleteHttpRouteRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/http_route.proto#L616}
  /// [google.cloud.networkservices.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/networkservices/v1/common.proto#L31}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
  DeleteHttpRoute(
      google::cloud::networkservices::v1::DeleteHttpRouteRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteHttpRoute
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteHttpRoute(
      NoAwaitTag,
      google::cloud::networkservices::v1::DeleteHttpRouteRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteHttpRoute
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
  DeleteHttpRoute(google::longrunning::Operation const& operation,
                  Options opts = {});

  // clang-format off
  ///
  /// Lists TcpRoute in a given project and location.
  ///
  /// @param parent  Required. The project and location from which the TcpRoutes should be
  ///  listed, specified in the format `projects/*/locations/global`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.networkservices.v1.TcpRoute], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.ListTcpRoutesRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/tcp_route.proto#L173}
  /// [google.cloud.networkservices.v1.TcpRoute]: @googleapis_reference_link{google/cloud/networkservices/v1/tcp_route.proto#L38}
  ///
  // clang-format on
  StreamRange<google::cloud::networkservices::v1::TcpRoute> ListTcpRoutes(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists TcpRoute in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkservices.v1.ListTcpRoutesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.networkservices.v1.TcpRoute], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.ListTcpRoutesRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/tcp_route.proto#L173}
  /// [google.cloud.networkservices.v1.TcpRoute]: @googleapis_reference_link{google/cloud/networkservices/v1/tcp_route.proto#L38}
  ///
  // clang-format on
  StreamRange<google::cloud::networkservices::v1::TcpRoute> ListTcpRoutes(
      google::cloud::networkservices::v1::ListTcpRoutesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single TcpRoute.
  ///
  /// @param name  Required. A name of the TcpRoute to get. Must be in the format
  ///  `projects/*/locations/global/tcpRoutes/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.networkservices.v1.TcpRoute])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.GetTcpRouteRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/tcp_route.proto#L204}
  /// [google.cloud.networkservices.v1.TcpRoute]: @googleapis_reference_link{google/cloud/networkservices/v1/tcp_route.proto#L38}
  ///
  // clang-format on
  StatusOr<google::cloud::networkservices::v1::TcpRoute> GetTcpRoute(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single TcpRoute.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkservices.v1.GetTcpRouteRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.networkservices.v1.TcpRoute])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.GetTcpRouteRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/tcp_route.proto#L204}
  /// [google.cloud.networkservices.v1.TcpRoute]: @googleapis_reference_link{google/cloud/networkservices/v1/tcp_route.proto#L38}
  ///
  // clang-format on
  StatusOr<google::cloud::networkservices::v1::TcpRoute> GetTcpRoute(
      google::cloud::networkservices::v1::GetTcpRouteRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new TcpRoute in a given project and location.
  ///
  /// @param parent  Required. The parent resource of the TcpRoute. Must be in the
  ///  format `projects/*/locations/global`.
  /// @param tcp_route  Required. TcpRoute resource to be created.
  /// @param tcp_route_id  Required. Short name of the TcpRoute resource to be created.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkservices.v1.TcpRoute] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.CreateTcpRouteRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/tcp_route.proto#L216}
  /// [google.cloud.networkservices.v1.TcpRoute]: @googleapis_reference_link{google/cloud/networkservices/v1/tcp_route.proto#L38}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::TcpRoute>> CreateTcpRoute(
      std::string const& parent,
      google::cloud::networkservices::v1::TcpRoute const& tcp_route,
      std::string const& tcp_route_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateTcpRoute
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateTcpRoute(
      NoAwaitTag, std::string const& parent,
      google::cloud::networkservices::v1::TcpRoute const& tcp_route,
      std::string const& tcp_route_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new TcpRoute in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkservices.v1.CreateTcpRouteRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkservices.v1.TcpRoute] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.CreateTcpRouteRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/tcp_route.proto#L216}
  /// [google.cloud.networkservices.v1.TcpRoute]: @googleapis_reference_link{google/cloud/networkservices/v1/tcp_route.proto#L38}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::TcpRoute>> CreateTcpRoute(
      google::cloud::networkservices::v1::CreateTcpRouteRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateTcpRoute
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateTcpRoute(
      NoAwaitTag,
      google::cloud::networkservices::v1::CreateTcpRouteRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateTcpRoute
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::TcpRoute>> CreateTcpRoute(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a single TcpRoute.
  ///
  /// @param tcp_route  Required. Updated TcpRoute resource.
  /// @param update_mask  Optional. Field mask is used to specify the fields to be overwritten in the
  ///  TcpRoute resource by the update.
  ///  The fields specified in the update_mask are relative to the resource, not
  ///  the full request. A field will be overwritten if it is in the mask. If the
  ///  user does not provide a mask then all fields will be overwritten.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkservices.v1.TcpRoute] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.TcpRoute]: @googleapis_reference_link{google/cloud/networkservices/v1/tcp_route.proto#L38}
  /// [google.cloud.networkservices.v1.UpdateTcpRouteRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/tcp_route.proto#L234}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::TcpRoute>> UpdateTcpRoute(
      google::cloud::networkservices::v1::TcpRoute const& tcp_route,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateTcpRoute
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateTcpRoute(
      NoAwaitTag, google::cloud::networkservices::v1::TcpRoute const& tcp_route,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a single TcpRoute.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkservices.v1.UpdateTcpRouteRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkservices.v1.TcpRoute] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.TcpRoute]: @googleapis_reference_link{google/cloud/networkservices/v1/tcp_route.proto#L38}
  /// [google.cloud.networkservices.v1.UpdateTcpRouteRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/tcp_route.proto#L234}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::TcpRoute>> UpdateTcpRoute(
      google::cloud::networkservices::v1::UpdateTcpRouteRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateTcpRoute
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateTcpRoute(
      NoAwaitTag,
      google::cloud::networkservices::v1::UpdateTcpRouteRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateTcpRoute
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::TcpRoute>> UpdateTcpRoute(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single TcpRoute.
  ///
  /// @param name  Required. A name of the TcpRoute to delete. Must be in the format
  ///  `projects/*/locations/global/tcpRoutes/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkservices.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.DeleteTcpRouteRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/tcp_route.proto#L248}
  /// [google.cloud.networkservices.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/networkservices/v1/common.proto#L31}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
  DeleteTcpRoute(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteTcpRoute
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteTcpRoute(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single TcpRoute.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkservices.v1.DeleteTcpRouteRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkservices.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.DeleteTcpRouteRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/tcp_route.proto#L248}
  /// [google.cloud.networkservices.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/networkservices/v1/common.proto#L31}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
  DeleteTcpRoute(
      google::cloud::networkservices::v1::DeleteTcpRouteRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteTcpRoute
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteTcpRoute(
      NoAwaitTag,
      google::cloud::networkservices::v1::DeleteTcpRouteRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteTcpRoute
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
  DeleteTcpRoute(google::longrunning::Operation const& operation,
                 Options opts = {});

  // clang-format off
  ///
  /// Lists TlsRoute in a given project and location.
  ///
  /// @param parent  Required. The project and location from which the TlsRoutes should be
  ///  listed, specified in the format `projects/*/locations/global`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.networkservices.v1.TlsRoute], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.ListTlsRoutesRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/tls_route.proto#L150}
  /// [google.cloud.networkservices.v1.TlsRoute]: @googleapis_reference_link{google/cloud/networkservices/v1/tls_route.proto#L34}
  ///
  // clang-format on
  StreamRange<google::cloud::networkservices::v1::TlsRoute> ListTlsRoutes(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists TlsRoute in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkservices.v1.ListTlsRoutesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.networkservices.v1.TlsRoute], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.ListTlsRoutesRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/tls_route.proto#L150}
  /// [google.cloud.networkservices.v1.TlsRoute]: @googleapis_reference_link{google/cloud/networkservices/v1/tls_route.proto#L34}
  ///
  // clang-format on
  StreamRange<google::cloud::networkservices::v1::TlsRoute> ListTlsRoutes(
      google::cloud::networkservices::v1::ListTlsRoutesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single TlsRoute.
  ///
  /// @param name  Required. A name of the TlsRoute to get. Must be in the format
  ///  `projects/*/locations/global/tlsRoutes/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.networkservices.v1.TlsRoute])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.GetTlsRouteRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/tls_route.proto#L181}
  /// [google.cloud.networkservices.v1.TlsRoute]: @googleapis_reference_link{google/cloud/networkservices/v1/tls_route.proto#L34}
  ///
  // clang-format on
  StatusOr<google::cloud::networkservices::v1::TlsRoute> GetTlsRoute(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single TlsRoute.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkservices.v1.GetTlsRouteRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.networkservices.v1.TlsRoute])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.GetTlsRouteRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/tls_route.proto#L181}
  /// [google.cloud.networkservices.v1.TlsRoute]: @googleapis_reference_link{google/cloud/networkservices/v1/tls_route.proto#L34}
  ///
  // clang-format on
  StatusOr<google::cloud::networkservices::v1::TlsRoute> GetTlsRoute(
      google::cloud::networkservices::v1::GetTlsRouteRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new TlsRoute in a given project and location.
  ///
  /// @param parent  Required. The parent resource of the TlsRoute. Must be in the
  ///  format `projects/*/locations/global`.
  /// @param tls_route  Required. TlsRoute resource to be created.
  /// @param tls_route_id  Required. Short name of the TlsRoute resource to be created.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkservices.v1.TlsRoute] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.CreateTlsRouteRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/tls_route.proto#L193}
  /// [google.cloud.networkservices.v1.TlsRoute]: @googleapis_reference_link{google/cloud/networkservices/v1/tls_route.proto#L34}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::TlsRoute>> CreateTlsRoute(
      std::string const& parent,
      google::cloud::networkservices::v1::TlsRoute const& tls_route,
      std::string const& tls_route_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateTlsRoute
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateTlsRoute(
      NoAwaitTag, std::string const& parent,
      google::cloud::networkservices::v1::TlsRoute const& tls_route,
      std::string const& tls_route_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new TlsRoute in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkservices.v1.CreateTlsRouteRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkservices.v1.TlsRoute] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.CreateTlsRouteRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/tls_route.proto#L193}
  /// [google.cloud.networkservices.v1.TlsRoute]: @googleapis_reference_link{google/cloud/networkservices/v1/tls_route.proto#L34}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::TlsRoute>> CreateTlsRoute(
      google::cloud::networkservices::v1::CreateTlsRouteRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateTlsRoute
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateTlsRoute(
      NoAwaitTag,
      google::cloud::networkservices::v1::CreateTlsRouteRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateTlsRoute
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::TlsRoute>> CreateTlsRoute(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a single TlsRoute.
  ///
  /// @param tls_route  Required. Updated TlsRoute resource.
  /// @param update_mask  Optional. Field mask is used to specify the fields to be overwritten in the
  ///  TlsRoute resource by the update.
  ///  The fields specified in the update_mask are relative to the resource, not
  ///  the full request. A field will be overwritten if it is in the mask. If the
  ///  user does not provide a mask then all fields will be overwritten.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkservices.v1.TlsRoute] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.TlsRoute]: @googleapis_reference_link{google/cloud/networkservices/v1/tls_route.proto#L34}
  /// [google.cloud.networkservices.v1.UpdateTlsRouteRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/tls_route.proto#L211}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::TlsRoute>> UpdateTlsRoute(
      google::cloud::networkservices::v1::TlsRoute const& tls_route,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateTlsRoute
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateTlsRoute(
      NoAwaitTag, google::cloud::networkservices::v1::TlsRoute const& tls_route,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a single TlsRoute.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkservices.v1.UpdateTlsRouteRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkservices.v1.TlsRoute] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.TlsRoute]: @googleapis_reference_link{google/cloud/networkservices/v1/tls_route.proto#L34}
  /// [google.cloud.networkservices.v1.UpdateTlsRouteRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/tls_route.proto#L211}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::TlsRoute>> UpdateTlsRoute(
      google::cloud::networkservices::v1::UpdateTlsRouteRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateTlsRoute
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateTlsRoute(
      NoAwaitTag,
      google::cloud::networkservices::v1::UpdateTlsRouteRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateTlsRoute
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::TlsRoute>> UpdateTlsRoute(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single TlsRoute.
  ///
  /// @param name  Required. A name of the TlsRoute to delete. Must be in the format
  ///  `projects/*/locations/global/tlsRoutes/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkservices.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.DeleteTlsRouteRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/tls_route.proto#L225}
  /// [google.cloud.networkservices.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/networkservices/v1/common.proto#L31}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
  DeleteTlsRoute(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteTlsRoute
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteTlsRoute(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single TlsRoute.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkservices.v1.DeleteTlsRouteRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkservices.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.DeleteTlsRouteRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/tls_route.proto#L225}
  /// [google.cloud.networkservices.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/networkservices/v1/common.proto#L31}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
  DeleteTlsRoute(
      google::cloud::networkservices::v1::DeleteTlsRouteRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteTlsRoute
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteTlsRoute(
      NoAwaitTag,
      google::cloud::networkservices::v1::DeleteTlsRouteRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteTlsRoute
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
  DeleteTlsRoute(google::longrunning::Operation const& operation,
                 Options opts = {});

  // clang-format off
  ///
  /// Lists ServiceBinding in a given project and location.
  ///
  /// @param parent  Required. The project and location from which the ServiceBindings should be
  ///  listed, specified in the format `projects/*/locations/global`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.networkservices.v1.ServiceBinding], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.ListServiceBindingsRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/service_binding.proto#L64}
  /// [google.cloud.networkservices.v1.ServiceBinding]: @googleapis_reference_link{google/cloud/networkservices/v1/service_binding.proto#L33}
  ///
  // clang-format on
  StreamRange<google::cloud::networkservices::v1::ServiceBinding>
  ListServiceBindings(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists ServiceBinding in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkservices.v1.ListServiceBindingsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.networkservices.v1.ServiceBinding], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.ListServiceBindingsRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/service_binding.proto#L64}
  /// [google.cloud.networkservices.v1.ServiceBinding]: @googleapis_reference_link{google/cloud/networkservices/v1/service_binding.proto#L33}
  ///
  // clang-format on
  StreamRange<google::cloud::networkservices::v1::ServiceBinding>
  ListServiceBindings(
      google::cloud::networkservices::v1::ListServiceBindingsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single ServiceBinding.
  ///
  /// @param name  Required. A name of the ServiceBinding to get. Must be in the format
  ///  `projects/*/locations/global/serviceBindings/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.networkservices.v1.ServiceBinding])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.GetServiceBindingRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/service_binding.proto#L95}
  /// [google.cloud.networkservices.v1.ServiceBinding]: @googleapis_reference_link{google/cloud/networkservices/v1/service_binding.proto#L33}
  ///
  // clang-format on
  StatusOr<google::cloud::networkservices::v1::ServiceBinding>
  GetServiceBinding(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single ServiceBinding.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkservices.v1.GetServiceBindingRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.networkservices.v1.ServiceBinding])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.GetServiceBindingRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/service_binding.proto#L95}
  /// [google.cloud.networkservices.v1.ServiceBinding]: @googleapis_reference_link{google/cloud/networkservices/v1/service_binding.proto#L33}
  ///
  // clang-format on
  StatusOr<google::cloud::networkservices::v1::ServiceBinding>
  GetServiceBinding(
      google::cloud::networkservices::v1::GetServiceBindingRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new ServiceBinding in a given project and location.
  ///
  /// @param parent  Required. The parent resource of the ServiceBinding. Must be in the
  ///  format `projects/*/locations/global`.
  /// @param service_binding  Required. ServiceBinding resource to be created.
  /// @param service_binding_id  Required. Short name of the ServiceBinding resource to be created.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkservices.v1.ServiceBinding] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.CreateServiceBindingRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/service_binding.proto#L107}
  /// [google.cloud.networkservices.v1.ServiceBinding]: @googleapis_reference_link{google/cloud/networkservices/v1/service_binding.proto#L33}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::ServiceBinding>>
  CreateServiceBinding(
      std::string const& parent,
      google::cloud::networkservices::v1::ServiceBinding const& service_binding,
      std::string const& service_binding_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateServiceBinding
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateServiceBinding(
      NoAwaitTag, std::string const& parent,
      google::cloud::networkservices::v1::ServiceBinding const& service_binding,
      std::string const& service_binding_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new ServiceBinding in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkservices.v1.CreateServiceBindingRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkservices.v1.ServiceBinding] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.CreateServiceBindingRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/service_binding.proto#L107}
  /// [google.cloud.networkservices.v1.ServiceBinding]: @googleapis_reference_link{google/cloud/networkservices/v1/service_binding.proto#L33}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::ServiceBinding>>
  CreateServiceBinding(
      google::cloud::networkservices::v1::CreateServiceBindingRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateServiceBinding
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateServiceBinding(
      NoAwaitTag,
      google::cloud::networkservices::v1::CreateServiceBindingRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateServiceBinding
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::ServiceBinding>>
  CreateServiceBinding(google::longrunning::Operation const& operation,
                       Options opts = {});

  // clang-format off
  ///
  /// Deletes a single ServiceBinding.
  ///
  /// @param name  Required. A name of the ServiceBinding to delete. Must be in the format
  ///  `projects/*/locations/global/serviceBindings/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkservices.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.DeleteServiceBindingRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/service_binding.proto#L125}
  /// [google.cloud.networkservices.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/networkservices/v1/common.proto#L31}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
  DeleteServiceBinding(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteServiceBinding
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteServiceBinding(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single ServiceBinding.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkservices.v1.DeleteServiceBindingRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkservices.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.DeleteServiceBindingRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/service_binding.proto#L125}
  /// [google.cloud.networkservices.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/networkservices/v1/common.proto#L31}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
  DeleteServiceBinding(
      google::cloud::networkservices::v1::DeleteServiceBindingRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteServiceBinding
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteServiceBinding(
      NoAwaitTag,
      google::cloud::networkservices::v1::DeleteServiceBindingRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteServiceBinding
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
  DeleteServiceBinding(google::longrunning::Operation const& operation,
                       Options opts = {});

  // clang-format off
  ///
  /// Lists Meshes in a given project and location.
  ///
  /// @param parent  Required. The project and location from which the Meshes should be
  ///  listed, specified in the format `projects/*/locations/global`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.networkservices.v1.Mesh], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.ListMeshesRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/mesh.proto#L73}
  /// [google.cloud.networkservices.v1.Mesh]: @googleapis_reference_link{google/cloud/networkservices/v1/mesh.proto#L35}
  ///
  // clang-format on
  StreamRange<google::cloud::networkservices::v1::Mesh> ListMeshes(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists Meshes in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkservices.v1.ListMeshesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.networkservices.v1.Mesh], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.ListMeshesRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/mesh.proto#L73}
  /// [google.cloud.networkservices.v1.Mesh]: @googleapis_reference_link{google/cloud/networkservices/v1/mesh.proto#L35}
  ///
  // clang-format on
  StreamRange<google::cloud::networkservices::v1::Mesh> ListMeshes(
      google::cloud::networkservices::v1::ListMeshesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single Mesh.
  ///
  /// @param name  Required. A name of the Mesh to get. Must be in the format
  ///  `projects/*/locations/global/meshes/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.networkservices.v1.Mesh])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.GetMeshRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/mesh.proto#L104}
  /// [google.cloud.networkservices.v1.Mesh]: @googleapis_reference_link{google/cloud/networkservices/v1/mesh.proto#L35}
  ///
  // clang-format on
  StatusOr<google::cloud::networkservices::v1::Mesh> GetMesh(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets details of a single Mesh.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkservices.v1.GetMeshRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.networkservices.v1.Mesh])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.GetMeshRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/mesh.proto#L104}
  /// [google.cloud.networkservices.v1.Mesh]: @googleapis_reference_link{google/cloud/networkservices/v1/mesh.proto#L35}
  ///
  // clang-format on
  StatusOr<google::cloud::networkservices::v1::Mesh> GetMesh(
      google::cloud::networkservices::v1::GetMeshRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new Mesh in a given project and location.
  ///
  /// @param parent  Required. The parent resource of the Mesh. Must be in the
  ///  format `projects/*/locations/global`.
  /// @param mesh  Required. Mesh resource to be created.
  /// @param mesh_id  Required. Short name of the Mesh resource to be created.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkservices.v1.Mesh] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.CreateMeshRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/mesh.proto#L116}
  /// [google.cloud.networkservices.v1.Mesh]: @googleapis_reference_link{google/cloud/networkservices/v1/mesh.proto#L35}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::Mesh>> CreateMesh(
      std::string const& parent,
      google::cloud::networkservices::v1::Mesh const& mesh,
      std::string const& mesh_id, Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateMesh
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateMesh(
      NoAwaitTag, std::string const& parent,
      google::cloud::networkservices::v1::Mesh const& mesh,
      std::string const& mesh_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new Mesh in a given project and location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkservices.v1.CreateMeshRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkservices.v1.Mesh] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.CreateMeshRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/mesh.proto#L116}
  /// [google.cloud.networkservices.v1.Mesh]: @googleapis_reference_link{google/cloud/networkservices/v1/mesh.proto#L35}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::Mesh>> CreateMesh(
      google::cloud::networkservices::v1::CreateMeshRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateMesh
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateMesh(
      NoAwaitTag,
      google::cloud::networkservices::v1::CreateMeshRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateMesh
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::Mesh>> CreateMesh(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a single Mesh.
  ///
  /// @param mesh  Required. Updated Mesh resource.
  /// @param update_mask  Optional. Field mask is used to specify the fields to be overwritten in the
  ///  Mesh resource by the update.
  ///  The fields specified in the update_mask are relative to the resource, not
  ///  the full request. A field will be overwritten if it is in the mask. If the
  ///  user does not provide a mask then all fields will be overwritten.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkservices.v1.Mesh] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.Mesh]: @googleapis_reference_link{google/cloud/networkservices/v1/mesh.proto#L35}
  /// [google.cloud.networkservices.v1.UpdateMeshRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/mesh.proto#L134}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::Mesh>> UpdateMesh(
      google::cloud::networkservices::v1::Mesh const& mesh,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateMesh
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateMesh(
      NoAwaitTag, google::cloud::networkservices::v1::Mesh const& mesh,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates the parameters of a single Mesh.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkservices.v1.UpdateMeshRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkservices.v1.Mesh] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.Mesh]: @googleapis_reference_link{google/cloud/networkservices/v1/mesh.proto#L35}
  /// [google.cloud.networkservices.v1.UpdateMeshRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/mesh.proto#L134}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::Mesh>> UpdateMesh(
      google::cloud::networkservices::v1::UpdateMeshRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateMesh
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateMesh(
      NoAwaitTag,
      google::cloud::networkservices::v1::UpdateMeshRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateMesh
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::Mesh>> UpdateMesh(
      google::longrunning::Operation const& operation, Options opts = {});

  // clang-format off
  ///
  /// Deletes a single Mesh.
  ///
  /// @param name  Required. A name of the Mesh to delete. Must be in the format
  ///  `projects/*/locations/global/meshes/*`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkservices.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.DeleteMeshRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/mesh.proto#L148}
  /// [google.cloud.networkservices.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/networkservices/v1/common.proto#L31}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
  DeleteMesh(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteMesh
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteMesh(NoAwaitTag,
                                                      std::string const& name,
                                                      Options opts = {});

  // clang-format off
  ///
  /// Deletes a single Mesh.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.networkservices.v1.DeleteMeshRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.networkservices.v1.OperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.networkservices.v1.DeleteMeshRequest]: @googleapis_reference_link{google/cloud/networkservices/v1/mesh.proto#L148}
  /// [google.cloud.networkservices.v1.OperationMetadata]: @googleapis_reference_link{google/cloud/networkservices/v1/common.proto#L31}
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
  DeleteMesh(
      google::cloud::networkservices::v1::DeleteMeshRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteMesh
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteMesh(
      NoAwaitTag,
      google::cloud::networkservices::v1::DeleteMeshRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteMesh
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::networkservices::v1::OperationMetadata>>
  DeleteMesh(google::longrunning::Operation const& operation,
             Options opts = {});

 private:
  std::shared_ptr<NetworkServicesConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace networkservices_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_NETWORKSERVICES_V1_NETWORK_SERVICES_CLIENT_H
