// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/networkconnectivity/v1/policy_based_routing.proto

#include "google/cloud/networkconnectivity/v1/internal/policy_based_routing_option_defaults.h"
#include "google/cloud/networkconnectivity/v1/policy_based_routing_connection.h"
#include "google/cloud/networkconnectivity/v1/policy_based_routing_options.h"
#include "google/cloud/internal/populate_common_options.h"
#include "google/cloud/internal/populate_grpc_options.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace networkconnectivity_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

namespace {
auto constexpr kBackoffScaling = 2.0;
}  // namespace

Options PolicyBasedRoutingServiceDefaultOptions(Options options) {
  options = internal::PopulateCommonOptions(
      std::move(options),
      "GOOGLE_CLOUD_CPP_POLICY_BASED_ROUTING_SERVICE_ENDPOINT", "",
      "GOOGLE_CLOUD_CPP_POLICY_BASED_ROUTING_SERVICE_AUTHORITY",
      "networkconnectivity.googleapis.com");
  options = internal::PopulateGrpcOptions(std::move(options));
  if (!options.has<networkconnectivity_v1::
                       PolicyBasedRoutingServiceRetryPolicyOption>()) {
    options.set<
        networkconnectivity_v1::PolicyBasedRoutingServiceRetryPolicyOption>(
        networkconnectivity_v1::PolicyBasedRoutingServiceLimitedTimeRetryPolicy(
            std::chrono::minutes(30))
            .clone());
  }
  if (!options.has<networkconnectivity_v1::
                       PolicyBasedRoutingServiceBackoffPolicyOption>()) {
    options.set<
        networkconnectivity_v1::PolicyBasedRoutingServiceBackoffPolicyOption>(
        ExponentialBackoffPolicy(
            std::chrono::seconds(0), std::chrono::seconds(1),
            std::chrono::minutes(5), kBackoffScaling, kBackoffScaling)
            .clone());
  }
  if (!options.has<networkconnectivity_v1::
                       PolicyBasedRoutingServicePollingPolicyOption>()) {
    options.set<
        networkconnectivity_v1::PolicyBasedRoutingServicePollingPolicyOption>(
        GenericPollingPolicy<
            networkconnectivity_v1::PolicyBasedRoutingServiceRetryPolicyOption::
                Type,
            networkconnectivity_v1::
                PolicyBasedRoutingServiceBackoffPolicyOption::Type>(
            options
                .get<networkconnectivity_v1::
                         PolicyBasedRoutingServiceRetryPolicyOption>()
                ->clone(),
            ExponentialBackoffPolicy(std::chrono::seconds(1),
                                     std::chrono::minutes(5), kBackoffScaling)
                .clone())
            .clone());
  }
  if (!options.has<
          networkconnectivity_v1::
              PolicyBasedRoutingServiceConnectionIdempotencyPolicyOption>()) {
    options.set<networkconnectivity_v1::
                    PolicyBasedRoutingServiceConnectionIdempotencyPolicyOption>(
        networkconnectivity_v1::
            MakeDefaultPolicyBasedRoutingServiceConnectionIdempotencyPolicy());
  }

  return options;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace networkconnectivity_v1_internal
}  // namespace cloud
}  // namespace google
