// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/logging/v2/logging.proto

#include "google/cloud/logging/v2/internal/logging_service_v2_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace logging_v2_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

LoggingServiceV2TracingConnection::LoggingServiceV2TracingConnection(
    std::shared_ptr<logging_v2::LoggingServiceV2Connection> child)
    : child_(std::move(child)) {}

Status LoggingServiceV2TracingConnection::DeleteLog(
    google::logging::v2::DeleteLogRequest const& request) {
  auto span =
      internal::MakeSpan("logging_v2::LoggingServiceV2Connection::DeleteLog");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteLog(request));
}

StatusOr<google::logging::v2::WriteLogEntriesResponse>
LoggingServiceV2TracingConnection::WriteLogEntries(
    google::logging::v2::WriteLogEntriesRequest const& request) {
  auto span = internal::MakeSpan(
      "logging_v2::LoggingServiceV2Connection::WriteLogEntries");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->WriteLogEntries(request));
}

StreamRange<google::logging::v2::LogEntry>
LoggingServiceV2TracingConnection::ListLogEntries(
    google::logging::v2::ListLogEntriesRequest request) {
  auto span = internal::MakeSpan(
      "logging_v2::LoggingServiceV2Connection::ListLogEntries");
  internal::OTelScope scope(span);
  auto sr = child_->ListLogEntries(std::move(request));
  return internal::MakeTracedStreamRange<google::logging::v2::LogEntry>(
      std::move(span), std::move(sr));
}

StreamRange<google::api::MonitoredResourceDescriptor>
LoggingServiceV2TracingConnection::ListMonitoredResourceDescriptors(
    google::logging::v2::ListMonitoredResourceDescriptorsRequest request) {
  auto span = internal::MakeSpan(
      "logging_v2::LoggingServiceV2Connection::"
      "ListMonitoredResourceDescriptors");
  internal::OTelScope scope(span);
  auto sr = child_->ListMonitoredResourceDescriptors(std::move(request));
  return internal::MakeTracedStreamRange<
      google::api::MonitoredResourceDescriptor>(std::move(span), std::move(sr));
}

StreamRange<std::string> LoggingServiceV2TracingConnection::ListLogs(
    google::logging::v2::ListLogsRequest request) {
  auto span =
      internal::MakeSpan("logging_v2::LoggingServiceV2Connection::ListLogs");
  internal::OTelScope scope(span);
  auto sr = child_->ListLogs(std::move(request));
  return internal::MakeTracedStreamRange<std::string>(std::move(span),
                                                      std::move(sr));
}

std::unique_ptr<::google::cloud::AsyncStreamingReadWriteRpc<
    google::logging::v2::TailLogEntriesRequest,
    google::logging::v2::TailLogEntriesResponse>>
LoggingServiceV2TracingConnection::AsyncTailLogEntries() {
  return child_->AsyncTailLogEntries();
}

future<StatusOr<google::logging::v2::WriteLogEntriesResponse>>
LoggingServiceV2TracingConnection::AsyncWriteLogEntries(
    google::logging::v2::WriteLogEntriesRequest const& request) {
  auto span = internal::MakeSpan(
      "logging_v2::LoggingServiceV2Connection::AsyncWriteLogEntries");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->AsyncWriteLogEntries(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<logging_v2::LoggingServiceV2Connection>
MakeLoggingServiceV2TracingConnection(
    std::shared_ptr<logging_v2::LoggingServiceV2Connection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<LoggingServiceV2TracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace logging_v2_internal
}  // namespace cloud
}  // namespace google
