// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/eventarc/publishing/v1/publisher.proto

#include "google/cloud/eventarc/publishing/v1/publisher_connection.h"
#include "google/cloud/eventarc/publishing/v1/internal/publisher_connection_impl.h"
#include "google/cloud/eventarc/publishing/v1/internal/publisher_option_defaults.h"
#include "google/cloud/eventarc/publishing/v1/internal/publisher_stub_factory.h"
#include "google/cloud/eventarc/publishing/v1/internal/publisher_tracing_connection.h"
#include "google/cloud/eventarc/publishing/v1/publisher_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace eventarc_publishing_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

PublisherConnection::~PublisherConnection() = default;

StatusOr<google::cloud::eventarc::publishing::v1::
             PublishChannelConnectionEventsResponse>
PublisherConnection::PublishChannelConnectionEvents(
    google::cloud::eventarc::publishing::v1::
        PublishChannelConnectionEventsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::eventarc::publishing::v1::PublishEventsResponse>
PublisherConnection::PublishEvents(
    google::cloud::eventarc::publishing::v1::PublishEventsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<PublisherConnection> MakePublisherConnection(Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 PublisherPolicyOptionList>(options, __func__);
  options = eventarc_publishing_v1_internal::PublisherDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = eventarc_publishing_v1_internal::CreateDefaultPublisherStub(
      std::move(auth), options);
  return eventarc_publishing_v1_internal::MakePublisherTracingConnection(
      std::make_shared<
          eventarc_publishing_v1_internal::PublisherConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace eventarc_publishing_v1
}  // namespace cloud
}  // namespace google
