// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/v2/intent.proto

#include "google/cloud/dialogflow_es/internal/intents_connection_impl.h"
#include "google/cloud/dialogflow_es/internal/intents_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dialogflow_es_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<dialogflow_es::IntentsRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<dialogflow_es::IntentsRetryPolicyOption>()->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<dialogflow_es::IntentsBackoffPolicyOption>()->clone();
}

std::unique_ptr<dialogflow_es::IntentsConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options.get<dialogflow_es::IntentsConnectionIdempotencyPolicyOption>()
      ->clone();
}

std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
  return options.get<dialogflow_es::IntentsPollingPolicyOption>()->clone();
}

}  // namespace

IntentsConnectionImpl::IntentsConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<dialogflow_es_internal::IntentsStub> stub, Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      IntentsConnection::options())) {}

StreamRange<google::cloud::dialogflow::v2::Intent>
IntentsConnectionImpl::ListIntents(
    google::cloud::dialogflow::v2::ListIntentsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListIntents(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::dialogflow::v2::Intent>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<dialogflow_es::IntentsRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::dialogflow::v2::ListIntentsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::dialogflow::v2::ListIntentsRequest const&
                       request) {
              return stub->ListIntents(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::dialogflow::v2::ListIntentsResponse r) {
        std::vector<google::cloud::dialogflow::v2::Intent> result(
            r.intents().size());
        auto& messages = *r.mutable_intents();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::dialogflow::v2::Intent>
IntentsConnectionImpl::GetIntent(
    google::cloud::dialogflow::v2::GetIntentRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetIntent(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::dialogflow::v2::GetIntentRequest const& request) {
        return stub_->GetIntent(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::dialogflow::v2::Intent>
IntentsConnectionImpl::CreateIntent(
    google::cloud::dialogflow::v2::CreateIntentRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateIntent(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::dialogflow::v2::CreateIntentRequest const& request) {
        return stub_->CreateIntent(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::dialogflow::v2::Intent>
IntentsConnectionImpl::UpdateIntent(
    google::cloud::dialogflow::v2::UpdateIntentRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateIntent(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::dialogflow::v2::UpdateIntentRequest const& request) {
        return stub_->UpdateIntent(context, options, request);
      },
      *current, request, __func__);
}

Status IntentsConnectionImpl::DeleteIntent(
    google::cloud::dialogflow::v2::DeleteIntentRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteIntent(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::dialogflow::v2::DeleteIntentRequest const& request) {
        return stub_->DeleteIntent(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::dialogflow::v2::BatchUpdateIntentsResponse>>
IntentsConnectionImpl::BatchUpdateIntents(
    google::cloud::dialogflow::v2::BatchUpdateIntentsRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->BatchUpdateIntents(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::dialogflow::v2::BatchUpdateIntentsResponse>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::dialogflow::v2::BatchUpdateIntentsRequest const&
              request) {
        return stub->AsyncBatchUpdateIntents(cq, std::move(context),
                                             std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::dialogflow::v2::BatchUpdateIntentsResponse>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
IntentsConnectionImpl::BatchUpdateIntents(
    NoAwaitTag,
    google::cloud::dialogflow::v2::BatchUpdateIntentsRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->BatchUpdateIntents(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::dialogflow::v2::BatchUpdateIntentsRequest const&
                 request) {
        return stub_->BatchUpdateIntents(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::dialogflow::v2::BatchUpdateIntentsResponse>>
IntentsConnectionImpl::BatchUpdateIntents(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata().Is<typename google::protobuf::Struct>()) {
    return make_ready_future<
        StatusOr<google::cloud::dialogflow::v2::BatchUpdateIntentsResponse>>(
        internal::InvalidArgumentError(
            "operation does not correspond to BatchUpdateIntents",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::dialogflow::v2::BatchUpdateIntentsResponse>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::dialogflow::v2::BatchUpdateIntentsResponse>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::protobuf::Struct>>
IntentsConnectionImpl::BatchDeleteIntents(
    google::cloud::dialogflow::v2::BatchDeleteIntentsRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->BatchDeleteIntents(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::protobuf::Struct>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::dialogflow::v2::BatchDeleteIntentsRequest const&
              request) {
        return stub->AsyncBatchDeleteIntents(cq, std::move(context),
                                             std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::protobuf::Struct>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
IntentsConnectionImpl::BatchDeleteIntents(
    NoAwaitTag,
    google::cloud::dialogflow::v2::BatchDeleteIntentsRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->BatchDeleteIntents(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::dialogflow::v2::BatchDeleteIntentsRequest const&
                 request) {
        return stub_->BatchDeleteIntents(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::protobuf::Struct>>
IntentsConnectionImpl::BatchDeleteIntents(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata().Is<typename google::protobuf::Struct>()) {
    return make_ready_future<StatusOr<google::protobuf::Struct>>(
        internal::InvalidArgumentError(
            "operation does not correspond to BatchDeleteIntents",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::protobuf::Struct>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::protobuf::Struct>,
      polling_policy(*current), __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_es_internal
}  // namespace cloud
}  // namespace google
