// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/v2/context.proto

#include "google/cloud/dialogflow_es/internal/contexts_metadata_decorator.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/url_encode.h"
#include "google/cloud/status_or.h"
#include <google/cloud/dialogflow/v2/context.grpc.pb.h>
#include <memory>
#include <string>
#include <utility>
#include <vector>

namespace google {
namespace cloud {
namespace dialogflow_es_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ContextsMetadata::ContextsMetadata(
    std::shared_ptr<ContextsStub> child,
    std::multimap<std::string, std::string> fixed_metadata,
    std::string api_client_header)
    : child_(std::move(child)),
      fixed_metadata_(std::move(fixed_metadata)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

StatusOr<google::cloud::dialogflow::v2::ListContextsResponse>
ContextsMetadata::ListContexts(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::v2::ListContextsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->ListContexts(context, options, request);
}

StatusOr<google::cloud::dialogflow::v2::Context> ContextsMetadata::GetContext(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::v2::GetContextRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->GetContext(context, options, request);
}

StatusOr<google::cloud::dialogflow::v2::Context>
ContextsMetadata::CreateContext(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::v2::CreateContextRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->CreateContext(context, options, request);
}

StatusOr<google::cloud::dialogflow::v2::Context>
ContextsMetadata::UpdateContext(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::v2::UpdateContextRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("context.name=",
                           internal::UrlEncode(request.context().name())));
  return child_->UpdateContext(context, options, request);
}

Status ContextsMetadata::DeleteContext(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::v2::DeleteContextRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("name=", internal::UrlEncode(request.name())));
  return child_->DeleteContext(context, options, request);
}

Status ContextsMetadata::DeleteAllContexts(
    grpc::ClientContext& context, Options const& options,
    google::cloud::dialogflow::v2::DeleteAllContextsRequest const& request) {
  SetMetadata(context, options,
              absl::StrCat("parent=", internal::UrlEncode(request.parent())));
  return child_->DeleteAllContexts(context, options, request);
}

void ContextsMetadata::SetMetadata(grpc::ClientContext& context,
                                   Options const& options,
                                   std::string const& request_params) {
  context.AddMetadata("x-goog-request-params", request_params);
  SetMetadata(context, options);
}

void ContextsMetadata::SetMetadata(grpc::ClientContext& context,
                                   Options const& options) {
  google::cloud::internal::SetMetadata(context, options, fixed_metadata_,
                                       api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_es_internal
}  // namespace cloud
}  // namespace google
