// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/cx/v3/session.proto

#include "google/cloud/dialogflow_cx/internal/sessions_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dialogflow_cx_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

SessionsTracingConnection::SessionsTracingConnection(
    std::shared_ptr<dialogflow_cx::SessionsConnection> child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::dialogflow::cx::v3::DetectIntentResponse>
SessionsTracingConnection::DetectIntent(
    google::cloud::dialogflow::cx::v3::DetectIntentRequest const& request) {
  auto span =
      internal::MakeSpan("dialogflow_cx::SessionsConnection::DetectIntent");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DetectIntent(request));
}

StreamRange<google::cloud::dialogflow::cx::v3::DetectIntentResponse>
SessionsTracingConnection::ServerStreamingDetectIntent(
    google::cloud::dialogflow::cx::v3::DetectIntentRequest const& request) {
  auto span = internal::MakeSpan(
      "dialogflow_cx::SessionsConnection::ServerStreamingDetectIntent");
  internal::OTelScope scope(span);
  auto sr = child_->ServerStreamingDetectIntent(request);
  return internal::MakeTracedStreamRange<
      google::cloud::dialogflow::cx::v3::DetectIntentResponse>(std::move(span),
                                                               std::move(sr));
}
std::unique_ptr<::google::cloud::AsyncStreamingReadWriteRpc<
    google::cloud::dialogflow::cx::v3::StreamingDetectIntentRequest,
    google::cloud::dialogflow::cx::v3::StreamingDetectIntentResponse>>
SessionsTracingConnection::AsyncStreamingDetectIntent() {
  return child_->AsyncStreamingDetectIntent();
}

StatusOr<google::cloud::dialogflow::cx::v3::MatchIntentResponse>
SessionsTracingConnection::MatchIntent(
    google::cloud::dialogflow::cx::v3::MatchIntentRequest const& request) {
  auto span =
      internal::MakeSpan("dialogflow_cx::SessionsConnection::MatchIntent");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->MatchIntent(request));
}

StatusOr<google::cloud::dialogflow::cx::v3::FulfillIntentResponse>
SessionsTracingConnection::FulfillIntent(
    google::cloud::dialogflow::cx::v3::FulfillIntentRequest const& request) {
  auto span =
      internal::MakeSpan("dialogflow_cx::SessionsConnection::FulfillIntent");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->FulfillIntent(request));
}

StatusOr<google::cloud::dialogflow::cx::v3::AnswerFeedback>
SessionsTracingConnection::SubmitAnswerFeedback(
    google::cloud::dialogflow::cx::v3::SubmitAnswerFeedbackRequest const&
        request) {
  auto span = internal::MakeSpan(
      "dialogflow_cx::SessionsConnection::SubmitAnswerFeedback");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->SubmitAnswerFeedback(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<dialogflow_cx::SessionsConnection>
MakeSessionsTracingConnection(
    std::shared_ptr<dialogflow_cx::SessionsConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<SessionsTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_cx_internal
}  // namespace cloud
}  // namespace google
