// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataplex/v1/metadata.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAPLEX_V1_METADATA_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAPLEX_V1_METADATA_CLIENT_H

#include "google/cloud/dataplex/v1/metadata_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace dataplex_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Metadata service manages metadata resources such as tables, filesets and
/// partitions.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class MetadataServiceClient {
 public:
  explicit MetadataServiceClient(
      std::shared_ptr<MetadataServiceConnection> connection, Options opts = {});
  ~MetadataServiceClient();

  ///@{
  /// @name Copy and move support
  MetadataServiceClient(MetadataServiceClient const&) = default;
  MetadataServiceClient& operator=(MetadataServiceClient const&) = default;
  MetadataServiceClient(MetadataServiceClient&&) = default;
  MetadataServiceClient& operator=(MetadataServiceClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(MetadataServiceClient const& a,
                         MetadataServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(MetadataServiceClient const& a,
                         MetadataServiceClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Create a metadata entity.
  ///
  /// @param parent  Required. The resource name of the parent zone:
  ///  `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}`.
  /// @param entity  Required. Entity resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.dataplex.v1.Entity])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dataplex.v1.CreateEntityRequest]: @googleapis_reference_link{google/cloud/dataplex/v1/metadata.proto#L114}
  /// [google.cloud.dataplex.v1.Entity]: @googleapis_reference_link{google/cloud/dataplex/v1/metadata.proto#L347}
  ///
  // clang-format on
  StatusOr<google::cloud::dataplex::v1::Entity> CreateEntity(
      std::string const& parent,
      google::cloud::dataplex::v1::Entity const& entity, Options opts = {});

  // clang-format off
  ///
  /// Create a metadata entity.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.dataplex.v1.CreateEntityRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.dataplex.v1.Entity])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dataplex.v1.CreateEntityRequest]: @googleapis_reference_link{google/cloud/dataplex/v1/metadata.proto#L114}
  /// [google.cloud.dataplex.v1.Entity]: @googleapis_reference_link{google/cloud/dataplex/v1/metadata.proto#L347}
  ///
  // clang-format on
  StatusOr<google::cloud::dataplex::v1::Entity> CreateEntity(
      google::cloud::dataplex::v1::CreateEntityRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Update a metadata entity. Only supports full resource update.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.dataplex.v1.UpdateEntityRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.dataplex.v1.Entity])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dataplex.v1.Entity]: @googleapis_reference_link{google/cloud/dataplex/v1/metadata.proto#L347}
  /// [google.cloud.dataplex.v1.UpdateEntityRequest]: @googleapis_reference_link{google/cloud/dataplex/v1/metadata.proto#L134}
  ///
  // clang-format on
  StatusOr<google::cloud::dataplex::v1::Entity> UpdateEntity(
      google::cloud::dataplex::v1::UpdateEntityRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Delete a metadata entity.
  ///
  /// @param name  Required. The resource name of the entity:
  ///  `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/entities/{entity_id}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dataplex.v1.DeleteEntityRequest]: @googleapis_reference_link{google/cloud/dataplex/v1/metadata.proto#L144}
  ///
  // clang-format on
  Status DeleteEntity(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Delete a metadata entity.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.dataplex.v1.DeleteEntityRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dataplex.v1.DeleteEntityRequest]: @googleapis_reference_link{google/cloud/dataplex/v1/metadata.proto#L144}
  ///
  // clang-format on
  Status DeleteEntity(
      google::cloud::dataplex::v1::DeleteEntityRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Get a metadata entity.
  ///
  /// @param name  Required. The resource name of the entity:
  ///  `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/entities/{entity_id}.`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.dataplex.v1.Entity])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dataplex.v1.Entity]: @googleapis_reference_link{google/cloud/dataplex/v1/metadata.proto#L347}
  /// [google.cloud.dataplex.v1.GetEntityRequest]: @googleapis_reference_link{google/cloud/dataplex/v1/metadata.proto#L216}
  ///
  // clang-format on
  StatusOr<google::cloud::dataplex::v1::Entity> GetEntity(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Get a metadata entity.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.dataplex.v1.GetEntityRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.dataplex.v1.Entity])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dataplex.v1.Entity]: @googleapis_reference_link{google/cloud/dataplex/v1/metadata.proto#L347}
  /// [google.cloud.dataplex.v1.GetEntityRequest]: @googleapis_reference_link{google/cloud/dataplex/v1/metadata.proto#L216}
  ///
  // clang-format on
  StatusOr<google::cloud::dataplex::v1::Entity> GetEntity(
      google::cloud::dataplex::v1::GetEntityRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// List metadata entities in a zone.
  ///
  /// @param parent  Required. The resource name of the parent zone:
  ///  `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.dataplex.v1.Entity], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dataplex.v1.Entity]: @googleapis_reference_link{google/cloud/dataplex/v1/metadata.proto#L347}
  /// [google.cloud.dataplex.v1.ListEntitiesRequest]: @googleapis_reference_link{google/cloud/dataplex/v1/metadata.proto#L158}
  ///
  // clang-format on
  StreamRange<google::cloud::dataplex::v1::Entity> ListEntities(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// List metadata entities in a zone.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.dataplex.v1.ListEntitiesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.dataplex.v1.Entity], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dataplex.v1.Entity]: @googleapis_reference_link{google/cloud/dataplex/v1/metadata.proto#L347}
  /// [google.cloud.dataplex.v1.ListEntitiesRequest]: @googleapis_reference_link{google/cloud/dataplex/v1/metadata.proto#L158}
  ///
  // clang-format on
  StreamRange<google::cloud::dataplex::v1::Entity> ListEntities(
      google::cloud::dataplex::v1::ListEntitiesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Create a metadata partition.
  ///
  /// @param parent  Required. The resource name of the parent zone:
  ///  `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/entities/{entity_id}`.
  /// @param partition  Required. Partition resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.dataplex.v1.Partition])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dataplex.v1.CreatePartitionRequest]: @googleapis_reference_link{google/cloud/dataplex/v1/metadata.proto#L288}
  /// [google.cloud.dataplex.v1.Partition]: @googleapis_reference_link{google/cloud/dataplex/v1/metadata.proto#L480}
  ///
  // clang-format on
  StatusOr<google::cloud::dataplex::v1::Partition> CreatePartition(
      std::string const& parent,
      google::cloud::dataplex::v1::Partition const& partition,
      Options opts = {});

  // clang-format off
  ///
  /// Create a metadata partition.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.dataplex.v1.CreatePartitionRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.dataplex.v1.Partition])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dataplex.v1.CreatePartitionRequest]: @googleapis_reference_link{google/cloud/dataplex/v1/metadata.proto#L288}
  /// [google.cloud.dataplex.v1.Partition]: @googleapis_reference_link{google/cloud/dataplex/v1/metadata.proto#L480}
  ///
  // clang-format on
  StatusOr<google::cloud::dataplex::v1::Partition> CreatePartition(
      google::cloud::dataplex::v1::CreatePartitionRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Delete a metadata partition.
  ///
  /// @param name  Required. The resource name of the partition.
  ///  format:
  ///  `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/entities/{entity_id}/partitions/{partition_value_path}`.
  ///  The {partition_value_path} segment consists of an ordered sequence of
  ///  partition values separated by "/". All values must be provided.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dataplex.v1.DeletePartitionRequest]: @googleapis_reference_link{google/cloud/dataplex/v1/metadata.proto#L305}
  ///
  // clang-format on
  Status DeletePartition(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Delete a metadata partition.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.dataplex.v1.DeletePartitionRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [`Status`] object. If the request failed, the
  ///     status contains the details of the failure.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dataplex.v1.DeletePartitionRequest]: @googleapis_reference_link{google/cloud/dataplex/v1/metadata.proto#L305}
  ///
  // clang-format on
  Status DeletePartition(
      google::cloud::dataplex::v1::DeletePartitionRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Get a metadata partition of an entity.
  ///
  /// @param name  Required. The resource name of the partition:
  ///  `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/entities/{entity_id}/partitions/{partition_value_path}`.
  ///  The {partition_value_path} segment consists of an ordered sequence of
  ///  partition values separated by "/". All values must be provided.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.dataplex.v1.Partition])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dataplex.v1.GetPartitionRequest]: @googleapis_reference_link{google/cloud/dataplex/v1/metadata.proto#L333}
  /// [google.cloud.dataplex.v1.Partition]: @googleapis_reference_link{google/cloud/dataplex/v1/metadata.proto#L480}
  ///
  // clang-format on
  StatusOr<google::cloud::dataplex::v1::Partition> GetPartition(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Get a metadata partition of an entity.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.dataplex.v1.GetPartitionRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.dataplex.v1.Partition])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dataplex.v1.GetPartitionRequest]: @googleapis_reference_link{google/cloud/dataplex/v1/metadata.proto#L333}
  /// [google.cloud.dataplex.v1.Partition]: @googleapis_reference_link{google/cloud/dataplex/v1/metadata.proto#L480}
  ///
  // clang-format on
  StatusOr<google::cloud::dataplex::v1::Partition> GetPartition(
      google::cloud::dataplex::v1::GetPartitionRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// List metadata partitions of an entity.
  ///
  /// @param parent  Required. The resource name of the parent entity:
  ///  `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/entities/{entity_id}`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.dataplex.v1.Partition], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dataplex.v1.ListPartitionsRequest]: @googleapis_reference_link{google/cloud/dataplex/v1/metadata.proto#L245}
  /// [google.cloud.dataplex.v1.Partition]: @googleapis_reference_link{google/cloud/dataplex/v1/metadata.proto#L480}
  ///
  // clang-format on
  StreamRange<google::cloud::dataplex::v1::Partition> ListPartitions(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// List metadata partitions of an entity.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.dataplex.v1.ListPartitionsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.dataplex.v1.Partition], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.dataplex.v1.ListPartitionsRequest]: @googleapis_reference_link{google/cloud/dataplex/v1/metadata.proto#L245}
  /// [google.cloud.dataplex.v1.Partition]: @googleapis_reference_link{google/cloud/dataplex/v1/metadata.proto#L480}
  ///
  // clang-format on
  StreamRange<google::cloud::dataplex::v1::Partition> ListPartitions(
      google::cloud::dataplex::v1::ListPartitionsRequest request,
      Options opts = {});

 private:
  std::shared_ptr<MetadataServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataplex_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_DATAPLEX_V1_METADATA_CLIENT_H
