// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataplex/v1/datascans.proto

#include "google/cloud/dataplex/v1/internal/data_scan_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dataplex_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

DataScanServiceTracingConnection::DataScanServiceTracingConnection(
    std::shared_ptr<dataplex_v1::DataScanServiceConnection> child)
    : child_(std::move(child)) {}

future<StatusOr<google::cloud::dataplex::v1::DataScan>>
DataScanServiceTracingConnection::CreateDataScan(
    google::cloud::dataplex::v1::CreateDataScanRequest const& request) {
  auto span = internal::MakeSpan(
      "dataplex_v1::DataScanServiceConnection::CreateDataScan");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateDataScan(request));
}

StatusOr<google::longrunning::Operation>
DataScanServiceTracingConnection::CreateDataScan(
    NoAwaitTag,
    google::cloud::dataplex::v1::CreateDataScanRequest const& request) {
  auto span = internal::MakeSpan(
      "dataplex_v1::DataScanServiceConnection::CreateDataScan");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->CreateDataScan(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::dataplex::v1::DataScan>>
DataScanServiceTracingConnection::CreateDataScan(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "dataplex_v1::DataScanServiceConnection::CreateDataScan");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateDataScan(operation));
}

future<StatusOr<google::cloud::dataplex::v1::DataScan>>
DataScanServiceTracingConnection::UpdateDataScan(
    google::cloud::dataplex::v1::UpdateDataScanRequest const& request) {
  auto span = internal::MakeSpan(
      "dataplex_v1::DataScanServiceConnection::UpdateDataScan");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateDataScan(request));
}

StatusOr<google::longrunning::Operation>
DataScanServiceTracingConnection::UpdateDataScan(
    NoAwaitTag,
    google::cloud::dataplex::v1::UpdateDataScanRequest const& request) {
  auto span = internal::MakeSpan(
      "dataplex_v1::DataScanServiceConnection::UpdateDataScan");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->UpdateDataScan(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::dataplex::v1::DataScan>>
DataScanServiceTracingConnection::UpdateDataScan(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "dataplex_v1::DataScanServiceConnection::UpdateDataScan");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateDataScan(operation));
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataScanServiceTracingConnection::DeleteDataScan(
    google::cloud::dataplex::v1::DeleteDataScanRequest const& request) {
  auto span = internal::MakeSpan(
      "dataplex_v1::DataScanServiceConnection::DeleteDataScan");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteDataScan(request));
}

StatusOr<google::longrunning::Operation>
DataScanServiceTracingConnection::DeleteDataScan(
    NoAwaitTag,
    google::cloud::dataplex::v1::DeleteDataScanRequest const& request) {
  auto span = internal::MakeSpan(
      "dataplex_v1::DataScanServiceConnection::DeleteDataScan");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeleteDataScan(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataScanServiceTracingConnection::DeleteDataScan(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "dataplex_v1::DataScanServiceConnection::DeleteDataScan");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteDataScan(operation));
}

StatusOr<google::cloud::dataplex::v1::DataScan>
DataScanServiceTracingConnection::GetDataScan(
    google::cloud::dataplex::v1::GetDataScanRequest const& request) {
  auto span =
      internal::MakeSpan("dataplex_v1::DataScanServiceConnection::GetDataScan");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetDataScan(request));
}

StreamRange<google::cloud::dataplex::v1::DataScan>
DataScanServiceTracingConnection::ListDataScans(
    google::cloud::dataplex::v1::ListDataScansRequest request) {
  auto span = internal::MakeSpan(
      "dataplex_v1::DataScanServiceConnection::ListDataScans");
  internal::OTelScope scope(span);
  auto sr = child_->ListDataScans(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::dataplex::v1::DataScan>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::dataplex::v1::RunDataScanResponse>
DataScanServiceTracingConnection::RunDataScan(
    google::cloud::dataplex::v1::RunDataScanRequest const& request) {
  auto span =
      internal::MakeSpan("dataplex_v1::DataScanServiceConnection::RunDataScan");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->RunDataScan(request));
}

StatusOr<google::cloud::dataplex::v1::DataScanJob>
DataScanServiceTracingConnection::GetDataScanJob(
    google::cloud::dataplex::v1::GetDataScanJobRequest const& request) {
  auto span = internal::MakeSpan(
      "dataplex_v1::DataScanServiceConnection::GetDataScanJob");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetDataScanJob(request));
}

StreamRange<google::cloud::dataplex::v1::DataScanJob>
DataScanServiceTracingConnection::ListDataScanJobs(
    google::cloud::dataplex::v1::ListDataScanJobsRequest request) {
  auto span = internal::MakeSpan(
      "dataplex_v1::DataScanServiceConnection::ListDataScanJobs");
  internal::OTelScope scope(span);
  auto sr = child_->ListDataScanJobs(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::dataplex::v1::DataScanJob>(std::move(span), std::move(sr));
}

StatusOr<google::cloud::dataplex::v1::GenerateDataQualityRulesResponse>
DataScanServiceTracingConnection::GenerateDataQualityRules(
    google::cloud::dataplex::v1::GenerateDataQualityRulesRequest const&
        request) {
  auto span = internal::MakeSpan(
      "dataplex_v1::DataScanServiceConnection::GenerateDataQualityRules");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GenerateDataQualityRules(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<dataplex_v1::DataScanServiceConnection>
MakeDataScanServiceTracingConnection(
    std::shared_ptr<dataplex_v1::DataScanServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<DataScanServiceTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataplex_v1_internal
}  // namespace cloud
}  // namespace google
