// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/contactcenterinsights/v1/contact_center_insights.proto

#include "google/cloud/contactcenterinsights/v1/internal/contact_center_insights_connection_impl.h"
#include "google/cloud/contactcenterinsights/v1/internal/contact_center_insights_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace contactcenterinsights_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<contactcenterinsights_v1::ContactCenterInsightsRetryPolicy>
retry_policy(Options const& options) {
  return options
      .get<contactcenterinsights_v1::ContactCenterInsightsRetryPolicyOption>()
      ->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options
      .get<contactcenterinsights_v1::ContactCenterInsightsBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<
    contactcenterinsights_v1::ContactCenterInsightsConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<contactcenterinsights_v1::
               ContactCenterInsightsConnectionIdempotencyPolicyOption>()
      ->clone();
}

std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
  return options
      .get<contactcenterinsights_v1::ContactCenterInsightsPollingPolicyOption>()
      ->clone();
}

}  // namespace

ContactCenterInsightsConnectionImpl::ContactCenterInsightsConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<
        contactcenterinsights_v1_internal::ContactCenterInsightsStub>
        stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options), ContactCenterInsightsConnection::options())) {}

StatusOr<google::cloud::contactcenterinsights::v1::Conversation>
ContactCenterInsightsConnectionImpl::CreateConversation(
    google::cloud::contactcenterinsights::v1::CreateConversationRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateConversation(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::contactcenterinsights::v1::
                 CreateConversationRequest const& request) {
        return stub_->CreateConversation(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::contactcenterinsights::v1::Conversation>>
ContactCenterInsightsConnectionImpl::UploadConversation(
    google::cloud::contactcenterinsights::v1::UploadConversationRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->UploadConversation(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::contactcenterinsights::v1::Conversation>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::cloud::contactcenterinsights::v1::
                         UploadConversationRequest const& request) {
        return stub->AsyncUploadConversation(cq, std::move(context),
                                             std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::contactcenterinsights::v1::Conversation>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsConnectionImpl::UploadConversation(
    NoAwaitTag,
    google::cloud::contactcenterinsights::v1::UploadConversationRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UploadConversation(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::contactcenterinsights::v1::
                 UploadConversationRequest const& request) {
        return stub_->UploadConversation(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::contactcenterinsights::v1::Conversation>>
ContactCenterInsightsConnectionImpl::UploadConversation(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::contactcenterinsights::v1::
                   UploadConversationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::contactcenterinsights::v1::Conversation>>(
        internal::InvalidArgumentError(
            "operation does not correspond to UploadConversation",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::contactcenterinsights::v1::Conversation>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::contactcenterinsights::v1::Conversation>,
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::contactcenterinsights::v1::Conversation>
ContactCenterInsightsConnectionImpl::UpdateConversation(
    google::cloud::contactcenterinsights::v1::UpdateConversationRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateConversation(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::contactcenterinsights::v1::
                 UpdateConversationRequest const& request) {
        return stub_->UpdateConversation(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::contactcenterinsights::v1::Conversation>
ContactCenterInsightsConnectionImpl::GetConversation(
    google::cloud::contactcenterinsights::v1::GetConversationRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetConversation(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::contactcenterinsights::v1::
                 GetConversationRequest const& request) {
        return stub_->GetConversation(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::contactcenterinsights::v1::Conversation>
ContactCenterInsightsConnectionImpl::ListConversations(
    google::cloud::contactcenterinsights::v1::ListConversationsRequest
        request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListConversations(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::contactcenterinsights::v1::Conversation>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<
           contactcenterinsights_v1::ContactCenterInsightsRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options, google::cloud::contactcenterinsights::v1::
                                      ListConversationsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::contactcenterinsights::v1::
                       ListConversationsRequest const& request) {
              return stub->ListConversations(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::contactcenterinsights::v1::ListConversationsResponse
             r) {
        std::vector<google::cloud::contactcenterinsights::v1::Conversation>
            result(r.conversations().size());
        auto& messages = *r.mutable_conversations();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

Status ContactCenterInsightsConnectionImpl::DeleteConversation(
    google::cloud::contactcenterinsights::v1::DeleteConversationRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteConversation(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::contactcenterinsights::v1::
                 DeleteConversationRequest const& request) {
        return stub_->DeleteConversation(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::contactcenterinsights::v1::Analysis>>
ContactCenterInsightsConnectionImpl::CreateAnalysis(
    google::cloud::contactcenterinsights::v1::CreateAnalysisRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->CreateAnalysis(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::contactcenterinsights::v1::Analysis>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::contactcenterinsights::v1::CreateAnalysisRequest const&
              request) {
        return stub->AsyncCreateAnalysis(cq, std::move(context),
                                         std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::contactcenterinsights::v1::Analysis>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsConnectionImpl::CreateAnalysis(
    NoAwaitTag,
    google::cloud::contactcenterinsights::v1::CreateAnalysisRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateAnalysis(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::contactcenterinsights::v1::CreateAnalysisRequest const&
              request) {
        return stub_->CreateAnalysis(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::contactcenterinsights::v1::Analysis>>
ContactCenterInsightsConnectionImpl::CreateAnalysis(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::contactcenterinsights::v1::
                   CreateAnalysisOperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::contactcenterinsights::v1::Analysis>>(
        internal::InvalidArgumentError(
            "operation does not correspond to CreateAnalysis",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::contactcenterinsights::v1::Analysis>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::contactcenterinsights::v1::Analysis>,
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::contactcenterinsights::v1::Analysis>
ContactCenterInsightsConnectionImpl::GetAnalysis(
    google::cloud::contactcenterinsights::v1::GetAnalysisRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetAnalysis(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::contactcenterinsights::v1::GetAnalysisRequest const&
                 request) {
        return stub_->GetAnalysis(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::contactcenterinsights::v1::Analysis>
ContactCenterInsightsConnectionImpl::ListAnalyses(
    google::cloud::contactcenterinsights::v1::ListAnalysesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListAnalyses(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::contactcenterinsights::v1::Analysis>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<
           contactcenterinsights_v1::ContactCenterInsightsRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::contactcenterinsights::v1::ListAnalysesRequest const&
              r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::contactcenterinsights::v1::
                       ListAnalysesRequest const& request) {
              return stub->ListAnalyses(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::contactcenterinsights::v1::ListAnalysesResponse r) {
        std::vector<google::cloud::contactcenterinsights::v1::Analysis> result(
            r.analyses().size());
        auto& messages = *r.mutable_analyses();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

Status ContactCenterInsightsConnectionImpl::DeleteAnalysis(
    google::cloud::contactcenterinsights::v1::DeleteAnalysisRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteAnalysis(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::contactcenterinsights::v1::DeleteAnalysisRequest const&
              request) {
        return stub_->DeleteAnalysis(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::BulkAnalyzeConversationsResponse>>
ContactCenterInsightsConnectionImpl::BulkAnalyzeConversations(
    google::cloud::contactcenterinsights::v1::
        BulkAnalyzeConversationsRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->BulkAnalyzeConversations(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::contactcenterinsights::v1::
          BulkAnalyzeConversationsResponse>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::cloud::contactcenterinsights::v1::
                         BulkAnalyzeConversationsRequest const& request) {
        return stub->AsyncBulkAnalyzeConversations(cq, std::move(context),
                                                   std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::contactcenterinsights::v1::
              BulkAnalyzeConversationsResponse>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsConnectionImpl::BulkAnalyzeConversations(
    NoAwaitTag, google::cloud::contactcenterinsights::v1::
                    BulkAnalyzeConversationsRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->BulkAnalyzeConversations(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::contactcenterinsights::v1::
                 BulkAnalyzeConversationsRequest const& request) {
        return stub_->BulkAnalyzeConversations(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::BulkAnalyzeConversationsResponse>>
ContactCenterInsightsConnectionImpl::BulkAnalyzeConversations(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::contactcenterinsights::v1::
                   BulkAnalyzeConversationsMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::contactcenterinsights::v1::
                                          BulkAnalyzeConversationsResponse>>(
        internal::InvalidArgumentError(
            "operation does not correspond to BulkAnalyzeConversations",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::contactcenterinsights::v1::
          BulkAnalyzeConversationsResponse>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::contactcenterinsights::v1::
              BulkAnalyzeConversationsResponse>,
      polling_policy(*current), __func__);
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::BulkDeleteConversationsResponse>>
ContactCenterInsightsConnectionImpl::BulkDeleteConversations(
    google::cloud::contactcenterinsights::v1::
        BulkDeleteConversationsRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->BulkDeleteConversations(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::contactcenterinsights::v1::
          BulkDeleteConversationsResponse>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::cloud::contactcenterinsights::v1::
                         BulkDeleteConversationsRequest const& request) {
        return stub->AsyncBulkDeleteConversations(cq, std::move(context),
                                                  std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::contactcenterinsights::v1::
              BulkDeleteConversationsResponse>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsConnectionImpl::BulkDeleteConversations(
    NoAwaitTag, google::cloud::contactcenterinsights::v1::
                    BulkDeleteConversationsRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->BulkDeleteConversations(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::contactcenterinsights::v1::
                 BulkDeleteConversationsRequest const& request) {
        return stub_->BulkDeleteConversations(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::BulkDeleteConversationsResponse>>
ContactCenterInsightsConnectionImpl::BulkDeleteConversations(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::contactcenterinsights::v1::
                   BulkDeleteConversationsMetadata>()) {
    return make_ready_future<StatusOr<google::cloud::contactcenterinsights::v1::
                                          BulkDeleteConversationsResponse>>(
        internal::InvalidArgumentError(
            "operation does not correspond to BulkDeleteConversations",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::contactcenterinsights::v1::
          BulkDeleteConversationsResponse>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::contactcenterinsights::v1::
              BulkDeleteConversationsResponse>,
      polling_policy(*current), __func__);
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::IngestConversationsResponse>>
ContactCenterInsightsConnectionImpl::IngestConversations(
    google::cloud::contactcenterinsights::v1::IngestConversationsRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->IngestConversations(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::contactcenterinsights::v1::IngestConversationsResponse>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::cloud::contactcenterinsights::v1::
                         IngestConversationsRequest const& request) {
        return stub->AsyncIngestConversations(cq, std::move(context),
                                              std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::contactcenterinsights::v1::
              IngestConversationsResponse>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsConnectionImpl::IngestConversations(
    NoAwaitTag,
    google::cloud::contactcenterinsights::v1::IngestConversationsRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->IngestConversations(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::contactcenterinsights::v1::
                 IngestConversationsRequest const& request) {
        return stub_->IngestConversations(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::IngestConversationsResponse>>
ContactCenterInsightsConnectionImpl::IngestConversations(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::contactcenterinsights::v1::
                   IngestConversationsMetadata>()) {
    return make_ready_future<StatusOr<
        google::cloud::contactcenterinsights::v1::IngestConversationsResponse>>(
        internal::InvalidArgumentError(
            "operation does not correspond to IngestConversations",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::contactcenterinsights::v1::IngestConversationsResponse>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::contactcenterinsights::v1::
              IngestConversationsResponse>,
      polling_policy(*current), __func__);
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::ExportInsightsDataResponse>>
ContactCenterInsightsConnectionImpl::ExportInsightsData(
    google::cloud::contactcenterinsights::v1::ExportInsightsDataRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->ExportInsightsData(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::contactcenterinsights::v1::ExportInsightsDataResponse>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::cloud::contactcenterinsights::v1::
                         ExportInsightsDataRequest const& request) {
        return stub->AsyncExportInsightsData(cq, std::move(context),
                                             std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::contactcenterinsights::v1::ExportInsightsDataResponse>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsConnectionImpl::ExportInsightsData(
    NoAwaitTag,
    google::cloud::contactcenterinsights::v1::ExportInsightsDataRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ExportInsightsData(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::contactcenterinsights::v1::
                 ExportInsightsDataRequest const& request) {
        return stub_->ExportInsightsData(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::ExportInsightsDataResponse>>
ContactCenterInsightsConnectionImpl::ExportInsightsData(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::contactcenterinsights::v1::
                   ExportInsightsDataMetadata>()) {
    return make_ready_future<StatusOr<
        google::cloud::contactcenterinsights::v1::ExportInsightsDataResponse>>(
        internal::InvalidArgumentError(
            "operation does not correspond to ExportInsightsData",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::contactcenterinsights::v1::ExportInsightsDataResponse>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::contactcenterinsights::v1::ExportInsightsDataResponse>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::contactcenterinsights::v1::IssueModel>>
ContactCenterInsightsConnectionImpl::CreateIssueModel(
    google::cloud::contactcenterinsights::v1::CreateIssueModelRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->CreateIssueModel(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::contactcenterinsights::v1::IssueModel>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::cloud::contactcenterinsights::v1::
                         CreateIssueModelRequest const& request) {
        return stub->AsyncCreateIssueModel(cq, std::move(context),
                                           std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::contactcenterinsights::v1::IssueModel>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsConnectionImpl::CreateIssueModel(
    NoAwaitTag,
    google::cloud::contactcenterinsights::v1::CreateIssueModelRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateIssueModel(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::contactcenterinsights::v1::
                 CreateIssueModelRequest const& request) {
        return stub_->CreateIssueModel(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::contactcenterinsights::v1::IssueModel>>
ContactCenterInsightsConnectionImpl::CreateIssueModel(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::contactcenterinsights::v1::
                   CreateIssueModelMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::contactcenterinsights::v1::IssueModel>>(
        internal::InvalidArgumentError(
            "operation does not correspond to CreateIssueModel",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::contactcenterinsights::v1::IssueModel>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::contactcenterinsights::v1::IssueModel>,
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::contactcenterinsights::v1::IssueModel>
ContactCenterInsightsConnectionImpl::UpdateIssueModel(
    google::cloud::contactcenterinsights::v1::UpdateIssueModelRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateIssueModel(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::contactcenterinsights::v1::
                 UpdateIssueModelRequest const& request) {
        return stub_->UpdateIssueModel(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::contactcenterinsights::v1::IssueModel>
ContactCenterInsightsConnectionImpl::GetIssueModel(
    google::cloud::contactcenterinsights::v1::GetIssueModelRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetIssueModel(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::contactcenterinsights::v1::GetIssueModelRequest const&
              request) {
        return stub_->GetIssueModel(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::contactcenterinsights::v1::ListIssueModelsResponse>
ContactCenterInsightsConnectionImpl::ListIssueModels(
    google::cloud::contactcenterinsights::v1::ListIssueModelsRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ListIssueModels(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::contactcenterinsights::v1::
                 ListIssueModelsRequest const& request) {
        return stub_->ListIssueModels(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::DeleteIssueModelMetadata>>
ContactCenterInsightsConnectionImpl::DeleteIssueModel(
    google::cloud::contactcenterinsights::v1::DeleteIssueModelRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->DeleteIssueModel(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::contactcenterinsights::v1::DeleteIssueModelMetadata>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::cloud::contactcenterinsights::v1::
                         DeleteIssueModelRequest const& request) {
        return stub->AsyncDeleteIssueModel(cq, std::move(context),
                                           std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::contactcenterinsights::v1::DeleteIssueModelMetadata>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsConnectionImpl::DeleteIssueModel(
    NoAwaitTag,
    google::cloud::contactcenterinsights::v1::DeleteIssueModelRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteIssueModel(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::contactcenterinsights::v1::
                 DeleteIssueModelRequest const& request) {
        return stub_->DeleteIssueModel(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::DeleteIssueModelMetadata>>
ContactCenterInsightsConnectionImpl::DeleteIssueModel(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::contactcenterinsights::v1::
                   DeleteIssueModelMetadata>()) {
    return make_ready_future<StatusOr<
        google::cloud::contactcenterinsights::v1::DeleteIssueModelMetadata>>(
        internal::InvalidArgumentError(
            "operation does not correspond to DeleteIssueModel",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::contactcenterinsights::v1::DeleteIssueModelMetadata>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::contactcenterinsights::v1::DeleteIssueModelMetadata>,
      polling_policy(*current), __func__);
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::DeployIssueModelResponse>>
ContactCenterInsightsConnectionImpl::DeployIssueModel(
    google::cloud::contactcenterinsights::v1::DeployIssueModelRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->DeployIssueModel(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::contactcenterinsights::v1::DeployIssueModelResponse>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::cloud::contactcenterinsights::v1::
                         DeployIssueModelRequest const& request) {
        return stub->AsyncDeployIssueModel(cq, std::move(context),
                                           std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::contactcenterinsights::v1::DeployIssueModelResponse>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsConnectionImpl::DeployIssueModel(
    NoAwaitTag,
    google::cloud::contactcenterinsights::v1::DeployIssueModelRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeployIssueModel(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::contactcenterinsights::v1::
                 DeployIssueModelRequest const& request) {
        return stub_->DeployIssueModel(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::DeployIssueModelResponse>>
ContactCenterInsightsConnectionImpl::DeployIssueModel(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::contactcenterinsights::v1::
                   DeployIssueModelMetadata>()) {
    return make_ready_future<StatusOr<
        google::cloud::contactcenterinsights::v1::DeployIssueModelResponse>>(
        internal::InvalidArgumentError(
            "operation does not correspond to DeployIssueModel",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::contactcenterinsights::v1::DeployIssueModelResponse>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::contactcenterinsights::v1::DeployIssueModelResponse>,
      polling_policy(*current), __func__);
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::UndeployIssueModelResponse>>
ContactCenterInsightsConnectionImpl::UndeployIssueModel(
    google::cloud::contactcenterinsights::v1::UndeployIssueModelRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->UndeployIssueModel(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::contactcenterinsights::v1::UndeployIssueModelResponse>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::cloud::contactcenterinsights::v1::
                         UndeployIssueModelRequest const& request) {
        return stub->AsyncUndeployIssueModel(cq, std::move(context),
                                             std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::contactcenterinsights::v1::UndeployIssueModelResponse>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
ContactCenterInsightsConnectionImpl::UndeployIssueModel(
    NoAwaitTag,
    google::cloud::contactcenterinsights::v1::UndeployIssueModelRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UndeployIssueModel(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::contactcenterinsights::v1::
                 UndeployIssueModelRequest const& request) {
        return stub_->UndeployIssueModel(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<
    google::cloud::contactcenterinsights::v1::UndeployIssueModelResponse>>
ContactCenterInsightsConnectionImpl::UndeployIssueModel(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::contactcenterinsights::v1::
                   UndeployIssueModelMetadata>()) {
    return make_ready_future<StatusOr<
        google::cloud::contactcenterinsights::v1::UndeployIssueModelResponse>>(
        internal::InvalidArgumentError(
            "operation does not correspond to UndeployIssueModel",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::contactcenterinsights::v1::UndeployIssueModelResponse>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::contactcenterinsights::v1::UndeployIssueModelResponse>,
      polling_policy(*current), __func__);
}

StatusOr<google::cloud::contactcenterinsights::v1::Issue>
ContactCenterInsightsConnectionImpl::GetIssue(
    google::cloud::contactcenterinsights::v1::GetIssueRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetIssue(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::contactcenterinsights::v1::GetIssueRequest const&
                 request) {
        return stub_->GetIssue(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::contactcenterinsights::v1::ListIssuesResponse>
ContactCenterInsightsConnectionImpl::ListIssues(
    google::cloud::contactcenterinsights::v1::ListIssuesRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->ListIssues(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::contactcenterinsights::v1::ListIssuesRequest const&
                 request) {
        return stub_->ListIssues(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::contactcenterinsights::v1::Issue>
ContactCenterInsightsConnectionImpl::UpdateIssue(
    google::cloud::contactcenterinsights::v1::UpdateIssueRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateIssue(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::contactcenterinsights::v1::UpdateIssueRequest const&
                 request) {
        return stub_->UpdateIssue(context, options, request);
      },
      *current, request, __func__);
}

Status ContactCenterInsightsConnectionImpl::DeleteIssue(
    google::cloud::contactcenterinsights::v1::DeleteIssueRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteIssue(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::contactcenterinsights::v1::DeleteIssueRequest const&
                 request) {
        return stub_->DeleteIssue(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<
    google::cloud::contactcenterinsights::v1::CalculateIssueModelStatsResponse>
ContactCenterInsightsConnectionImpl::CalculateIssueModelStats(
    google::cloud::contactcenterinsights::v1::
        CalculateIssueModelStatsRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CalculateIssueModelStats(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::contactcenterinsights::v1::
                 CalculateIssueModelStatsRequest const& request) {
        return stub_->CalculateIssueModelStats(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::contactcenterinsights::v1::PhraseMatcher>
ContactCenterInsightsConnectionImpl::CreatePhraseMatcher(
    google::cloud::contactcenterinsights::v1::CreatePhraseMatcherRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreatePhraseMatcher(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::contactcenterinsights::v1::
                 CreatePhraseMatcherRequest const& request) {
        return stub_->CreatePhraseMatcher(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::contactcenterinsights::v1::PhraseMatcher>
ContactCenterInsightsConnectionImpl::GetPhraseMatcher(
    google::cloud::contactcenterinsights::v1::GetPhraseMatcherRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetPhraseMatcher(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::contactcenterinsights::v1::
                 GetPhraseMatcherRequest const& request) {
        return stub_->GetPhraseMatcher(context, options, request);
      },
      *current, request, __func__);
}

StreamRange<google::cloud::contactcenterinsights::v1::PhraseMatcher>
ContactCenterInsightsConnectionImpl::ListPhraseMatchers(
    google::cloud::contactcenterinsights::v1::ListPhraseMatchersRequest
        request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListPhraseMatchers(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::contactcenterinsights::v1::PhraseMatcher>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<
           contactcenterinsights_v1::ContactCenterInsightsRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options, google::cloud::contactcenterinsights::v1::
                                      ListPhraseMatchersRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::contactcenterinsights::v1::
                       ListPhraseMatchersRequest const& request) {
              return stub->ListPhraseMatchers(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::contactcenterinsights::v1::ListPhraseMatchersResponse
             r) {
        std::vector<google::cloud::contactcenterinsights::v1::PhraseMatcher>
            result(r.phrase_matchers().size());
        auto& messages = *r.mutable_phrase_matchers();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

Status ContactCenterInsightsConnectionImpl::DeletePhraseMatcher(
    google::cloud::contactcenterinsights::v1::DeletePhraseMatcherRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeletePhraseMatcher(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::contactcenterinsights::v1::
                 DeletePhraseMatcherRequest const& request) {
        return stub_->DeletePhraseMatcher(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::contactcenterinsights::v1::PhraseMatcher>
ContactCenterInsightsConnectionImpl::UpdatePhraseMatcher(
    google::cloud::contactcenterinsights::v1::UpdatePhraseMatcherRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdatePhraseMatcher(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::contactcenterinsights::v1::
                 UpdatePhraseMatcherRequest const& request) {
        return stub_->UpdatePhraseMatcher(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::contactcenterinsights::v1::CalculateStatsResponse>
ContactCenterInsightsConnectionImpl::CalculateStats(
    google::cloud::contactcenterinsights::v1::CalculateStatsRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CalculateStats(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::contactcenterinsights::v1::CalculateStatsRequest const&
              request) {
        return stub_->CalculateStats(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::contactcenterinsights::v1::Settings>
ContactCenterInsightsConnectionImpl::GetSettings(
    google::cloud::contactcenterinsights::v1::GetSettingsRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetSettings(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::contactcenterinsights::v1::GetSettingsRequest const&
                 request) {
        return stub_->GetSettings(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::contactcenterinsights::v1::Settings>
ContactCenterInsightsConnectionImpl::UpdateSettings(
    google::cloud::contactcenterinsights::v1::UpdateSettingsRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateSettings(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::contactcenterinsights::v1::UpdateSettingsRequest const&
              request) {
        return stub_->UpdateSettings(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::contactcenterinsights::v1::View>
ContactCenterInsightsConnectionImpl::CreateView(
    google::cloud::contactcenterinsights::v1::CreateViewRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateView(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::contactcenterinsights::v1::CreateViewRequest const&
                 request) {
        return stub_->CreateView(context, options, request);
      },
      *current, request, __func__);
}

StatusOr<google::cloud::contactcenterinsights::v1::View>
ContactCenterInsightsConnectionImpl::GetView(
    google::cloud::contactcenterinsights::v1::GetViewRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetView(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::contactcenterinsights::v1::GetViewRequest const&
                 request) { return stub_->GetView(context, options, request); },
      *current, request, __func__);
}

StreamRange<google::cloud::contactcenterinsights::v1::View>
ContactCenterInsightsConnectionImpl::ListViews(
    google::cloud::contactcenterinsights::v1::ListViewsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListViews(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::contactcenterinsights::v1::View>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<
           contactcenterinsights_v1::ContactCenterInsightsRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::contactcenterinsights::v1::ListViewsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::contactcenterinsights::v1::
                       ListViewsRequest const& request) {
              return stub->ListViews(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::contactcenterinsights::v1::ListViewsResponse r) {
        std::vector<google::cloud::contactcenterinsights::v1::View> result(
            r.views().size());
        auto& messages = *r.mutable_views();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::contactcenterinsights::v1::View>
ContactCenterInsightsConnectionImpl::UpdateView(
    google::cloud::contactcenterinsights::v1::UpdateViewRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateView(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::contactcenterinsights::v1::UpdateViewRequest const&
                 request) {
        return stub_->UpdateView(context, options, request);
      },
      *current, request, __func__);
}

Status ContactCenterInsightsConnectionImpl::DeleteView(
    google::cloud::contactcenterinsights::v1::DeleteViewRequest const&
        request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteView(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::contactcenterinsights::v1::DeleteViewRequest const&
                 request) {
        return stub_->DeleteView(context, options, request);
      },
      *current, request, __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace contactcenterinsights_v1_internal
}  // namespace cloud
}  // namespace google
