// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/snapshots/v1/snapshots.proto

#include "google/cloud/compute/snapshots/v1/internal/snapshots_rest_metadata_decorator.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/rest_set_metadata.h"
#include "google/cloud/status_or.h"
#include "absl/strings/str_format.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_snapshots_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

SnapshotsRestMetadata::SnapshotsRestMetadata(
    std::shared_ptr<SnapshotsRestStub> child, std::string api_client_header)
    : child_(std::move(child)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
SnapshotsRestMetadata::AsyncDeleteSnapshot(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::snapshots::v1::DeleteSnapshotRequest const&
        request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncDeleteSnapshot(cq, std::move(rest_context),
                                     std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
SnapshotsRestMetadata::DeleteSnapshot(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::snapshots::v1::DeleteSnapshotRequest const&
        request) {
  SetMetadata(rest_context, options);
  return child_->DeleteSnapshot(rest_context, options, request);
}

StatusOr<google::cloud::cpp::compute::v1::Snapshot>
SnapshotsRestMetadata::GetSnapshot(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::snapshots::v1::GetSnapshotRequest const&
        request) {
  SetMetadata(rest_context, options);
  return child_->GetSnapshot(rest_context, options, request);
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
SnapshotsRestMetadata::GetIamPolicy(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::snapshots::v1::GetIamPolicyRequest const&
        request) {
  SetMetadata(rest_context, options);
  return child_->GetIamPolicy(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
SnapshotsRestMetadata::AsyncInsertSnapshot(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::snapshots::v1::InsertSnapshotRequest const&
        request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncInsertSnapshot(cq, std::move(rest_context),
                                     std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
SnapshotsRestMetadata::InsertSnapshot(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::snapshots::v1::InsertSnapshotRequest const&
        request) {
  SetMetadata(rest_context, options);
  return child_->InsertSnapshot(rest_context, options, request);
}

StatusOr<google::cloud::cpp::compute::v1::SnapshotList>
SnapshotsRestMetadata::ListSnapshots(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::snapshots::v1::ListSnapshotsRequest const&
        request) {
  SetMetadata(rest_context, options);
  return child_->ListSnapshots(rest_context, options, request);
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
SnapshotsRestMetadata::SetIamPolicy(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::snapshots::v1::SetIamPolicyRequest const&
        request) {
  SetMetadata(rest_context, options);
  return child_->SetIamPolicy(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
SnapshotsRestMetadata::AsyncSetLabels(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::snapshots::v1::SetLabelsRequest const&
        request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncSetLabels(cq, std::move(rest_context), std::move(options),
                                request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
SnapshotsRestMetadata::SetLabels(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::snapshots::v1::SetLabelsRequest const&
        request) {
  SetMetadata(rest_context, options);
  return child_->SetLabels(rest_context, options, request);
}

StatusOr<google::cloud::cpp::compute::v1::TestPermissionsResponse>
SnapshotsRestMetadata::TestIamPermissions(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::snapshots::v1::TestIamPermissionsRequest const&
        request) {
  SetMetadata(rest_context, options);
  return child_->TestIamPermissions(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
SnapshotsRestMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::global_operations::v1::
        GetOperationRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncGetOperation(cq, std::move(rest_context),
                                   std::move(options), request);
}

future<Status> SnapshotsRestMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::global_operations::v1::
        DeleteOperationRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncCancelOperation(cq, std::move(rest_context),
                                      std::move(options), request);
}

void SnapshotsRestMetadata::SetMetadata(
    rest_internal::RestContext& rest_context, Options const& options,
    std::vector<std::string> const& params) {
  google::cloud::rest_internal::SetMetadata(rest_context, options, params,
                                            api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_snapshots_v1_internal
}  // namespace cloud
}  // namespace google
