// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/routers/v1/routers.proto

#include "google/cloud/compute/routers/v1/internal/routers_rest_logging_decorator.h"
#include "google/cloud/internal/log_wrapper.h"
#include "google/cloud/status_or.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_routers_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

RoutersRestLogging::RoutersRestLogging(std::shared_ptr<RoutersRestStub> child,
                                       TracingOptions tracing_options,
                                       std::set<std::string> components)
    : child_(std::move(child)),
      tracing_options_(std::move(tracing_options)),
      components_(std::move(components)) {}

StatusOr<google::cloud::cpp::compute::v1::RouterAggregatedList>
RoutersRestLogging::AggregatedListRouters(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::routers::v1::
        AggregatedListRoutersRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](rest_internal::RestContext& rest_context, Options const& options,
             google::cloud::cpp::compute::routers::v1::
                 AggregatedListRoutersRequest const& request) {
        return child_->AggregatedListRouters(rest_context, options, request);
      },
      rest_context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RoutersRestLogging::AsyncDeleteRouter(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::routers::v1::DeleteRouterRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          CompletionQueue& cq,
          std::unique_ptr<rest_internal::RestContext> rest_context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::cpp::compute::routers::v1::DeleteRouterRequest const&
              request) {
        return child_->AsyncDeleteRouter(cq, std::move(rest_context),
                                         std::move(options), request);
      },
      cq, std::move(rest_context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
RoutersRestLogging::DeleteRouter(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::routers::v1::DeleteRouterRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          rest_internal::RestContext& rest_context, Options const& options,
          google::cloud::cpp::compute::routers::v1::DeleteRouterRequest const&
              request) {
        return child_->DeleteRouter(rest_context, options, request);
      },
      rest_context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::cpp::compute::v1::Router> RoutersRestLogging::GetRouter(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::routers::v1::GetRouterRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](rest_internal::RestContext& rest_context, Options const& options,
             google::cloud::cpp::compute::routers::v1::GetRouterRequest const&
                 request) {
        return child_->GetRouter(rest_context, options, request);
      },
      rest_context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::cpp::compute::v1::NatIpInfoResponse>
RoutersRestLogging::GetNatIpInfo(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::routers::v1::GetNatIpInfoRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          rest_internal::RestContext& rest_context, Options const& options,
          google::cloud::cpp::compute::routers::v1::GetNatIpInfoRequest const&
              request) {
        return child_->GetNatIpInfo(rest_context, options, request);
      },
      rest_context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::cpp::compute::v1::VmEndpointNatMappingsList>
RoutersRestLogging::GetNatMappingInfo(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::routers::v1::GetNatMappingInfoRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](rest_internal::RestContext& rest_context, Options const& options,
             google::cloud::cpp::compute::routers::v1::
                 GetNatMappingInfoRequest const& request) {
        return child_->GetNatMappingInfo(rest_context, options, request);
      },
      rest_context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::cpp::compute::v1::RouterStatusResponse>
RoutersRestLogging::GetRouterStatus(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::routers::v1::GetRouterStatusRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](rest_internal::RestContext& rest_context, Options const& options,
             google::cloud::cpp::compute::routers::v1::
                 GetRouterStatusRequest const& request) {
        return child_->GetRouterStatus(rest_context, options, request);
      },
      rest_context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RoutersRestLogging::AsyncInsertRouter(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::routers::v1::InsertRouterRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          CompletionQueue& cq,
          std::unique_ptr<rest_internal::RestContext> rest_context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::cpp::compute::routers::v1::InsertRouterRequest const&
              request) {
        return child_->AsyncInsertRouter(cq, std::move(rest_context),
                                         std::move(options), request);
      },
      cq, std::move(rest_context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
RoutersRestLogging::InsertRouter(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::routers::v1::InsertRouterRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          rest_internal::RestContext& rest_context, Options const& options,
          google::cloud::cpp::compute::routers::v1::InsertRouterRequest const&
              request) {
        return child_->InsertRouter(rest_context, options, request);
      },
      rest_context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::cpp::compute::v1::RouterList>
RoutersRestLogging::ListRouters(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::routers::v1::ListRoutersRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](rest_internal::RestContext& rest_context, Options const& options,
             google::cloud::cpp::compute::routers::v1::ListRoutersRequest const&
                 request) {
        return child_->ListRouters(rest_context, options, request);
      },
      rest_context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RoutersRestLogging::AsyncPatchRouter(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::routers::v1::PatchRouterRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](CompletionQueue& cq,
             std::unique_ptr<rest_internal::RestContext> rest_context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::cpp::compute::routers::v1::PatchRouterRequest const&
                 request) {
        return child_->AsyncPatchRouter(cq, std::move(rest_context),
                                        std::move(options), request);
      },
      cq, std::move(rest_context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
RoutersRestLogging::PatchRouter(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::routers::v1::PatchRouterRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](rest_internal::RestContext& rest_context, Options const& options,
             google::cloud::cpp::compute::routers::v1::PatchRouterRequest const&
                 request) {
        return child_->PatchRouter(rest_context, options, request);
      },
      rest_context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::cpp::compute::v1::RoutersPreviewResponse>
RoutersRestLogging::Preview(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::routers::v1::PreviewRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](rest_internal::RestContext& rest_context, Options const& options,
             google::cloud::cpp::compute::routers::v1::PreviewRequest const&
                 request) {
        return child_->Preview(rest_context, options, request);
      },
      rest_context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RoutersRestLogging::AsyncUpdateRouter(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::routers::v1::UpdateRouterRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          CompletionQueue& cq,
          std::unique_ptr<rest_internal::RestContext> rest_context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::cpp::compute::routers::v1::UpdateRouterRequest const&
              request) {
        return child_->AsyncUpdateRouter(cq, std::move(rest_context),
                                         std::move(options), request);
      },
      cq, std::move(rest_context), std::move(options), request, __func__,
      tracing_options_);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
RoutersRestLogging::UpdateRouter(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::routers::v1::UpdateRouterRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          rest_internal::RestContext& rest_context, Options const& options,
          google::cloud::cpp::compute::routers::v1::UpdateRouterRequest const&
              request) {
        return child_->UpdateRouter(rest_context, options, request);
      },
      rest_context, options, request, __func__, tracing_options_);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RoutersRestLogging::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::region_operations::v1::
        GetOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](CompletionQueue& cq,
             std::unique_ptr<rest_internal::RestContext> rest_context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::cpp::compute::region_operations::v1::
                 GetOperationRequest const& request) {
        return child_->AsyncGetOperation(cq, std::move(rest_context),
                                         std::move(options), request);
      },
      cq, std::move(rest_context), std::move(options), request, __func__,
      tracing_options_);
}

future<Status> RoutersRestLogging::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::region_operations::v1::
        DeleteOperationRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](CompletionQueue& cq,
             std::unique_ptr<rest_internal::RestContext> rest_context,
             google::cloud::internal::ImmutableOptions options,
             google::cloud::cpp::compute::region_operations::v1::
                 DeleteOperationRequest const& request) {
        return child_->AsyncCancelOperation(cq, std::move(rest_context),
                                            std::move(options), request);
      },
      cq, std::move(rest_context), std::move(options), request, __func__,
      tracing_options_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_routers_v1_internal
}  // namespace cloud
}  // namespace google
