// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/devtools/cloudbuild/v1/cloudbuild.proto

#include "google/cloud/cloudbuild/v1/internal/cloud_build_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace cloudbuild_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

CloudBuildTracingConnection::CloudBuildTracingConnection(
    std::shared_ptr<cloudbuild_v1::CloudBuildConnection> child)
    : child_(std::move(child)) {}

future<StatusOr<google::devtools::cloudbuild::v1::Build>>
CloudBuildTracingConnection::CreateBuild(
    google::devtools::cloudbuild::v1::CreateBuildRequest const& request) {
  auto span =
      internal::MakeSpan("cloudbuild_v1::CloudBuildConnection::CreateBuild");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateBuild(request));
}

StatusOr<google::longrunning::Operation>
CloudBuildTracingConnection::CreateBuild(
    NoAwaitTag,
    google::devtools::cloudbuild::v1::CreateBuildRequest const& request) {
  auto span =
      internal::MakeSpan("cloudbuild_v1::CloudBuildConnection::CreateBuild");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->CreateBuild(NoAwaitTag{}, request));
}

future<StatusOr<google::devtools::cloudbuild::v1::Build>>
CloudBuildTracingConnection::CreateBuild(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("cloudbuild_v1::CloudBuildConnection::CreateBuild");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateBuild(operation));
}

StatusOr<google::devtools::cloudbuild::v1::Build>
CloudBuildTracingConnection::GetBuild(
    google::devtools::cloudbuild::v1::GetBuildRequest const& request) {
  auto span =
      internal::MakeSpan("cloudbuild_v1::CloudBuildConnection::GetBuild");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetBuild(request));
}

StreamRange<google::devtools::cloudbuild::v1::Build>
CloudBuildTracingConnection::ListBuilds(
    google::devtools::cloudbuild::v1::ListBuildsRequest request) {
  auto span =
      internal::MakeSpan("cloudbuild_v1::CloudBuildConnection::ListBuilds");
  internal::OTelScope scope(span);
  auto sr = child_->ListBuilds(std::move(request));
  return internal::MakeTracedStreamRange<
      google::devtools::cloudbuild::v1::Build>(std::move(span), std::move(sr));
}

StatusOr<google::devtools::cloudbuild::v1::Build>
CloudBuildTracingConnection::CancelBuild(
    google::devtools::cloudbuild::v1::CancelBuildRequest const& request) {
  auto span =
      internal::MakeSpan("cloudbuild_v1::CloudBuildConnection::CancelBuild");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CancelBuild(request));
}

future<StatusOr<google::devtools::cloudbuild::v1::Build>>
CloudBuildTracingConnection::RetryBuild(
    google::devtools::cloudbuild::v1::RetryBuildRequest const& request) {
  auto span =
      internal::MakeSpan("cloudbuild_v1::CloudBuildConnection::RetryBuild");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->RetryBuild(request));
}

StatusOr<google::longrunning::Operation>
CloudBuildTracingConnection::RetryBuild(
    NoAwaitTag,
    google::devtools::cloudbuild::v1::RetryBuildRequest const& request) {
  auto span =
      internal::MakeSpan("cloudbuild_v1::CloudBuildConnection::RetryBuild");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->RetryBuild(NoAwaitTag{}, request));
}

future<StatusOr<google::devtools::cloudbuild::v1::Build>>
CloudBuildTracingConnection::RetryBuild(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("cloudbuild_v1::CloudBuildConnection::RetryBuild");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->RetryBuild(operation));
}

future<StatusOr<google::devtools::cloudbuild::v1::Build>>
CloudBuildTracingConnection::ApproveBuild(
    google::devtools::cloudbuild::v1::ApproveBuildRequest const& request) {
  auto span =
      internal::MakeSpan("cloudbuild_v1::CloudBuildConnection::ApproveBuild");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->ApproveBuild(request));
}

StatusOr<google::longrunning::Operation>
CloudBuildTracingConnection::ApproveBuild(
    NoAwaitTag,
    google::devtools::cloudbuild::v1::ApproveBuildRequest const& request) {
  auto span =
      internal::MakeSpan("cloudbuild_v1::CloudBuildConnection::ApproveBuild");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->ApproveBuild(NoAwaitTag{}, request));
}

future<StatusOr<google::devtools::cloudbuild::v1::Build>>
CloudBuildTracingConnection::ApproveBuild(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("cloudbuild_v1::CloudBuildConnection::ApproveBuild");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->ApproveBuild(operation));
}

StatusOr<google::devtools::cloudbuild::v1::BuildTrigger>
CloudBuildTracingConnection::CreateBuildTrigger(
    google::devtools::cloudbuild::v1::CreateBuildTriggerRequest const&
        request) {
  auto span = internal::MakeSpan(
      "cloudbuild_v1::CloudBuildConnection::CreateBuildTrigger");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->CreateBuildTrigger(request));
}

StatusOr<google::devtools::cloudbuild::v1::BuildTrigger>
CloudBuildTracingConnection::GetBuildTrigger(
    google::devtools::cloudbuild::v1::GetBuildTriggerRequest const& request) {
  auto span = internal::MakeSpan(
      "cloudbuild_v1::CloudBuildConnection::GetBuildTrigger");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetBuildTrigger(request));
}

StreamRange<google::devtools::cloudbuild::v1::BuildTrigger>
CloudBuildTracingConnection::ListBuildTriggers(
    google::devtools::cloudbuild::v1::ListBuildTriggersRequest request) {
  auto span = internal::MakeSpan(
      "cloudbuild_v1::CloudBuildConnection::ListBuildTriggers");
  internal::OTelScope scope(span);
  auto sr = child_->ListBuildTriggers(std::move(request));
  return internal::MakeTracedStreamRange<
      google::devtools::cloudbuild::v1::BuildTrigger>(std::move(span),
                                                      std::move(sr));
}

Status CloudBuildTracingConnection::DeleteBuildTrigger(
    google::devtools::cloudbuild::v1::DeleteBuildTriggerRequest const&
        request) {
  auto span = internal::MakeSpan(
      "cloudbuild_v1::CloudBuildConnection::DeleteBuildTrigger");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteBuildTrigger(request));
}

StatusOr<google::devtools::cloudbuild::v1::BuildTrigger>
CloudBuildTracingConnection::UpdateBuildTrigger(
    google::devtools::cloudbuild::v1::UpdateBuildTriggerRequest const&
        request) {
  auto span = internal::MakeSpan(
      "cloudbuild_v1::CloudBuildConnection::UpdateBuildTrigger");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateBuildTrigger(request));
}

future<StatusOr<google::devtools::cloudbuild::v1::Build>>
CloudBuildTracingConnection::RunBuildTrigger(
    google::devtools::cloudbuild::v1::RunBuildTriggerRequest const& request) {
  auto span = internal::MakeSpan(
      "cloudbuild_v1::CloudBuildConnection::RunBuildTrigger");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->RunBuildTrigger(request));
}

StatusOr<google::longrunning::Operation>
CloudBuildTracingConnection::RunBuildTrigger(
    NoAwaitTag,
    google::devtools::cloudbuild::v1::RunBuildTriggerRequest const& request) {
  auto span = internal::MakeSpan(
      "cloudbuild_v1::CloudBuildConnection::RunBuildTrigger");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->RunBuildTrigger(NoAwaitTag{}, request));
}

future<StatusOr<google::devtools::cloudbuild::v1::Build>>
CloudBuildTracingConnection::RunBuildTrigger(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "cloudbuild_v1::CloudBuildConnection::RunBuildTrigger");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->RunBuildTrigger(operation));
}

StatusOr<google::devtools::cloudbuild::v1::ReceiveTriggerWebhookResponse>
CloudBuildTracingConnection::ReceiveTriggerWebhook(
    google::devtools::cloudbuild::v1::ReceiveTriggerWebhookRequest const&
        request) {
  auto span = internal::MakeSpan(
      "cloudbuild_v1::CloudBuildConnection::ReceiveTriggerWebhook");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->ReceiveTriggerWebhook(request));
}

future<StatusOr<google::devtools::cloudbuild::v1::WorkerPool>>
CloudBuildTracingConnection::CreateWorkerPool(
    google::devtools::cloudbuild::v1::CreateWorkerPoolRequest const& request) {
  auto span = internal::MakeSpan(
      "cloudbuild_v1::CloudBuildConnection::CreateWorkerPool");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateWorkerPool(request));
}

StatusOr<google::longrunning::Operation>
CloudBuildTracingConnection::CreateWorkerPool(
    NoAwaitTag,
    google::devtools::cloudbuild::v1::CreateWorkerPoolRequest const& request) {
  auto span = internal::MakeSpan(
      "cloudbuild_v1::CloudBuildConnection::CreateWorkerPool");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->CreateWorkerPool(NoAwaitTag{}, request));
}

future<StatusOr<google::devtools::cloudbuild::v1::WorkerPool>>
CloudBuildTracingConnection::CreateWorkerPool(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "cloudbuild_v1::CloudBuildConnection::CreateWorkerPool");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateWorkerPool(operation));
}

StatusOr<google::devtools::cloudbuild::v1::WorkerPool>
CloudBuildTracingConnection::GetWorkerPool(
    google::devtools::cloudbuild::v1::GetWorkerPoolRequest const& request) {
  auto span =
      internal::MakeSpan("cloudbuild_v1::CloudBuildConnection::GetWorkerPool");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetWorkerPool(request));
}

future<StatusOr<
    google::devtools::cloudbuild::v1::DeleteWorkerPoolOperationMetadata>>
CloudBuildTracingConnection::DeleteWorkerPool(
    google::devtools::cloudbuild::v1::DeleteWorkerPoolRequest const& request) {
  auto span = internal::MakeSpan(
      "cloudbuild_v1::CloudBuildConnection::DeleteWorkerPool");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteWorkerPool(request));
}

StatusOr<google::longrunning::Operation>
CloudBuildTracingConnection::DeleteWorkerPool(
    NoAwaitTag,
    google::devtools::cloudbuild::v1::DeleteWorkerPoolRequest const& request) {
  auto span = internal::MakeSpan(
      "cloudbuild_v1::CloudBuildConnection::DeleteWorkerPool");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeleteWorkerPool(NoAwaitTag{}, request));
}

future<StatusOr<
    google::devtools::cloudbuild::v1::DeleteWorkerPoolOperationMetadata>>
CloudBuildTracingConnection::DeleteWorkerPool(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "cloudbuild_v1::CloudBuildConnection::DeleteWorkerPool");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteWorkerPool(operation));
}

future<StatusOr<google::devtools::cloudbuild::v1::WorkerPool>>
CloudBuildTracingConnection::UpdateWorkerPool(
    google::devtools::cloudbuild::v1::UpdateWorkerPoolRequest const& request) {
  auto span = internal::MakeSpan(
      "cloudbuild_v1::CloudBuildConnection::UpdateWorkerPool");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateWorkerPool(request));
}

StatusOr<google::longrunning::Operation>
CloudBuildTracingConnection::UpdateWorkerPool(
    NoAwaitTag,
    google::devtools::cloudbuild::v1::UpdateWorkerPoolRequest const& request) {
  auto span = internal::MakeSpan(
      "cloudbuild_v1::CloudBuildConnection::UpdateWorkerPool");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->UpdateWorkerPool(NoAwaitTag{}, request));
}

future<StatusOr<google::devtools::cloudbuild::v1::WorkerPool>>
CloudBuildTracingConnection::UpdateWorkerPool(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "cloudbuild_v1::CloudBuildConnection::UpdateWorkerPool");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateWorkerPool(operation));
}

StreamRange<google::devtools::cloudbuild::v1::WorkerPool>
CloudBuildTracingConnection::ListWorkerPools(
    google::devtools::cloudbuild::v1::ListWorkerPoolsRequest request) {
  auto span = internal::MakeSpan(
      "cloudbuild_v1::CloudBuildConnection::ListWorkerPools");
  internal::OTelScope scope(span);
  auto sr = child_->ListWorkerPools(std::move(request));
  return internal::MakeTracedStreamRange<
      google::devtools::cloudbuild::v1::WorkerPool>(std::move(span),
                                                    std::move(sr));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<cloudbuild_v1::CloudBuildConnection>
MakeCloudBuildTracingConnection(
    std::shared_ptr<cloudbuild_v1::CloudBuildConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<CloudBuildTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace cloudbuild_v1_internal
}  // namespace cloud
}  // namespace google
