// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/billing/v1/cloud_billing.proto

#include "google/cloud/billing/v1/internal/cloud_billing_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace billing_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

CloudBillingTracingStub::CloudBillingTracingStub(
    std::shared_ptr<CloudBillingStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::billing::v1::BillingAccount>
CloudBillingTracingStub::GetBillingAccount(
    grpc::ClientContext& context, Options const& options,
    google::cloud::billing::v1::GetBillingAccountRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.billing.v1.CloudBilling",
                                     "GetBillingAccount");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->GetBillingAccount(context, options, request));
}

StatusOr<google::cloud::billing::v1::ListBillingAccountsResponse>
CloudBillingTracingStub::ListBillingAccounts(
    grpc::ClientContext& context, Options const& options,
    google::cloud::billing::v1::ListBillingAccountsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.billing.v1.CloudBilling",
                                     "ListBillingAccounts");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->ListBillingAccounts(context, options, request));
}

StatusOr<google::cloud::billing::v1::BillingAccount>
CloudBillingTracingStub::UpdateBillingAccount(
    grpc::ClientContext& context, Options const& options,
    google::cloud::billing::v1::UpdateBillingAccountRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.billing.v1.CloudBilling",
                                     "UpdateBillingAccount");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->UpdateBillingAccount(context, options, request));
}

StatusOr<google::cloud::billing::v1::BillingAccount>
CloudBillingTracingStub::CreateBillingAccount(
    grpc::ClientContext& context, Options const& options,
    google::cloud::billing::v1::CreateBillingAccountRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.billing.v1.CloudBilling",
                                     "CreateBillingAccount");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->CreateBillingAccount(context, options, request));
}

StatusOr<google::cloud::billing::v1::ListProjectBillingInfoResponse>
CloudBillingTracingStub::ListProjectBillingInfo(
    grpc::ClientContext& context, Options const& options,
    google::cloud::billing::v1::ListProjectBillingInfoRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.billing.v1.CloudBilling",
                                     "ListProjectBillingInfo");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->ListProjectBillingInfo(context, options, request));
}

StatusOr<google::cloud::billing::v1::ProjectBillingInfo>
CloudBillingTracingStub::GetProjectBillingInfo(
    grpc::ClientContext& context, Options const& options,
    google::cloud::billing::v1::GetProjectBillingInfoRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.billing.v1.CloudBilling",
                                     "GetProjectBillingInfo");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->GetProjectBillingInfo(context, options, request));
}

StatusOr<google::cloud::billing::v1::ProjectBillingInfo>
CloudBillingTracingStub::UpdateProjectBillingInfo(
    grpc::ClientContext& context, Options const& options,
    google::cloud::billing::v1::UpdateProjectBillingInfoRequest const&
        request) {
  auto span = internal::MakeSpanGrpc("google.cloud.billing.v1.CloudBilling",
                                     "UpdateProjectBillingInfo");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span,
      child_->UpdateProjectBillingInfo(context, options, request));
}

StatusOr<google::iam::v1::Policy> CloudBillingTracingStub::GetIamPolicy(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::GetIamPolicyRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.billing.v1.CloudBilling",
                                     "GetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetIamPolicy(context, options, request));
}

StatusOr<google::iam::v1::Policy> CloudBillingTracingStub::SetIamPolicy(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::SetIamPolicyRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.billing.v1.CloudBilling",
                                     "SetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->SetIamPolicy(context, options, request));
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
CloudBillingTracingStub::TestIamPermissions(
    grpc::ClientContext& context, Options const& options,
    google::iam::v1::TestIamPermissionsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.billing.v1.CloudBilling",
                                     "TestIamPermissions");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->TestIamPermissions(context, options, request));
}

StatusOr<google::cloud::billing::v1::BillingAccount>
CloudBillingTracingStub::MoveBillingAccount(
    grpc::ClientContext& context, Options const& options,
    google::cloud::billing::v1::MoveBillingAccountRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.billing.v1.CloudBilling",
                                     "MoveBillingAccount");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(
      context, *span, child_->MoveBillingAccount(context, options, request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<CloudBillingStub> MakeCloudBillingTracingStub(
    std::shared_ptr<CloudBillingStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<CloudBillingTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace billing_v1_internal
}  // namespace cloud
}  // namespace google
