// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/biglake/v1/metastore.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERY_BIGLAKE_V1_METASTORE_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERY_BIGLAKE_V1_METASTORE_CLIENT_H

#include "google/cloud/bigquery/biglake/v1/metastore_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace bigquery_biglake_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// BigLake Metastore is a serverless, highly available, multi-tenant runtime
/// metastore for Google Cloud Data Analytics products.
///
/// The BigLake Metastore API defines the following resource model:
///
/// * A collection of Google Cloud projects: `/projects/*`
/// * Each project has a collection of available locations: `/locations/*`
/// * Each location has a collection of catalogs: `/catalogs/*`
/// * Each catalog has a collection of databases: `/databases/*`
/// * Each database has a collection of tables: `/tables/*`
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class MetastoreServiceClient {
 public:
  explicit MetastoreServiceClient(
      std::shared_ptr<MetastoreServiceConnection> connection,
      Options opts = {});
  ~MetastoreServiceClient();

  ///@{
  /// @name Copy and move support
  MetastoreServiceClient(MetastoreServiceClient const&) = default;
  MetastoreServiceClient& operator=(MetastoreServiceClient const&) = default;
  MetastoreServiceClient(MetastoreServiceClient&&) = default;
  MetastoreServiceClient& operator=(MetastoreServiceClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(MetastoreServiceClient const& a,
                         MetastoreServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(MetastoreServiceClient const& a,
                         MetastoreServiceClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Creates a new catalog.
  ///
  /// @param parent  Required. The parent resource where this catalog will be created.
  ///  Format: projects/{project_id_or_number}/locations/{location_id}
  /// @param catalog  Required. The catalog to create.
  ///  The `name` field does not need to be provided.
  /// @param catalog_id  Required. The ID to use for the catalog, which will become the final
  ///  component of the catalog's resource name.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.bigquery.biglake.v1.Catalog])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.bigquery.biglake.v1.Catalog]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L189}
  /// [google.cloud.bigquery.biglake.v1.CreateCatalogRequest]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L336}
  ///
  // clang-format on
  StatusOr<google::cloud::bigquery::biglake::v1::Catalog> CreateCatalog(
      std::string const& parent,
      google::cloud::bigquery::biglake::v1::Catalog const& catalog,
      std::string const& catalog_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new catalog.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.bigquery.biglake.v1.CreateCatalogRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.bigquery.biglake.v1.Catalog])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.bigquery.biglake.v1.Catalog]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L189}
  /// [google.cloud.bigquery.biglake.v1.CreateCatalogRequest]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L336}
  ///
  // clang-format on
  StatusOr<google::cloud::bigquery::biglake::v1::Catalog> CreateCatalog(
      google::cloud::bigquery::biglake::v1::CreateCatalogRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes an existing catalog specified by the catalog ID.
  ///
  /// @param name  Required. The name of the catalog to delete.
  ///  Format:
  ///  projects/{project_id_or_number}/locations/{location_id}/catalogs/{catalog_id}
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.bigquery.biglake.v1.Catalog])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.bigquery.biglake.v1.Catalog]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L189}
  /// [google.cloud.bigquery.biglake.v1.DeleteCatalogRequest]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L356}
  ///
  // clang-format on
  StatusOr<google::cloud::bigquery::biglake::v1::Catalog> DeleteCatalog(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes an existing catalog specified by the catalog ID.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.bigquery.biglake.v1.DeleteCatalogRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.bigquery.biglake.v1.Catalog])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.bigquery.biglake.v1.Catalog]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L189}
  /// [google.cloud.bigquery.biglake.v1.DeleteCatalogRequest]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L356}
  ///
  // clang-format on
  StatusOr<google::cloud::bigquery::biglake::v1::Catalog> DeleteCatalog(
      google::cloud::bigquery::biglake::v1::DeleteCatalogRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets the catalog specified by the resource name.
  ///
  /// @param name  Required. The name of the catalog to retrieve.
  ///  Format:
  ///  projects/{project_id_or_number}/locations/{location_id}/catalogs/{catalog_id}
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.bigquery.biglake.v1.Catalog])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.bigquery.biglake.v1.Catalog]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L189}
  /// [google.cloud.bigquery.biglake.v1.GetCatalogRequest]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L367}
  ///
  // clang-format on
  StatusOr<google::cloud::bigquery::biglake::v1::Catalog> GetCatalog(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets the catalog specified by the resource name.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.bigquery.biglake.v1.GetCatalogRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.bigquery.biglake.v1.Catalog])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.bigquery.biglake.v1.Catalog]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L189}
  /// [google.cloud.bigquery.biglake.v1.GetCatalogRequest]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L367}
  ///
  // clang-format on
  StatusOr<google::cloud::bigquery::biglake::v1::Catalog> GetCatalog(
      google::cloud::bigquery::biglake::v1::GetCatalogRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// List all catalogs in a specified project.
  ///
  /// @param parent  Required. The parent, which owns this collection of catalogs.
  ///  Format: projects/{project_id_or_number}/locations/{location_id}
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.bigquery.biglake.v1.Catalog], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.bigquery.biglake.v1.Catalog]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L189}
  /// [google.cloud.bigquery.biglake.v1.ListCatalogsRequest]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L378}
  ///
  // clang-format on
  StreamRange<google::cloud::bigquery::biglake::v1::Catalog> ListCatalogs(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// List all catalogs in a specified project.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.bigquery.biglake.v1.ListCatalogsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.bigquery.biglake.v1.Catalog], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.bigquery.biglake.v1.Catalog]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L189}
  /// [google.cloud.bigquery.biglake.v1.ListCatalogsRequest]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L378}
  ///
  // clang-format on
  StreamRange<google::cloud::bigquery::biglake::v1::Catalog> ListCatalogs(
      google::cloud::bigquery::biglake::v1::ListCatalogsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new database.
  ///
  /// @param parent  Required. The parent resource where this database will be created.
  ///  Format:
  ///  projects/{project_id_or_number}/locations/{location_id}/catalogs/{catalog_id}
  /// @param database  Required. The database to create.
  ///  The `name` field does not need to be provided.
  /// @param database_id  Required. The ID to use for the database, which will become the final
  ///  component of the database's resource name.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.bigquery.biglake.v1.Database])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.bigquery.biglake.v1.CreateDatabaseRequest]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L413}
  /// [google.cloud.bigquery.biglake.v1.Database]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L223}
  ///
  // clang-format on
  StatusOr<google::cloud::bigquery::biglake::v1::Database> CreateDatabase(
      std::string const& parent,
      google::cloud::bigquery::biglake::v1::Database const& database,
      std::string const& database_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new database.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.bigquery.biglake.v1.CreateDatabaseRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.bigquery.biglake.v1.Database])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.bigquery.biglake.v1.CreateDatabaseRequest]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L413}
  /// [google.cloud.bigquery.biglake.v1.Database]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L223}
  ///
  // clang-format on
  StatusOr<google::cloud::bigquery::biglake::v1::Database> CreateDatabase(
      google::cloud::bigquery::biglake::v1::CreateDatabaseRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes an existing database specified by the database ID.
  ///
  /// @param name  Required. The name of the database to delete.
  ///  Format:
  ///  projects/{project_id_or_number}/locations/{location_id}/catalogs/{catalog_id}/databases/{database_id}
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.bigquery.biglake.v1.Database])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.bigquery.biglake.v1.Database]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L223}
  /// [google.cloud.bigquery.biglake.v1.DeleteDatabaseRequest]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L432}
  ///
  // clang-format on
  StatusOr<google::cloud::bigquery::biglake::v1::Database> DeleteDatabase(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes an existing database specified by the database ID.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.bigquery.biglake.v1.DeleteDatabaseRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.bigquery.biglake.v1.Database])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.bigquery.biglake.v1.Database]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L223}
  /// [google.cloud.bigquery.biglake.v1.DeleteDatabaseRequest]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L432}
  ///
  // clang-format on
  StatusOr<google::cloud::bigquery::biglake::v1::Database> DeleteDatabase(
      google::cloud::bigquery::biglake::v1::DeleteDatabaseRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates an existing database specified by the database ID.
  ///
  /// @param database  Required. The database to update.
  ///  @n
  ///  The database's `name` field is used to identify the database to update.
  ///  Format:
  ///  projects/{project_id_or_number}/locations/{location_id}/catalogs/{catalog_id}/databases/{database_id}
  /// @param update_mask  The list of fields to update.
  ///  @n
  ///  For the `FieldMask` definition, see
  ///  https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
  ///  If not set, defaults to all of the fields that are allowed to update.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.bigquery.biglake.v1.Database])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.bigquery.biglake.v1.Database]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L223}
  /// [google.cloud.bigquery.biglake.v1.UpdateDatabaseRequest]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L445}
  ///
  // clang-format on
  StatusOr<google::cloud::bigquery::biglake::v1::Database> UpdateDatabase(
      google::cloud::bigquery::biglake::v1::Database const& database,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates an existing database specified by the database ID.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.bigquery.biglake.v1.UpdateDatabaseRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.bigquery.biglake.v1.Database])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.bigquery.biglake.v1.Database]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L223}
  /// [google.cloud.bigquery.biglake.v1.UpdateDatabaseRequest]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L445}
  ///
  // clang-format on
  StatusOr<google::cloud::bigquery::biglake::v1::Database> UpdateDatabase(
      google::cloud::bigquery::biglake::v1::UpdateDatabaseRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets the database specified by the resource name.
  ///
  /// @param name  Required. The name of the database to retrieve.
  ///  Format:
  ///  projects/{project_id_or_number}/locations/{location_id}/catalogs/{catalog_id}/databases/{database_id}
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.bigquery.biglake.v1.Database])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.bigquery.biglake.v1.Database]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L223}
  /// [google.cloud.bigquery.biglake.v1.GetDatabaseRequest]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L462}
  ///
  // clang-format on
  StatusOr<google::cloud::bigquery::biglake::v1::Database> GetDatabase(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets the database specified by the resource name.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.bigquery.biglake.v1.GetDatabaseRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.bigquery.biglake.v1.Database])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.bigquery.biglake.v1.Database]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L223}
  /// [google.cloud.bigquery.biglake.v1.GetDatabaseRequest]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L462}
  ///
  // clang-format on
  StatusOr<google::cloud::bigquery::biglake::v1::Database> GetDatabase(
      google::cloud::bigquery::biglake::v1::GetDatabaseRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// List all databases in a specified catalog.
  ///
  /// @param parent  Required. The parent, which owns this collection of databases.
  ///  Format:
  ///  projects/{project_id_or_number}/locations/{location_id}/catalogs/{catalog_id}
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.bigquery.biglake.v1.Database], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.bigquery.biglake.v1.Database]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L223}
  /// [google.cloud.bigquery.biglake.v1.ListDatabasesRequest]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L475}
  ///
  // clang-format on
  StreamRange<google::cloud::bigquery::biglake::v1::Database> ListDatabases(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// List all databases in a specified catalog.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.bigquery.biglake.v1.ListDatabasesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.bigquery.biglake.v1.Database], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.bigquery.biglake.v1.Database]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L223}
  /// [google.cloud.bigquery.biglake.v1.ListDatabasesRequest]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L475}
  ///
  // clang-format on
  StreamRange<google::cloud::bigquery::biglake::v1::Database> ListDatabases(
      google::cloud::bigquery::biglake::v1::ListDatabasesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new table.
  ///
  /// @param parent  Required. The parent resource where this table will be created.
  ///  Format:
  ///  projects/{project_id_or_number}/locations/{location_id}/catalogs/{catalog_id}/databases/{database_id}
  /// @param table  Required. The table to create. The `name` field does not need to be
  ///  provided for the table creation.
  /// @param table_id  Required. The ID to use for the table, which will become the final
  ///  component of the table's resource name.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.bigquery.biglake.v1.Table])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.bigquery.biglake.v1.CreateTableRequest]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L509}
  /// [google.cloud.bigquery.biglake.v1.Table]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L278}
  ///
  // clang-format on
  StatusOr<google::cloud::bigquery::biglake::v1::Table> CreateTable(
      std::string const& parent,
      google::cloud::bigquery::biglake::v1::Table const& table,
      std::string const& table_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a new table.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.bigquery.biglake.v1.CreateTableRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.bigquery.biglake.v1.Table])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.bigquery.biglake.v1.CreateTableRequest]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L509}
  /// [google.cloud.bigquery.biglake.v1.Table]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L278}
  ///
  // clang-format on
  StatusOr<google::cloud::bigquery::biglake::v1::Table> CreateTable(
      google::cloud::bigquery::biglake::v1::CreateTableRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes an existing table specified by the table ID.
  ///
  /// @param name  Required. The name of the table to delete.
  ///  Format:
  ///  projects/{project_id_or_number}/locations/{location_id}/catalogs/{catalog_id}/databases/{database_id}/tables/{table_id}
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.bigquery.biglake.v1.Table])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.bigquery.biglake.v1.DeleteTableRequest]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L530}
  /// [google.cloud.bigquery.biglake.v1.Table]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L278}
  ///
  // clang-format on
  StatusOr<google::cloud::bigquery::biglake::v1::Table> DeleteTable(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes an existing table specified by the table ID.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.bigquery.biglake.v1.DeleteTableRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.bigquery.biglake.v1.Table])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.bigquery.biglake.v1.DeleteTableRequest]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L530}
  /// [google.cloud.bigquery.biglake.v1.Table]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L278}
  ///
  // clang-format on
  StatusOr<google::cloud::bigquery::biglake::v1::Table> DeleteTable(
      google::cloud::bigquery::biglake::v1::DeleteTableRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates an existing table specified by the table ID.
  ///
  /// @param table  Required. The table to update.
  ///  @n
  ///  The table's `name` field is used to identify the table to update.
  ///  Format:
  ///  projects/{project_id_or_number}/locations/{location_id}/catalogs/{catalog_id}/databases/{database_id}/tables/{table_id}
  /// @param update_mask  The list of fields to update.
  ///  @n
  ///  For the `FieldMask` definition, see
  ///  https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#fieldmask
  ///  If not set, defaults to all of the fields that are allowed to update.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.bigquery.biglake.v1.Table])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.bigquery.biglake.v1.Table]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L278}
  /// [google.cloud.bigquery.biglake.v1.UpdateTableRequest]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L541}
  ///
  // clang-format on
  StatusOr<google::cloud::bigquery::biglake::v1::Table> UpdateTable(
      google::cloud::bigquery::biglake::v1::Table const& table,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates an existing table specified by the table ID.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.bigquery.biglake.v1.UpdateTableRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.bigquery.biglake.v1.Table])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.bigquery.biglake.v1.Table]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L278}
  /// [google.cloud.bigquery.biglake.v1.UpdateTableRequest]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L541}
  ///
  // clang-format on
  StatusOr<google::cloud::bigquery::biglake::v1::Table> UpdateTable(
      google::cloud::bigquery::biglake::v1::UpdateTableRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Renames an existing table specified by the table ID.
  ///
  /// @param name  Required. The table's `name` field is used to identify the table to rename.
  ///  Format:
  ///  projects/{project_id_or_number}/locations/{location_id}/catalogs/{catalog_id}/databases/{database_id}/tables/{table_id}
  /// @param new_name  Required. The new `name` for the specified table, must be in the same
  ///  database. Format:
  ///  projects/{project_id_or_number}/locations/{location_id}/catalogs/{catalog_id}/databases/{database_id}/tables/{table_id}
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.bigquery.biglake.v1.Table])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.bigquery.biglake.v1.RenameTableRequest]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L558}
  /// [google.cloud.bigquery.biglake.v1.Table]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L278}
  ///
  // clang-format on
  StatusOr<google::cloud::bigquery::biglake::v1::Table> RenameTable(
      std::string const& name, std::string const& new_name, Options opts = {});

  // clang-format off
  ///
  /// Renames an existing table specified by the table ID.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.bigquery.biglake.v1.RenameTableRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.bigquery.biglake.v1.Table])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.bigquery.biglake.v1.RenameTableRequest]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L558}
  /// [google.cloud.bigquery.biglake.v1.Table]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L278}
  ///
  // clang-format on
  StatusOr<google::cloud::bigquery::biglake::v1::Table> RenameTable(
      google::cloud::bigquery::biglake::v1::RenameTableRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets the table specified by the resource name.
  ///
  /// @param name  Required. The name of the table to retrieve.
  ///  Format:
  ///  projects/{project_id_or_number}/locations/{location_id}/catalogs/{catalog_id}/databases/{database_id}/tables/{table_id}
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.bigquery.biglake.v1.Table])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.bigquery.biglake.v1.GetTableRequest]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L577}
  /// [google.cloud.bigquery.biglake.v1.Table]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L278}
  ///
  // clang-format on
  StatusOr<google::cloud::bigquery::biglake::v1::Table> GetTable(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets the table specified by the resource name.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.bigquery.biglake.v1.GetTableRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.bigquery.biglake.v1.Table])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.bigquery.biglake.v1.GetTableRequest]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L577}
  /// [google.cloud.bigquery.biglake.v1.Table]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L278}
  ///
  // clang-format on
  StatusOr<google::cloud::bigquery::biglake::v1::Table> GetTable(
      google::cloud::bigquery::biglake::v1::GetTableRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// List all tables in a specified database.
  ///
  /// @param parent  Required. The parent, which owns this collection of tables.
  ///  Format:
  ///  projects/{project_id_or_number}/locations/{location_id}/catalogs/{catalog_id}/databases/{database_id}
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.bigquery.biglake.v1.Table], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.bigquery.biglake.v1.ListTablesRequest]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L588}
  /// [google.cloud.bigquery.biglake.v1.Table]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L278}
  ///
  // clang-format on
  StreamRange<google::cloud::bigquery::biglake::v1::Table> ListTables(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// List all tables in a specified database.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.bigquery.biglake.v1.ListTablesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.bigquery.biglake.v1.Table], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.bigquery.biglake.v1.ListTablesRequest]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L588}
  /// [google.cloud.bigquery.biglake.v1.Table]: @googleapis_reference_link{google/cloud/bigquery/biglake/v1/metastore.proto#L278}
  ///
  // clang-format on
  StreamRange<google::cloud::bigquery::biglake::v1::Table> ListTables(
      google::cloud::bigquery::biglake::v1::ListTablesRequest request,
      Options opts = {});

 private:
  std::shared_ptr<MetastoreServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquery_biglake_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERY_BIGLAKE_V1_METASTORE_CLIENT_H
