// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/beyondcorp/appgateways/v1/app_gateways_service.proto

#include "google/cloud/beyondcorp/appgateways/v1/internal/app_gateways_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace beyondcorp_appgateways_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

AppGatewaysServiceTracingStub::AppGatewaysServiceTracingStub(
    std::shared_ptr<AppGatewaysServiceStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::beyondcorp::appgateways::v1::ListAppGatewaysResponse>
AppGatewaysServiceTracingStub::ListAppGateways(
    grpc::ClientContext& context, Options const& options,
    google::cloud::beyondcorp::appgateways::v1::ListAppGatewaysRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.beyondcorp.appgateways.v1.AppGatewaysService",
      "ListAppGateways");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListAppGateways(context, options, request));
}

StatusOr<google::cloud::beyondcorp::appgateways::v1::AppGateway>
AppGatewaysServiceTracingStub::GetAppGateway(
    grpc::ClientContext& context, Options const& options,
    google::cloud::beyondcorp::appgateways::v1::GetAppGatewayRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.beyondcorp.appgateways.v1.AppGatewaysService",
      "GetAppGateway");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetAppGateway(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
AppGatewaysServiceTracingStub::AsyncCreateAppGateway(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::beyondcorp::appgateways::v1::CreateAppGatewayRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.beyondcorp.appgateways.v1.AppGatewaysService",
      "CreateAppGateway");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCreateAppGateway(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
AppGatewaysServiceTracingStub::CreateAppGateway(
    grpc::ClientContext& context, Options options,
    google::cloud::beyondcorp::appgateways::v1::CreateAppGatewayRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.beyondcorp.appgateways.v1.AppGatewaysService",
      "CreateAppGateway");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateAppGateway(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
AppGatewaysServiceTracingStub::AsyncDeleteAppGateway(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::beyondcorp::appgateways::v1::DeleteAppGatewayRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.beyondcorp.appgateways.v1.AppGatewaysService",
      "DeleteAppGateway");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncDeleteAppGateway(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
AppGatewaysServiceTracingStub::DeleteAppGateway(
    grpc::ClientContext& context, Options options,
    google::cloud::beyondcorp::appgateways::v1::DeleteAppGatewayRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.beyondcorp.appgateways.v1.AppGatewaysService",
      "DeleteAppGateway");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteAppGateway(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
AppGatewaysServiceTracingStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.longrunning.Operations", "GetOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncGetOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<Status> AppGatewaysServiceTracingStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.longrunning.Operations",
                                     "CancelOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f =
      child_->AsyncCancelOperation(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<AppGatewaysServiceStub> MakeAppGatewaysServiceTracingStub(
    std::shared_ptr<AppGatewaysServiceStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<AppGatewaysServiceTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace beyondcorp_appgateways_v1_internal
}  // namespace cloud
}  // namespace google
