// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/backupdr/v1/backupdr.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BACKUPDR_V1_BACKUP_DR_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BACKUPDR_V1_BACKUP_DR_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <google/cloud/backupdr/v1/backupdr.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace backupdr_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class BackupDRConnectionIdempotencyPolicy {
 public:
  virtual ~BackupDRConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<BackupDRConnectionIdempotencyPolicy> clone() const;

  virtual google::cloud::Idempotency ListManagementServers(
      google::cloud::backupdr::v1::ListManagementServersRequest request);

  virtual google::cloud::Idempotency GetManagementServer(
      google::cloud::backupdr::v1::GetManagementServerRequest const& request);

  virtual google::cloud::Idempotency CreateManagementServer(
      google::cloud::backupdr::v1::CreateManagementServerRequest const&
          request);

  virtual google::cloud::Idempotency DeleteManagementServer(
      google::cloud::backupdr::v1::DeleteManagementServerRequest const&
          request);
};

std::unique_ptr<BackupDRConnectionIdempotencyPolicy>
MakeDefaultBackupDRConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace backupdr_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BACKUPDR_V1_BACKUP_DR_CONNECTION_IDEMPOTENCY_POLICY_H
