// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/apphub/v1/apphub_service.proto

#include "google/cloud/apphub/v1/internal/app_hub_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace apphub_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

AppHubTracingConnection::AppHubTracingConnection(
    std::shared_ptr<apphub_v1::AppHubConnection> child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::apphub::v1::LookupServiceProjectAttachmentResponse>
AppHubTracingConnection::LookupServiceProjectAttachment(
    google::cloud::apphub::v1::LookupServiceProjectAttachmentRequest const&
        request) {
  auto span = internal::MakeSpan(
      "apphub_v1::AppHubConnection::LookupServiceProjectAttachment");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span,
                           child_->LookupServiceProjectAttachment(request));
}

StreamRange<google::cloud::apphub::v1::ServiceProjectAttachment>
AppHubTracingConnection::ListServiceProjectAttachments(
    google::cloud::apphub::v1::ListServiceProjectAttachmentsRequest request) {
  auto span = internal::MakeSpan(
      "apphub_v1::AppHubConnection::ListServiceProjectAttachments");
  internal::OTelScope scope(span);
  auto sr = child_->ListServiceProjectAttachments(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::apphub::v1::ServiceProjectAttachment>(std::move(span),
                                                           std::move(sr));
}

future<StatusOr<google::cloud::apphub::v1::ServiceProjectAttachment>>
AppHubTracingConnection::CreateServiceProjectAttachment(
    google::cloud::apphub::v1::CreateServiceProjectAttachmentRequest const&
        request) {
  auto span = internal::MakeSpan(
      "apphub_v1::AppHubConnection::CreateServiceProjectAttachment");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateServiceProjectAttachment(request));
}

StatusOr<google::longrunning::Operation>
AppHubTracingConnection::CreateServiceProjectAttachment(
    NoAwaitTag,
    google::cloud::apphub::v1::CreateServiceProjectAttachmentRequest const&
        request) {
  auto span = internal::MakeSpan(
      "apphub_v1::AppHubConnection::CreateServiceProjectAttachment");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->CreateServiceProjectAttachment(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::apphub::v1::ServiceProjectAttachment>>
AppHubTracingConnection::CreateServiceProjectAttachment(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "apphub_v1::AppHubConnection::CreateServiceProjectAttachment");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateServiceProjectAttachment(operation));
}

StatusOr<google::cloud::apphub::v1::ServiceProjectAttachment>
AppHubTracingConnection::GetServiceProjectAttachment(
    google::cloud::apphub::v1::GetServiceProjectAttachmentRequest const&
        request) {
  auto span = internal::MakeSpan(
      "apphub_v1::AppHubConnection::GetServiceProjectAttachment");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetServiceProjectAttachment(request));
}

future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
AppHubTracingConnection::DeleteServiceProjectAttachment(
    google::cloud::apphub::v1::DeleteServiceProjectAttachmentRequest const&
        request) {
  auto span = internal::MakeSpan(
      "apphub_v1::AppHubConnection::DeleteServiceProjectAttachment");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteServiceProjectAttachment(request));
}

StatusOr<google::longrunning::Operation>
AppHubTracingConnection::DeleteServiceProjectAttachment(
    NoAwaitTag,
    google::cloud::apphub::v1::DeleteServiceProjectAttachmentRequest const&
        request) {
  auto span = internal::MakeSpan(
      "apphub_v1::AppHubConnection::DeleteServiceProjectAttachment");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span, child_->DeleteServiceProjectAttachment(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
AppHubTracingConnection::DeleteServiceProjectAttachment(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "apphub_v1::AppHubConnection::DeleteServiceProjectAttachment");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteServiceProjectAttachment(operation));
}

StatusOr<google::cloud::apphub::v1::DetachServiceProjectAttachmentResponse>
AppHubTracingConnection::DetachServiceProjectAttachment(
    google::cloud::apphub::v1::DetachServiceProjectAttachmentRequest const&
        request) {
  auto span = internal::MakeSpan(
      "apphub_v1::AppHubConnection::DetachServiceProjectAttachment");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span,
                           child_->DetachServiceProjectAttachment(request));
}

StreamRange<google::cloud::apphub::v1::DiscoveredService>
AppHubTracingConnection::ListDiscoveredServices(
    google::cloud::apphub::v1::ListDiscoveredServicesRequest request) {
  auto span =
      internal::MakeSpan("apphub_v1::AppHubConnection::ListDiscoveredServices");
  internal::OTelScope scope(span);
  auto sr = child_->ListDiscoveredServices(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::apphub::v1::DiscoveredService>(std::move(span),
                                                    std::move(sr));
}

StatusOr<google::cloud::apphub::v1::DiscoveredService>
AppHubTracingConnection::GetDiscoveredService(
    google::cloud::apphub::v1::GetDiscoveredServiceRequest const& request) {
  auto span =
      internal::MakeSpan("apphub_v1::AppHubConnection::GetDiscoveredService");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetDiscoveredService(request));
}

StatusOr<google::cloud::apphub::v1::LookupDiscoveredServiceResponse>
AppHubTracingConnection::LookupDiscoveredService(
    google::cloud::apphub::v1::LookupDiscoveredServiceRequest const& request) {
  auto span = internal::MakeSpan(
      "apphub_v1::AppHubConnection::LookupDiscoveredService");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->LookupDiscoveredService(request));
}

StreamRange<google::cloud::apphub::v1::Service>
AppHubTracingConnection::ListServices(
    google::cloud::apphub::v1::ListServicesRequest request) {
  auto span = internal::MakeSpan("apphub_v1::AppHubConnection::ListServices");
  internal::OTelScope scope(span);
  auto sr = child_->ListServices(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::apphub::v1::Service>(
      std::move(span), std::move(sr));
}

future<StatusOr<google::cloud::apphub::v1::Service>>
AppHubTracingConnection::CreateService(
    google::cloud::apphub::v1::CreateServiceRequest const& request) {
  auto span = internal::MakeSpan("apphub_v1::AppHubConnection::CreateService");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateService(request));
}

StatusOr<google::longrunning::Operation> AppHubTracingConnection::CreateService(
    NoAwaitTag,
    google::cloud::apphub::v1::CreateServiceRequest const& request) {
  auto span = internal::MakeSpan("apphub_v1::AppHubConnection::CreateService");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->CreateService(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::apphub::v1::Service>>
AppHubTracingConnection::CreateService(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan("apphub_v1::AppHubConnection::CreateService");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateService(operation));
}

StatusOr<google::cloud::apphub::v1::Service>
AppHubTracingConnection::GetService(
    google::cloud::apphub::v1::GetServiceRequest const& request) {
  auto span = internal::MakeSpan("apphub_v1::AppHubConnection::GetService");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetService(request));
}

future<StatusOr<google::cloud::apphub::v1::Service>>
AppHubTracingConnection::UpdateService(
    google::cloud::apphub::v1::UpdateServiceRequest const& request) {
  auto span = internal::MakeSpan("apphub_v1::AppHubConnection::UpdateService");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateService(request));
}

StatusOr<google::longrunning::Operation> AppHubTracingConnection::UpdateService(
    NoAwaitTag,
    google::cloud::apphub::v1::UpdateServiceRequest const& request) {
  auto span = internal::MakeSpan("apphub_v1::AppHubConnection::UpdateService");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->UpdateService(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::apphub::v1::Service>>
AppHubTracingConnection::UpdateService(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan("apphub_v1::AppHubConnection::UpdateService");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateService(operation));
}

future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
AppHubTracingConnection::DeleteService(
    google::cloud::apphub::v1::DeleteServiceRequest const& request) {
  auto span = internal::MakeSpan("apphub_v1::AppHubConnection::DeleteService");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteService(request));
}

StatusOr<google::longrunning::Operation> AppHubTracingConnection::DeleteService(
    NoAwaitTag,
    google::cloud::apphub::v1::DeleteServiceRequest const& request) {
  auto span = internal::MakeSpan("apphub_v1::AppHubConnection::DeleteService");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->DeleteService(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
AppHubTracingConnection::DeleteService(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan("apphub_v1::AppHubConnection::DeleteService");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteService(operation));
}

StreamRange<google::cloud::apphub::v1::DiscoveredWorkload>
AppHubTracingConnection::ListDiscoveredWorkloads(
    google::cloud::apphub::v1::ListDiscoveredWorkloadsRequest request) {
  auto span = internal::MakeSpan(
      "apphub_v1::AppHubConnection::ListDiscoveredWorkloads");
  internal::OTelScope scope(span);
  auto sr = child_->ListDiscoveredWorkloads(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::apphub::v1::DiscoveredWorkload>(std::move(span),
                                                     std::move(sr));
}

StatusOr<google::cloud::apphub::v1::DiscoveredWorkload>
AppHubTracingConnection::GetDiscoveredWorkload(
    google::cloud::apphub::v1::GetDiscoveredWorkloadRequest const& request) {
  auto span =
      internal::MakeSpan("apphub_v1::AppHubConnection::GetDiscoveredWorkload");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetDiscoveredWorkload(request));
}

StatusOr<google::cloud::apphub::v1::LookupDiscoveredWorkloadResponse>
AppHubTracingConnection::LookupDiscoveredWorkload(
    google::cloud::apphub::v1::LookupDiscoveredWorkloadRequest const& request) {
  auto span = internal::MakeSpan(
      "apphub_v1::AppHubConnection::LookupDiscoveredWorkload");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->LookupDiscoveredWorkload(request));
}

StreamRange<google::cloud::apphub::v1::Workload>
AppHubTracingConnection::ListWorkloads(
    google::cloud::apphub::v1::ListWorkloadsRequest request) {
  auto span = internal::MakeSpan("apphub_v1::AppHubConnection::ListWorkloads");
  internal::OTelScope scope(span);
  auto sr = child_->ListWorkloads(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::apphub::v1::Workload>(
      std::move(span), std::move(sr));
}

future<StatusOr<google::cloud::apphub::v1::Workload>>
AppHubTracingConnection::CreateWorkload(
    google::cloud::apphub::v1::CreateWorkloadRequest const& request) {
  auto span = internal::MakeSpan("apphub_v1::AppHubConnection::CreateWorkload");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateWorkload(request));
}

StatusOr<google::longrunning::Operation>
AppHubTracingConnection::CreateWorkload(
    NoAwaitTag,
    google::cloud::apphub::v1::CreateWorkloadRequest const& request) {
  auto span = internal::MakeSpan("apphub_v1::AppHubConnection::CreateWorkload");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->CreateWorkload(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::apphub::v1::Workload>>
AppHubTracingConnection::CreateWorkload(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan("apphub_v1::AppHubConnection::CreateWorkload");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateWorkload(operation));
}

StatusOr<google::cloud::apphub::v1::Workload>
AppHubTracingConnection::GetWorkload(
    google::cloud::apphub::v1::GetWorkloadRequest const& request) {
  auto span = internal::MakeSpan("apphub_v1::AppHubConnection::GetWorkload");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetWorkload(request));
}

future<StatusOr<google::cloud::apphub::v1::Workload>>
AppHubTracingConnection::UpdateWorkload(
    google::cloud::apphub::v1::UpdateWorkloadRequest const& request) {
  auto span = internal::MakeSpan("apphub_v1::AppHubConnection::UpdateWorkload");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateWorkload(request));
}

StatusOr<google::longrunning::Operation>
AppHubTracingConnection::UpdateWorkload(
    NoAwaitTag,
    google::cloud::apphub::v1::UpdateWorkloadRequest const& request) {
  auto span = internal::MakeSpan("apphub_v1::AppHubConnection::UpdateWorkload");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->UpdateWorkload(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::apphub::v1::Workload>>
AppHubTracingConnection::UpdateWorkload(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan("apphub_v1::AppHubConnection::UpdateWorkload");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateWorkload(operation));
}

future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
AppHubTracingConnection::DeleteWorkload(
    google::cloud::apphub::v1::DeleteWorkloadRequest const& request) {
  auto span = internal::MakeSpan("apphub_v1::AppHubConnection::DeleteWorkload");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteWorkload(request));
}

StatusOr<google::longrunning::Operation>
AppHubTracingConnection::DeleteWorkload(
    NoAwaitTag,
    google::cloud::apphub::v1::DeleteWorkloadRequest const& request) {
  auto span = internal::MakeSpan("apphub_v1::AppHubConnection::DeleteWorkload");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeleteWorkload(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
AppHubTracingConnection::DeleteWorkload(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan("apphub_v1::AppHubConnection::DeleteWorkload");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteWorkload(operation));
}

StreamRange<google::cloud::apphub::v1::Application>
AppHubTracingConnection::ListApplications(
    google::cloud::apphub::v1::ListApplicationsRequest request) {
  auto span =
      internal::MakeSpan("apphub_v1::AppHubConnection::ListApplications");
  internal::OTelScope scope(span);
  auto sr = child_->ListApplications(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::apphub::v1::Application>(std::move(span), std::move(sr));
}

future<StatusOr<google::cloud::apphub::v1::Application>>
AppHubTracingConnection::CreateApplication(
    google::cloud::apphub::v1::CreateApplicationRequest const& request) {
  auto span =
      internal::MakeSpan("apphub_v1::AppHubConnection::CreateApplication");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateApplication(request));
}

StatusOr<google::longrunning::Operation>
AppHubTracingConnection::CreateApplication(
    NoAwaitTag,
    google::cloud::apphub::v1::CreateApplicationRequest const& request) {
  auto span =
      internal::MakeSpan("apphub_v1::AppHubConnection::CreateApplication");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->CreateApplication(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::apphub::v1::Application>>
AppHubTracingConnection::CreateApplication(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("apphub_v1::AppHubConnection::CreateApplication");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->CreateApplication(operation));
}

StatusOr<google::cloud::apphub::v1::Application>
AppHubTracingConnection::GetApplication(
    google::cloud::apphub::v1::GetApplicationRequest const& request) {
  auto span = internal::MakeSpan("apphub_v1::AppHubConnection::GetApplication");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetApplication(request));
}

future<StatusOr<google::cloud::apphub::v1::Application>>
AppHubTracingConnection::UpdateApplication(
    google::cloud::apphub::v1::UpdateApplicationRequest const& request) {
  auto span =
      internal::MakeSpan("apphub_v1::AppHubConnection::UpdateApplication");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateApplication(request));
}

StatusOr<google::longrunning::Operation>
AppHubTracingConnection::UpdateApplication(
    NoAwaitTag,
    google::cloud::apphub::v1::UpdateApplicationRequest const& request) {
  auto span =
      internal::MakeSpan("apphub_v1::AppHubConnection::UpdateApplication");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->UpdateApplication(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::apphub::v1::Application>>
AppHubTracingConnection::UpdateApplication(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("apphub_v1::AppHubConnection::UpdateApplication");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->UpdateApplication(operation));
}

future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
AppHubTracingConnection::DeleteApplication(
    google::cloud::apphub::v1::DeleteApplicationRequest const& request) {
  auto span =
      internal::MakeSpan("apphub_v1::AppHubConnection::DeleteApplication");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteApplication(request));
}

StatusOr<google::longrunning::Operation>
AppHubTracingConnection::DeleteApplication(
    NoAwaitTag,
    google::cloud::apphub::v1::DeleteApplicationRequest const& request) {
  auto span =
      internal::MakeSpan("apphub_v1::AppHubConnection::DeleteApplication");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeleteApplication(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::apphub::v1::OperationMetadata>>
AppHubTracingConnection::DeleteApplication(
    google::longrunning::Operation const& operation) {
  auto span =
      internal::MakeSpan("apphub_v1::AppHubConnection::DeleteApplication");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
                           child_->DeleteApplication(operation));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<apphub_v1::AppHubConnection> MakeAppHubTracingConnection(
    std::shared_ptr<apphub_v1::AppHubConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<AppHubTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace apphub_v1_internal
}  // namespace cloud
}  // namespace google
