// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/apigateway/v1/apigateway_service.proto

#include "google/cloud/apigateway/v1/api_gateway_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace apigateway_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

ApiGatewayServiceConnectionIdempotencyPolicy::
    ~ApiGatewayServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<ApiGatewayServiceConnectionIdempotencyPolicy>
ApiGatewayServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<ApiGatewayServiceConnectionIdempotencyPolicy>(*this);
}

Idempotency ApiGatewayServiceConnectionIdempotencyPolicy::ListGateways(
    google::cloud::apigateway::v1::ListGatewaysRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency ApiGatewayServiceConnectionIdempotencyPolicy::GetGateway(
    google::cloud::apigateway::v1::GetGatewayRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ApiGatewayServiceConnectionIdempotencyPolicy::CreateGateway(
    google::cloud::apigateway::v1::CreateGatewayRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ApiGatewayServiceConnectionIdempotencyPolicy::UpdateGateway(
    google::cloud::apigateway::v1::UpdateGatewayRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ApiGatewayServiceConnectionIdempotencyPolicy::DeleteGateway(
    google::cloud::apigateway::v1::DeleteGatewayRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ApiGatewayServiceConnectionIdempotencyPolicy::ListApis(
    google::cloud::apigateway::v1::ListApisRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency ApiGatewayServiceConnectionIdempotencyPolicy::GetApi(
    google::cloud::apigateway::v1::GetApiRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ApiGatewayServiceConnectionIdempotencyPolicy::CreateApi(
    google::cloud::apigateway::v1::CreateApiRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ApiGatewayServiceConnectionIdempotencyPolicy::UpdateApi(
    google::cloud::apigateway::v1::UpdateApiRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ApiGatewayServiceConnectionIdempotencyPolicy::DeleteApi(
    google::cloud::apigateway::v1::DeleteApiRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ApiGatewayServiceConnectionIdempotencyPolicy::ListApiConfigs(
    google::cloud::apigateway::v1::ListApiConfigsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency ApiGatewayServiceConnectionIdempotencyPolicy::GetApiConfig(
    google::cloud::apigateway::v1::GetApiConfigRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency ApiGatewayServiceConnectionIdempotencyPolicy::CreateApiConfig(
    google::cloud::apigateway::v1::CreateApiConfigRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ApiGatewayServiceConnectionIdempotencyPolicy::UpdateApiConfig(
    google::cloud::apigateway::v1::UpdateApiConfigRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency ApiGatewayServiceConnectionIdempotencyPolicy::DeleteApiConfig(
    google::cloud::apigateway::v1::DeleteApiConfigRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<ApiGatewayServiceConnectionIdempotencyPolicy>
MakeDefaultApiGatewayServiceConnectionIdempotencyPolicy() {
  return std::make_unique<ApiGatewayServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace apigateway_v1
}  // namespace cloud
}  // namespace google
