// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/notebook_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_NOTEBOOK_STUB_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_NOTEBOOK_STUB_H

#include "google/cloud/completion_queue.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/cloud/aiplatform/v1/notebook_service.grpc.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace aiplatform_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class NotebookServiceStub {
 public:
  virtual ~NotebookServiceStub() = 0;

  virtual future<StatusOr<google::longrunning::Operation>>
  AsyncCreateNotebookRuntimeTemplate(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::aiplatform::v1::CreateNotebookRuntimeTemplateRequest const&
          request) = 0;

  virtual StatusOr<google::longrunning::Operation>
  CreateNotebookRuntimeTemplate(
      grpc::ClientContext& context, Options options,
      google::cloud::aiplatform::v1::CreateNotebookRuntimeTemplateRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::aiplatform::v1::NotebookRuntimeTemplate>
  GetNotebookRuntimeTemplate(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::GetNotebookRuntimeTemplateRequest const&
          request) = 0;

  virtual StatusOr<
      google::cloud::aiplatform::v1::ListNotebookRuntimeTemplatesResponse>
  ListNotebookRuntimeTemplates(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::ListNotebookRuntimeTemplatesRequest const&
          request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>>
  AsyncDeleteNotebookRuntimeTemplate(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::aiplatform::v1::DeleteNotebookRuntimeTemplateRequest const&
          request) = 0;

  virtual StatusOr<google::longrunning::Operation>
  DeleteNotebookRuntimeTemplate(
      grpc::ClientContext& context, Options options,
      google::cloud::aiplatform::v1::DeleteNotebookRuntimeTemplateRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::aiplatform::v1::NotebookRuntimeTemplate>
  UpdateNotebookRuntimeTemplate(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::UpdateNotebookRuntimeTemplateRequest const&
          request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>>
  AsyncAssignNotebookRuntime(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::aiplatform::v1::AssignNotebookRuntimeRequest const&
          request) = 0;

  virtual StatusOr<google::longrunning::Operation> AssignNotebookRuntime(
      grpc::ClientContext& context, Options options,
      google::cloud::aiplatform::v1::AssignNotebookRuntimeRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::aiplatform::v1::NotebookRuntime>
  GetNotebookRuntime(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::GetNotebookRuntimeRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::aiplatform::v1::ListNotebookRuntimesResponse>
  ListNotebookRuntimes(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::ListNotebookRuntimesRequest const&
          request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>>
  AsyncDeleteNotebookRuntime(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::aiplatform::v1::DeleteNotebookRuntimeRequest const&
          request) = 0;

  virtual StatusOr<google::longrunning::Operation> DeleteNotebookRuntime(
      grpc::ClientContext& context, Options options,
      google::cloud::aiplatform::v1::DeleteNotebookRuntimeRequest const&
          request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>>
  AsyncUpgradeNotebookRuntime(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::aiplatform::v1::UpgradeNotebookRuntimeRequest const&
          request) = 0;

  virtual StatusOr<google::longrunning::Operation> UpgradeNotebookRuntime(
      grpc::ClientContext& context, Options options,
      google::cloud::aiplatform::v1::UpgradeNotebookRuntimeRequest const&
          request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>>
  AsyncStartNotebookRuntime(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::aiplatform::v1::StartNotebookRuntimeRequest const&
          request) = 0;

  virtual StatusOr<google::longrunning::Operation> StartNotebookRuntime(
      grpc::ClientContext& context, Options options,
      google::cloud::aiplatform::v1::StartNotebookRuntimeRequest const&
          request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>>
  AsyncCreateNotebookExecutionJob(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::aiplatform::v1::CreateNotebookExecutionJobRequest const&
          request) = 0;

  virtual StatusOr<google::longrunning::Operation> CreateNotebookExecutionJob(
      grpc::ClientContext& context, Options options,
      google::cloud::aiplatform::v1::CreateNotebookExecutionJobRequest const&
          request) = 0;

  virtual StatusOr<google::cloud::aiplatform::v1::NotebookExecutionJob>
  GetNotebookExecutionJob(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::GetNotebookExecutionJobRequest const&
          request) = 0;

  virtual StatusOr<
      google::cloud::aiplatform::v1::ListNotebookExecutionJobsResponse>
  ListNotebookExecutionJobs(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::ListNotebookExecutionJobsRequest const&
          request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>>
  AsyncDeleteNotebookExecutionJob(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::aiplatform::v1::DeleteNotebookExecutionJobRequest const&
          request) = 0;

  virtual StatusOr<google::longrunning::Operation> DeleteNotebookExecutionJob(
      grpc::ClientContext& context, Options options,
      google::cloud::aiplatform::v1::DeleteNotebookExecutionJobRequest const&
          request) = 0;

  virtual future<StatusOr<google::longrunning::Operation>> AsyncGetOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::GetOperationRequest const& request) = 0;

  virtual future<Status> AsyncCancelOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::CancelOperationRequest const& request) = 0;
};

class DefaultNotebookServiceStub : public NotebookServiceStub {
 public:
  DefaultNotebookServiceStub(
      std::unique_ptr<
          google::cloud::aiplatform::v1::NotebookService::StubInterface>
          grpc_stub,
      std::unique_ptr<google::longrunning::Operations::StubInterface>
          operations)
      : grpc_stub_(std::move(grpc_stub)), operations_(std::move(operations)) {}

  future<StatusOr<google::longrunning::Operation>>
  AsyncCreateNotebookRuntimeTemplate(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::aiplatform::v1::CreateNotebookRuntimeTemplateRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> CreateNotebookRuntimeTemplate(
      grpc::ClientContext& context, Options options,
      google::cloud::aiplatform::v1::CreateNotebookRuntimeTemplateRequest const&
          request) override;

  StatusOr<google::cloud::aiplatform::v1::NotebookRuntimeTemplate>
  GetNotebookRuntimeTemplate(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::GetNotebookRuntimeTemplateRequest const&
          request) override;

  StatusOr<google::cloud::aiplatform::v1::ListNotebookRuntimeTemplatesResponse>
  ListNotebookRuntimeTemplates(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::ListNotebookRuntimeTemplatesRequest const&
          request) override;

  future<StatusOr<google::longrunning::Operation>>
  AsyncDeleteNotebookRuntimeTemplate(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::aiplatform::v1::DeleteNotebookRuntimeTemplateRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> DeleteNotebookRuntimeTemplate(
      grpc::ClientContext& context, Options options,
      google::cloud::aiplatform::v1::DeleteNotebookRuntimeTemplateRequest const&
          request) override;

  StatusOr<google::cloud::aiplatform::v1::NotebookRuntimeTemplate>
  UpdateNotebookRuntimeTemplate(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::UpdateNotebookRuntimeTemplateRequest const&
          request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncAssignNotebookRuntime(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::aiplatform::v1::AssignNotebookRuntimeRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> AssignNotebookRuntime(
      grpc::ClientContext& context, Options options,
      google::cloud::aiplatform::v1::AssignNotebookRuntimeRequest const&
          request) override;

  StatusOr<google::cloud::aiplatform::v1::NotebookRuntime> GetNotebookRuntime(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::GetNotebookRuntimeRequest const& request)
      override;

  StatusOr<google::cloud::aiplatform::v1::ListNotebookRuntimesResponse>
  ListNotebookRuntimes(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::ListNotebookRuntimesRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>> AsyncDeleteNotebookRuntime(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::aiplatform::v1::DeleteNotebookRuntimeRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> DeleteNotebookRuntime(
      grpc::ClientContext& context, Options options,
      google::cloud::aiplatform::v1::DeleteNotebookRuntimeRequest const&
          request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncUpgradeNotebookRuntime(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::aiplatform::v1::UpgradeNotebookRuntimeRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> UpgradeNotebookRuntime(
      grpc::ClientContext& context, Options options,
      google::cloud::aiplatform::v1::UpgradeNotebookRuntimeRequest const&
          request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncStartNotebookRuntime(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::aiplatform::v1::StartNotebookRuntimeRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> StartNotebookRuntime(
      grpc::ClientContext& context, Options options,
      google::cloud::aiplatform::v1::StartNotebookRuntimeRequest const& request)
      override;

  future<StatusOr<google::longrunning::Operation>>
  AsyncCreateNotebookExecutionJob(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::aiplatform::v1::CreateNotebookExecutionJobRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> CreateNotebookExecutionJob(
      grpc::ClientContext& context, Options options,
      google::cloud::aiplatform::v1::CreateNotebookExecutionJobRequest const&
          request) override;

  StatusOr<google::cloud::aiplatform::v1::NotebookExecutionJob>
  GetNotebookExecutionJob(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::GetNotebookExecutionJobRequest const&
          request) override;

  StatusOr<google::cloud::aiplatform::v1::ListNotebookExecutionJobsResponse>
  ListNotebookExecutionJobs(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::ListNotebookExecutionJobsRequest const&
          request) override;

  future<StatusOr<google::longrunning::Operation>>
  AsyncDeleteNotebookExecutionJob(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::aiplatform::v1::DeleteNotebookExecutionJobRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> DeleteNotebookExecutionJob(
      grpc::ClientContext& context, Options options,
      google::cloud::aiplatform::v1::DeleteNotebookExecutionJobRequest const&
          request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncGetOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::GetOperationRequest const& request) override;

  future<Status> AsyncCancelOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::CancelOperationRequest const& request) override;

 private:
  std::unique_ptr<google::cloud::aiplatform::v1::NotebookService::StubInterface>
      grpc_stub_;
  std::unique_ptr<google::longrunning::Operations::StubInterface> operations_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_NOTEBOOK_STUB_H
