// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/feature_registry_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_FEATURE_REGISTRY_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_FEATURE_REGISTRY_TRACING_CONNECTION_H

#include "google/cloud/aiplatform/v1/feature_registry_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace aiplatform_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class FeatureRegistryServiceTracingConnection
    : public aiplatform_v1::FeatureRegistryServiceConnection {
 public:
  ~FeatureRegistryServiceTracingConnection() override = default;

  explicit FeatureRegistryServiceTracingConnection(
      std::shared_ptr<aiplatform_v1::FeatureRegistryServiceConnection> child);

  Options options() override { return child_->options(); }

  future<StatusOr<google::cloud::aiplatform::v1::FeatureGroup>>
  CreateFeatureGroup(
      google::cloud::aiplatform::v1::CreateFeatureGroupRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> CreateFeatureGroup(
      NoAwaitTag,
      google::cloud::aiplatform::v1::CreateFeatureGroupRequest const& request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::FeatureGroup>>
  CreateFeatureGroup(google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::aiplatform::v1::FeatureGroup> GetFeatureGroup(
      google::cloud::aiplatform::v1::GetFeatureGroupRequest const& request)
      override;

  StreamRange<google::cloud::aiplatform::v1::FeatureGroup> ListFeatureGroups(
      google::cloud::aiplatform::v1::ListFeatureGroupsRequest request) override;

  future<StatusOr<google::cloud::aiplatform::v1::FeatureGroup>>
  UpdateFeatureGroup(
      google::cloud::aiplatform::v1::UpdateFeatureGroupRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> UpdateFeatureGroup(
      NoAwaitTag,
      google::cloud::aiplatform::v1::UpdateFeatureGroupRequest const& request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::FeatureGroup>>
  UpdateFeatureGroup(google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteFeatureGroup(
      google::cloud::aiplatform::v1::DeleteFeatureGroupRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> DeleteFeatureGroup(
      NoAwaitTag,
      google::cloud::aiplatform::v1::DeleteFeatureGroupRequest const& request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteFeatureGroup(google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::aiplatform::v1::Feature>> CreateFeature(
      google::cloud::aiplatform::v1::CreateFeatureRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> CreateFeature(
      NoAwaitTag,
      google::cloud::aiplatform::v1::CreateFeatureRequest const& request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::Feature>> CreateFeature(
      google::longrunning::Operation const& operation) override;

  StatusOr<google::cloud::aiplatform::v1::Feature> GetFeature(
      google::cloud::aiplatform::v1::GetFeatureRequest const& request) override;

  StreamRange<google::cloud::aiplatform::v1::Feature> ListFeatures(
      google::cloud::aiplatform::v1::ListFeaturesRequest request) override;

  future<StatusOr<google::cloud::aiplatform::v1::Feature>> UpdateFeature(
      google::cloud::aiplatform::v1::UpdateFeatureRequest const& request)
      override;

  StatusOr<google::longrunning::Operation> UpdateFeature(
      NoAwaitTag,
      google::cloud::aiplatform::v1::UpdateFeatureRequest const& request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::Feature>> UpdateFeature(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteFeature(google::cloud::aiplatform::v1::DeleteFeatureRequest const&
                    request) override;

  StatusOr<google::longrunning::Operation> DeleteFeature(
      NoAwaitTag,
      google::cloud::aiplatform::v1::DeleteFeatureRequest const& request)
      override;

  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteFeature(google::longrunning::Operation const& operation) override;

 private:
  std::shared_ptr<aiplatform_v1::FeatureRegistryServiceConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<aiplatform_v1::FeatureRegistryServiceConnection>
MakeFeatureRegistryServiceTracingConnection(
    std::shared_ptr<aiplatform_v1::FeatureRegistryServiceConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_FEATURE_REGISTRY_TRACING_CONNECTION_H
