// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: generator/integration_tests/test_request_id.proto

#ifndef GOOGLE_CLOUD_CPP_GENERATOR_INTEGRATION_TESTS_GOLDEN_V1_INTERNAL_REQUEST_ID_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GENERATOR_INTEGRATION_TESTS_GOLDEN_V1_INTERNAL_REQUEST_ID_CONNECTION_IMPL_H

#include "generator/integration_tests/golden/v1/internal/request_id_retry_traits.h"
#include "generator/integration_tests/golden/v1/internal/request_id_stub.h"
#include "generator/integration_tests/golden/v1/request_id_connection.h"
#include "generator/integration_tests/golden/v1/request_id_connection_idempotency_policy.h"
#include "generator/integration_tests/golden/v1/request_id_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/internal/invocation_id_generator.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace golden_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class RequestIdServiceConnectionImpl
    : public golden_v1::RequestIdServiceConnection {
 public:
  ~RequestIdServiceConnectionImpl() override = default;

  RequestIdServiceConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<golden_v1_internal::RequestIdServiceStub> stub,
    Options options);

  Options options() override { return options_; }

  StatusOr<google::test::requestid::v1::Foo>
  CreateFoo(google::test::requestid::v1::CreateFooRequest const& request) override;

  future<StatusOr<google::test::requestid::v1::Foo>>
  RenameFoo(google::test::requestid::v1::RenameFooRequest const& request) override;

  StatusOr<google::longrunning::Operation>
  RenameFoo(NoAwaitTag,
      google::test::requestid::v1::RenameFooRequest const& request) override;

  future<StatusOr<google::test::requestid::v1::Foo>>
  RenameFoo(
      google::longrunning::Operation const& operation) override;

  StreamRange<google::test::requestid::v1::Foo>
  ListFoos(google::test::requestid::v1::ListFoosRequest request) override;

  future<StatusOr<google::test::requestid::v1::Foo>>
  AsyncCreateFoo(google::test::requestid::v1::CreateFooRequest const& request) override;

 private:
  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<golden_v1_internal::RequestIdServiceStub> stub_;
  Options options_;
  std::shared_ptr<google::cloud::internal::InvocationIdGenerator>
      invocation_id_generator_ =
          std::make_shared<google::cloud::internal::InvocationIdGenerator>();
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace golden_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GENERATOR_INTEGRATION_TESTS_GOLDEN_V1_INTERNAL_REQUEST_ID_CONNECTION_IMPL_H
