/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.layout;

import com.jgoodies.forms.layout.BoundedSize;
import com.jgoodies.forms.layout.ConstantSize;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Container;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;

public abstract class FormSpec
implements Serializable {
    static final DefaultAlignment LEFT_ALIGN = new DefaultAlignment("left");
    static final DefaultAlignment RIGHT_ALIGN = new DefaultAlignment("right");
    static final DefaultAlignment TOP_ALIGN = new DefaultAlignment("top");
    static final DefaultAlignment BOTTOM_ALIGN = new DefaultAlignment("bottom");
    static final DefaultAlignment CENTER_ALIGN = new DefaultAlignment("center");
    static final DefaultAlignment FILL_ALIGN = new DefaultAlignment("fill");
    private static final DefaultAlignment[] VALUES = new DefaultAlignment[]{LEFT_ALIGN, RIGHT_ALIGN, TOP_ALIGN, BOTTOM_ALIGN, CENTER_ALIGN, FILL_ALIGN};
    public static final double NO_GROW = 0.0;
    public static final double DEFAULT_GROW = 1.0;
    private DefaultAlignment defaultAlignment;
    private Size size;
    private double resizeWeight;

    protected FormSpec(DefaultAlignment defaultAlignment, Size size, double resizeWeight) {
        this.defaultAlignment = defaultAlignment;
        this.size = size;
        this.resizeWeight = resizeWeight;
        if (resizeWeight < 0.0) {
            throw new IllegalArgumentException("The resize weight must be non-negative.");
        }
    }

    protected FormSpec(DefaultAlignment defaultAlignment, String encodedDescription) {
        this(defaultAlignment, Sizes.DEFAULT, 0.0);
        this.parseAndInitValues(encodedDescription.toLowerCase(Locale.ENGLISH));
    }

    public final DefaultAlignment getDefaultAlignment() {
        return this.defaultAlignment;
    }

    public final Size getSize() {
        return this.size;
    }

    public final double getResizeWeight() {
        return this.resizeWeight;
    }

    final boolean canGrow() {
        return this.getResizeWeight() != 0.0;
    }

    private void parseAndInitValues(String encodedDescription) {
        StringTokenizer tokenizer = new StringTokenizer(encodedDescription, ":");
        if (!tokenizer.hasMoreTokens()) {
            throw new IllegalArgumentException("The form spec must not be empty.");
        }
        String token2 = tokenizer.nextToken();
        DefaultAlignment alignment = DefaultAlignment.valueOf(token2, this.isHorizontal());
        if (alignment != null) {
            this.defaultAlignment = alignment;
            if (!tokenizer.hasMoreTokens()) {
                throw new IllegalArgumentException("The form spec must provide a size.");
            }
            token2 = tokenizer.nextToken();
        }
        this.parseAndInitSize(token2);
        if (tokenizer.hasMoreTokens()) {
            this.resizeWeight = this.decodeResize(tokenizer.nextToken());
        }
    }

    private void parseAndInitSize(String token2) {
        if (token2.startsWith("max(") && token2.endsWith(")")) {
            this.size = this.parseAndInitBoundedSize(token2, false);
            return;
        }
        if (token2.startsWith("min(") && token2.endsWith(")")) {
            this.size = this.parseAndInitBoundedSize(token2, true);
            return;
        }
        this.size = this.decodeAtomicSize(token2);
    }

    private Size parseAndInitBoundedSize(String token2, boolean setMax) {
        int semicolonIndex = token2.indexOf(59);
        String sizeToken1 = token2.substring(4, semicolonIndex);
        String sizeToken2 = token2.substring(semicolonIndex + 1, token2.length() - 1);
        Size size1 = this.decodeAtomicSize(sizeToken1);
        Size size2 = this.decodeAtomicSize(sizeToken2);
        if (size1 instanceof ConstantSize) {
            if (size2 instanceof Sizes.ComponentSize) {
                return new BoundedSize(size2, setMax ? null : size1, setMax ? size1 : null);
            }
            throw new IllegalArgumentException("Bounded sizes must not be both constants.");
        }
        if (size2 instanceof ConstantSize) {
            return new BoundedSize(size1, setMax ? null : size2, setMax ? size2 : null);
        }
        throw new IllegalArgumentException("Bounded sizes must not be both logical.");
    }

    private Size decodeAtomicSize(String token2) {
        Sizes.ComponentSize componentSize = Sizes.ComponentSize.valueOf(token2);
        if (componentSize != null) {
            return componentSize;
        }
        return ConstantSize.valueOf(token2, this.isHorizontal());
    }

    private double decodeResize(String token2) {
        if (token2.equals("g") || token2.equals("grow")) {
            return 1.0;
        }
        if (token2.equals("n") || token2.equals("nogrow") || token2.equals("none")) {
            return 0.0;
        }
        if ((token2.startsWith("grow(") || token2.startsWith("g(")) && token2.endsWith(")")) {
            int leftParen = token2.indexOf(40);
            int rightParen = token2.indexOf(41);
            String substring = token2.substring(leftParen + 1, rightParen);
            return Double.parseDouble(substring);
        }
        throw new IllegalArgumentException("The resize argument '" + token2 + "' is invalid. " + " Must be one of: grow, g, none, n, grow(<double>), g(<double>)");
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.defaultAlignment);
        buffer.append(":");
        buffer.append(this.size.toString());
        buffer.append(':');
        if (this.resizeWeight == 0.0) {
            buffer.append("noGrow");
        } else if (this.resizeWeight == 1.0) {
            buffer.append("grow");
        } else {
            buffer.append("grow(");
            buffer.append(this.resizeWeight);
            buffer.append(')');
        }
        return buffer.toString();
    }

    public final String toShortString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.defaultAlignment.abbreviation());
        buffer.append(":");
        buffer.append(this.size.toString());
        buffer.append(':');
        if (this.resizeWeight == 0.0) {
            buffer.append("n");
        } else if (this.resizeWeight == 1.0) {
            buffer.append("g");
        } else {
            buffer.append("g(");
            buffer.append(this.resizeWeight);
            buffer.append(')');
        }
        return buffer.toString();
    }

    abstract boolean isHorizontal();

    final int maximumSize(Container container, List components, FormLayout.Measure minMeasure, FormLayout.Measure prefMeasure, FormLayout.Measure defaultMeasure) {
        return this.size.maximumSize(container, components, minMeasure, prefMeasure, defaultMeasure);
    }

    public static final class DefaultAlignment
    implements Serializable {
        private final transient String name;
        private static int nextOrdinal = 0;
        private final int ordinal = nextOrdinal++;

        private DefaultAlignment(String name) {
            this.name = name;
        }

        private static DefaultAlignment valueOf(String str, boolean isHorizontal) {
            if (str.equals("f") || str.equals("fill")) {
                return FILL_ALIGN;
            }
            if (str.equals("c") || str.equals("center")) {
                return CENTER_ALIGN;
            }
            if (isHorizontal) {
                if (str.equals("r") || str.equals("right")) {
                    return RIGHT_ALIGN;
                }
                if (str.equals("l") || str.equals("left")) {
                    return LEFT_ALIGN;
                }
                return null;
            }
            if (str.equals("t") || str.equals("top")) {
                return TOP_ALIGN;
            }
            if (str.equals("b") || str.equals("bottom")) {
                return BOTTOM_ALIGN;
            }
            return null;
        }

        public String toString() {
            return this.name;
        }

        public char abbreviation() {
            return this.name.charAt(0);
        }

        private Object readResolve() {
            return VALUES[this.ordinal];
        }
    }
}

