# cmake/modules/test_diff.cmake
#
# Copyright (C) 2018 Alan W. Irwin
#
# This file is part of PLplot.
#
# PLplot is free software; you can redistribute it and/or modify
# it under the terms of the GNU Library General Public License as published
# by the Free Software Foundation; version 2 of the License.
#
# PLplot is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU Library General Public License
# along with the file PLplot; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA

# Module for determining everything required to enable the test_diff.sh script
# that is used to test whether the various language bindings produce the
# same results as the C language for a specified test device.

set(PLPLOT_TEST_DEVICE svg CACHE STRING "noninteractive device used for difference report generated by test_diff.sh")
set(TEST_DIFF)

foreach(DRIVERS_DEVICE ${DRIVERS_DEVICE_LIST})
  string(REGEX REPLACE "^(.*):.*:.*:.*:.*$" "\\1" DEVICE ${DRIVERS_DEVICE})
  if(PLD_${DEVICE})
    string(REGEX REPLACE "^.*:(.*):.*:.*:.*$" "\\1" DRIVER ${DRIVERS_DEVICE})
    string(REGEX REPLACE "^.*:.*:.*:(.*):.*$" "\\1" KIND ${DRIVERS_DEVICE})
    string(REGEX REPLACE "^.*:.*:.*:.*:(.*)$" "\\1" REQUIRE_FAMILYING ${DRIVERS_DEVICE})
    if(KIND STREQUAL "F")
      if(PLPLOT_TEST_DEVICE STREQUAL ${DEVICE})
	if(ENABLE_DYNDRIVERS)
	  set(PLPLOT_TEST_TARGET PLPLOT::${DRIVER})
	else(ENABLE_DYNDRIVERS)
	  set(PLPLOT_TEST_TARGET PLPLOT:plplot)
	endif(ENABLE_DYNDRIVERS)
	set(TEST_DIFF ON)
	if(REQUIRE_FAMILYING)
	  set(FAMILIED_PLPLOT_TEST_DEVICE "yes")
	  set(FAMILIED_FIRST_PAGE "01")
	endif(REQUIRE_FAMILYING)
      endif(PLPLOT_TEST_DEVICE STREQUAL ${DEVICE})
    endif(KIND STREQUAL "F")
  endif(PLD_${DEVICE})
endforeach(DRIVERS_DEVICE ${DRIVERS_DEVICE_LIST})

if(TEST_DIFF)
  message(STATUS "PLPLOT_TEST_DEVICE = ${PLPLOT_TEST_DEVICE}")
  message(STATUS "PLPLOT_TEST_TARGET = ${PLPLOT_TEST_TARGET}")
  message(STATUS "FAMILIED_PLPLOT_TEST_DEVICE = ${FAMILIED_PLPLOT_TEST_DEVICE}")
else(TEST_DIFF)
  message(STATUS "WARNING: the PLPLOT_TEST_DEVICE = ${PLPLOT_TEST_DEVICE} is not enabled or is not a file device so plot difference report is disabled.")
endif(TEST_DIFF)

# Unconditionally find diff and tail which are used in the test_diff.sh script but may
# also be used elsewhere.
find_program(DIFF_EXECUTABLE diff)
find_program(TAIL_EXECUTABLE tail)

# On Linux also find cmp which is faster than diff.  N.B. other Unix
# systems may have a POSIX-compliant cmp but without the GNU extension
# available on Linux of the -i option which we use to skip the
# datestamp on certain PostScript plot files that are compared in
# test_diff.sh.
if(CMAKE_SYSTEM_NAME STREQUAL "Linux")
  find_program(CMP_EXECUTABLE cmp)
  if(CMP_EXECUTABLE)
    set(HAVE_CMP_I ON)
  endif(CMP_EXECUTABLE)
endif(CMAKE_SYSTEM_NAME STREQUAL "Linux")

if(TEST_DIFF AND NOT (CMP_EXECUTABLE OR (DIFF_EXECUTABLE AND TAIL_EXECUTABLE)))
  message(STATUS "WARNING: cmp or both of diff and tail are not available on this platform so plot difference report is disabled.")
  set(TEST_DIFF)
endif(TEST_DIFF AND NOT (CMP_EXECUTABLE OR (DIFF_EXECUTABLE AND TAIL_EXECUTABLE)))
