/*
 * Endpoint - Linux SBP2 Disk Target
 *
 * Copyright (C) 2003 Oracle.  All rights reserved.
 *
 * Author: Manish Singh <manish.singh@oracle.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have recieved a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 021110-1307, USA.
 */

#include <errno.h>

#include <glib.h>

#include <libraw1394/raw1394.h>

#include "sbp2raw1394.h"


static const gchar *errmsg_not_compatible =
"This libraw1394 does not work with your version of Linux. You need a "
"different version that matches your kernel (see kernel help text for the "
"raw1394 option to find out which is the correct version).";

static const gchar *errmsg_not_loaded =
"This probably means that you don't have raw1394 support in the kernel or "
"that you haven't loaded the raw1394 module.";


raw1394handle_t
sbp2_raw1394_handle (void)
{
  raw1394handle_t handle;

  handle = raw1394_new_handle ();

  if (!handle)
    {
      if (!errno)
	{
	  g_critical (errmsg_not_compatible);
	}
      else
	{
	  g_critical ("Couldn't get handle");
	  g_critical (errmsg_not_loaded);
	}
    }

  return handle;
}

gint
sbp2_raw1394_get_num_ports (void)
{
  raw1394handle_t handle;
  gint            num_ports;

  handle = sbp2_raw1394_handle ();

  if (!handle)
    return 0;

  num_ports = raw1394_get_port_info (handle, NULL, 0);

  raw1394_destroy_handle (handle);

  return num_ports;
}

guint64
sbp2_raw1394_get_guid (raw1394handle_t handle,
                       nodeid_t        node)
{
  return 0;
}
