/*
 * Endpoint - Linux SBP2 Disk Target
 *
 * Copyright (C) 2003 Oracle.  All rights reserved.
 *
 * Author: Manish Singh <manish.singh@oracle.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have recieved a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 021110-1307, USA.
 */

#ifndef __SBP2_MANAGER_H__
#define __SBP2_MANAGER_H__


#include <glib.h>

#include <libraw1394/raw1394.h>

#include <libsbp2/sbp2login.h>
#include <libsbp2/sbp2logout.h>
#include <libsbp2/sbp2querylogins.h>
#include <libsbp2/sbp2reconnect.h>
#include <libsbp2/sbp2status.h>


typedef struct _SBP2Manager SBP2Manager;
typedef struct _SBP2ManagerAction SBP2ManagerAction;
typedef struct _SBP2ManagerFuncs SBP2ManagerFuncs;

struct _SBP2ManagerAction
{
  SBP2Manager  *manager;

  nodeid_t      node;
  SBP2Pointer  *pointer;

  SBP2Status   *status;

  gpointer      orb;
  gpointer      user_data;
};

struct _SBP2ManagerFuncs
{
  void     (*bus_reset)    (SBP2Manager             *manager,
                            gpointer                 user_data);

  gboolean (*login)        (SBP2ManagerAction       *action,
                            SBP2LoginORB            *orb,
                            SBP2LoginResponse       *resp);
  gboolean (*query_logins) (SBP2ManagerAction       *action,
                            SBP2QueryLoginsORB      *orb,
                            SBP2QueryLoginsResponse *resp);
  gboolean (*reconnect)    (SBP2ManagerAction       *action,
                            SBP2ReconnectORB        *orb);
  gboolean (*logout)       (SBP2ManagerAction       *action,
                            SBP2LogoutORB           *orb);

  /* TODO: task_management */
};


SBP2Manager *sbp2_manager_new          (SBP2ManagerFuncs *funcs,
					GMainContext     *context,
					gint              port,
					gpointer          user_data);

void         sbp2_manager_destroy      (SBP2Manager      *manager);

void         sbp2_manager_write_status (SBP2Manager      *manager,
                                        nodeid_t          node,
					SBP2Pointer      *pointer,
					SBP2Status       *status);

void         sbp2_manager_reset_bus    (SBP2Manager      *manager);


#endif /* __SBP2_MANAGER_H__ */
