package sae

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAppServicesPage invokes the sae.ListAppServicesPage API synchronously
func (client *Client) ListAppServicesPage(request *ListAppServicesPageRequest) (response *ListAppServicesPageResponse, err error) {
	response = CreateListAppServicesPageResponse()
	err = client.DoAction(request, response)
	return
}

// ListAppServicesPageWithChan invokes the sae.ListAppServicesPage API asynchronously
func (client *Client) ListAppServicesPageWithChan(request *ListAppServicesPageRequest) (<-chan *ListAppServicesPageResponse, <-chan error) {
	responseChan := make(chan *ListAppServicesPageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAppServicesPage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAppServicesPageWithCallback invokes the sae.ListAppServicesPage API asynchronously
func (client *Client) ListAppServicesPageWithCallback(request *ListAppServicesPageRequest, callback func(response *ListAppServicesPageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAppServicesPageResponse
		var err error
		defer close(result)
		response, err = client.ListAppServicesPage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAppServicesPageRequest is the request struct for api ListAppServicesPage
type ListAppServicesPageRequest struct {
	*requests.RoaRequest
	ServiceType string           `position:"Query" name:"ServiceType"`
	AppId       string           `position:"Query" name:"AppId"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	PageNumber  requests.Integer `position:"Query" name:"PageNumber"`
}

// ListAppServicesPageResponse is the response struct for api ListAppServicesPage
type ListAppServicesPageResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Message   string     `json:"Message" xml:"Message"`
	TraceId   string     `json:"TraceId" xml:"TraceId"`
	ErrorCode string     `json:"ErrorCode" xml:"ErrorCode"`
	Code      string     `json:"Code" xml:"Code"`
	Success   bool       `json:"Success" xml:"Success"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateListAppServicesPageRequest creates a request to invoke ListAppServicesPage API
func CreateListAppServicesPageRequest() (request *ListAppServicesPageRequest) {
	request = &ListAppServicesPageRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("sae", "2019-05-06", "ListAppServicesPage", "/pop/v1/sam/service/listAppServicesPage", "serverless", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListAppServicesPageResponse creates a response to parse from ListAppServicesPage response
func CreateListAppServicesPageResponse() (response *ListAppServicesPageResponse) {
	response = &ListAppServicesPageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
