package ledgerdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyLedgerAttribute invokes the ledgerdb.ModifyLedgerAttribute API synchronously
// api document: https://help.aliyun.com/api/ledgerdb/modifyledgerattribute.html
func (client *Client) ModifyLedgerAttribute(request *ModifyLedgerAttributeRequest) (response *ModifyLedgerAttributeResponse, err error) {
	response = CreateModifyLedgerAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyLedgerAttributeWithChan invokes the ledgerdb.ModifyLedgerAttribute API asynchronously
// api document: https://help.aliyun.com/api/ledgerdb/modifyledgerattribute.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyLedgerAttributeWithChan(request *ModifyLedgerAttributeRequest) (<-chan *ModifyLedgerAttributeResponse, <-chan error) {
	responseChan := make(chan *ModifyLedgerAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyLedgerAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyLedgerAttributeWithCallback invokes the ledgerdb.ModifyLedgerAttribute API asynchronously
// api document: https://help.aliyun.com/api/ledgerdb/modifyledgerattribute.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyLedgerAttributeWithCallback(request *ModifyLedgerAttributeRequest, callback func(response *ModifyLedgerAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyLedgerAttributeResponse
		var err error
		defer close(result)
		response, err = client.ModifyLedgerAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyLedgerAttributeRequest is the request struct for api ModifyLedgerAttribute
type ModifyLedgerAttributeRequest struct {
	*requests.RpcRequest
	LedgerId          string `position:"Body" name:"LedgerId"`
	LedgerName        string `position:"Body" name:"LedgerName"`
	LedgerDescription string `position:"Body" name:"LedgerDescription"`
}

// ModifyLedgerAttributeResponse is the response struct for api ModifyLedgerAttribute
type ModifyLedgerAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyLedgerAttributeRequest creates a request to invoke ModifyLedgerAttribute API
func CreateModifyLedgerAttributeRequest() (request *ModifyLedgerAttributeRequest) {
	request = &ModifyLedgerAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ledgerdb", "2019-11-22", "ModifyLedgerAttribute", "ledgerdb", "openAPI")
	return
}

// CreateModifyLedgerAttributeResponse creates a response to parse from ModifyLedgerAttribute response
func CreateModifyLedgerAttributeResponse() (response *ModifyLedgerAttributeResponse) {
	response = &ModifyLedgerAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
