package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OpenIotService invokes the iot.OpenIotService API synchronously
func (client *Client) OpenIotService(request *OpenIotServiceRequest) (response *OpenIotServiceResponse, err error) {
	response = CreateOpenIotServiceResponse()
	err = client.DoAction(request, response)
	return
}

// OpenIotServiceWithChan invokes the iot.OpenIotService API asynchronously
func (client *Client) OpenIotServiceWithChan(request *OpenIotServiceRequest) (<-chan *OpenIotServiceResponse, <-chan error) {
	responseChan := make(chan *OpenIotServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OpenIotService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OpenIotServiceWithCallback invokes the iot.OpenIotService API asynchronously
func (client *Client) OpenIotServiceWithCallback(request *OpenIotServiceRequest, callback func(response *OpenIotServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OpenIotServiceResponse
		var err error
		defer close(result)
		response, err = client.OpenIotService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OpenIotServiceRequest is the request struct for api OpenIotService
type OpenIotServiceRequest struct {
	*requests.RpcRequest
	OwnerId requests.Integer `position:"Query" name:"OwnerId"`
}

// OpenIotServiceResponse is the response struct for api OpenIotService
type OpenIotServiceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	OrderId   string `json:"OrderId" xml:"OrderId"`
}

// CreateOpenIotServiceRequest creates a request to invoke OpenIotService API
func CreateOpenIotServiceRequest() (request *OpenIotServiceRequest) {
	request = &OpenIotServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "OpenIotService", "", "")
	request.Method = requests.POST
	return
}

// CreateOpenIotServiceResponse creates a response to parse from OpenIotService response
func CreateOpenIotServiceResponse() (response *OpenIotServiceResponse) {
	response = &OpenIotServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
