package dyvmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryRtcNumberAuthStatus invokes the dyvmsapi.QueryRtcNumberAuthStatus API synchronously
func (client *Client) QueryRtcNumberAuthStatus(request *QueryRtcNumberAuthStatusRequest) (response *QueryRtcNumberAuthStatusResponse, err error) {
	response = CreateQueryRtcNumberAuthStatusResponse()
	err = client.DoAction(request, response)
	return
}

// QueryRtcNumberAuthStatusWithChan invokes the dyvmsapi.QueryRtcNumberAuthStatus API asynchronously
func (client *Client) QueryRtcNumberAuthStatusWithChan(request *QueryRtcNumberAuthStatusRequest) (<-chan *QueryRtcNumberAuthStatusResponse, <-chan error) {
	responseChan := make(chan *QueryRtcNumberAuthStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryRtcNumberAuthStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryRtcNumberAuthStatusWithCallback invokes the dyvmsapi.QueryRtcNumberAuthStatus API asynchronously
func (client *Client) QueryRtcNumberAuthStatusWithCallback(request *QueryRtcNumberAuthStatusRequest, callback func(response *QueryRtcNumberAuthStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryRtcNumberAuthStatusResponse
		var err error
		defer close(result)
		response, err = client.QueryRtcNumberAuthStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryRtcNumberAuthStatusRequest is the request struct for api QueryRtcNumberAuthStatus
type QueryRtcNumberAuthStatusRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	PhoneNumber          string           `position:"Query" name:"PhoneNumber"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// QueryRtcNumberAuthStatusResponse is the response struct for api QueryRtcNumberAuthStatus
type QueryRtcNumberAuthStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Module    string `json:"Module" xml:"Module"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateQueryRtcNumberAuthStatusRequest creates a request to invoke QueryRtcNumberAuthStatus API
func CreateQueryRtcNumberAuthStatusRequest() (request *QueryRtcNumberAuthStatusRequest) {
	request = &QueryRtcNumberAuthStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyvmsapi", "2017-05-25", "QueryRtcNumberAuthStatus", "dyvms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryRtcNumberAuthStatusResponse creates a response to parse from QueryRtcNumberAuthStatus response
func CreateQueryRtcNumberAuthStatusResponse() (response *QueryRtcNumberAuthStatusResponse) {
	response = &QueryRtcNumberAuthStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
