package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetFileTypeStatistic invokes the dataworks_public.GetFileTypeStatistic API synchronously
func (client *Client) GetFileTypeStatistic(request *GetFileTypeStatisticRequest) (response *GetFileTypeStatisticResponse, err error) {
	response = CreateGetFileTypeStatisticResponse()
	err = client.DoAction(request, response)
	return
}

// GetFileTypeStatisticWithChan invokes the dataworks_public.GetFileTypeStatistic API asynchronously
func (client *Client) GetFileTypeStatisticWithChan(request *GetFileTypeStatisticRequest) (<-chan *GetFileTypeStatisticResponse, <-chan error) {
	responseChan := make(chan *GetFileTypeStatisticResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetFileTypeStatistic(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetFileTypeStatisticWithCallback invokes the dataworks_public.GetFileTypeStatistic API asynchronously
func (client *Client) GetFileTypeStatisticWithCallback(request *GetFileTypeStatisticRequest, callback func(response *GetFileTypeStatisticResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetFileTypeStatisticResponse
		var err error
		defer close(result)
		response, err = client.GetFileTypeStatistic(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetFileTypeStatisticRequest is the request struct for api GetFileTypeStatistic
type GetFileTypeStatisticRequest struct {
	*requests.RpcRequest
	ProjectEnv string           `position:"Body" name:"ProjectEnv"`
	ProjectId  requests.Integer `position:"Body" name:"ProjectId"`
}

// GetFileTypeStatisticResponse is the response struct for api GetFileTypeStatistic
type GetFileTypeStatisticResponse struct {
	*responses.BaseResponse
	RequestId            string                `json:"RequestId" xml:"RequestId"`
	ProgramTypeAndCounts []ProgramTypeAndCount `json:"ProgramTypeAndCounts" xml:"ProgramTypeAndCounts"`
}

// CreateGetFileTypeStatisticRequest creates a request to invoke GetFileTypeStatistic API
func CreateGetFileTypeStatisticRequest() (request *GetFileTypeStatisticRequest) {
	request = &GetFileTypeStatisticRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "GetFileTypeStatistic", "", "")
	request.Method = requests.POST
	return
}

// CreateGetFileTypeStatisticResponse creates a response to parse from GetFileTypeStatistic response
func CreateGetFileTypeStatisticResponse() (response *GetFileTypeStatisticResponse) {
	response = &GetFileTypeStatisticResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
