package codeup

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListGroupMember invokes the codeup.ListGroupMember API synchronously
func (client *Client) ListGroupMember(request *ListGroupMemberRequest) (response *ListGroupMemberResponse, err error) {
	response = CreateListGroupMemberResponse()
	err = client.DoAction(request, response)
	return
}

// ListGroupMemberWithChan invokes the codeup.ListGroupMember API asynchronously
func (client *Client) ListGroupMemberWithChan(request *ListGroupMemberRequest) (<-chan *ListGroupMemberResponse, <-chan error) {
	responseChan := make(chan *ListGroupMemberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListGroupMember(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListGroupMemberWithCallback invokes the codeup.ListGroupMember API asynchronously
func (client *Client) ListGroupMemberWithCallback(request *ListGroupMemberRequest, callback func(response *ListGroupMemberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListGroupMemberResponse
		var err error
		defer close(result)
		response, err = client.ListGroupMember(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListGroupMemberRequest is the request struct for api ListGroupMember
type ListGroupMemberRequest struct {
	*requests.RoaRequest
	OrganizationId string           `position:"Query" name:"OrganizationId"`
	SubUserId      string           `position:"Query" name:"SubUserId"`
	GroupId        requests.Integer `position:"Path" name:"GroupId"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	AccessToken    string           `position:"Query" name:"AccessToken"`
	Page           requests.Integer `position:"Query" name:"Page"`
}

// ListGroupMemberResponse is the response struct for api ListGroupMember
type ListGroupMemberResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	ErrorCode    string       `json:"ErrorCode" xml:"ErrorCode"`
	Success      bool         `json:"Success" xml:"Success"`
	ErrorMessage string       `json:"ErrorMessage" xml:"ErrorMessage"`
	Total        int64        `json:"Total" xml:"Total"`
	Result       []ResultItem `json:"Result" xml:"Result"`
}

// CreateListGroupMemberRequest creates a request to invoke ListGroupMember API
func CreateListGroupMemberRequest() (request *ListGroupMemberRequest) {
	request = &ListGroupMemberRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("codeup", "2020-04-14", "ListGroupMember", "/api/v3/groups/[GroupId]/members", "", "")
	request.Method = requests.GET
	return
}

// CreateListGroupMemberResponse creates a response to parse from ListGroupMember response
func CreateListGroupMemberResponse() (response *ListGroupMemberResponse) {
	response = &ListGroupMemberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
