package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMultiChannelRecording invokes the ccc.GetMultiChannelRecording API synchronously
func (client *Client) GetMultiChannelRecording(request *GetMultiChannelRecordingRequest) (response *GetMultiChannelRecordingResponse, err error) {
	response = CreateGetMultiChannelRecordingResponse()
	err = client.DoAction(request, response)
	return
}

// GetMultiChannelRecordingWithChan invokes the ccc.GetMultiChannelRecording API asynchronously
func (client *Client) GetMultiChannelRecordingWithChan(request *GetMultiChannelRecordingRequest) (<-chan *GetMultiChannelRecordingResponse, <-chan error) {
	responseChan := make(chan *GetMultiChannelRecordingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMultiChannelRecording(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMultiChannelRecordingWithCallback invokes the ccc.GetMultiChannelRecording API asynchronously
func (client *Client) GetMultiChannelRecordingWithCallback(request *GetMultiChannelRecordingRequest, callback func(response *GetMultiChannelRecordingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMultiChannelRecordingResponse
		var err error
		defer close(result)
		response, err = client.GetMultiChannelRecording(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMultiChannelRecordingRequest is the request struct for api GetMultiChannelRecording
type GetMultiChannelRecordingRequest struct {
	*requests.RpcRequest
	ContactId  string `position:"Query" name:"ContactId"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// GetMultiChannelRecordingResponse is the response struct for api GetMultiChannelRecording
type GetMultiChannelRecordingResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateGetMultiChannelRecordingRequest creates a request to invoke GetMultiChannelRecording API
func CreateGetMultiChannelRecordingRequest() (request *GetMultiChannelRecordingRequest) {
	request = &GetMultiChannelRecordingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "GetMultiChannelRecording", "", "")
	request.Method = requests.POST
	return
}

// CreateGetMultiChannelRecordingResponse creates a response to parse from GetMultiChannelRecording response
func CreateGetMultiChannelRecordingResponse() (response *GetMultiChannelRecordingResponse) {
	response = &GetMultiChannelRecordingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
