package airec

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSceneBucket invokes the airec.DescribeSceneBucket API synchronously
func (client *Client) DescribeSceneBucket(request *DescribeSceneBucketRequest) (response *DescribeSceneBucketResponse, err error) {
	response = CreateDescribeSceneBucketResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSceneBucketWithChan invokes the airec.DescribeSceneBucket API asynchronously
func (client *Client) DescribeSceneBucketWithChan(request *DescribeSceneBucketRequest) (<-chan *DescribeSceneBucketResponse, <-chan error) {
	responseChan := make(chan *DescribeSceneBucketResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSceneBucket(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSceneBucketWithCallback invokes the airec.DescribeSceneBucket API asynchronously
func (client *Client) DescribeSceneBucketWithCallback(request *DescribeSceneBucketRequest, callback func(response *DescribeSceneBucketResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSceneBucketResponse
		var err error
		defer close(result)
		response, err = client.DescribeSceneBucket(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSceneBucketRequest is the request struct for api DescribeSceneBucket
type DescribeSceneBucketRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"instanceId"`
	SceneId    string `position:"Path" name:"sceneId"`
}

// DescribeSceneBucketResponse is the response struct for api DescribeSceneBucket
type DescribeSceneBucketResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
	Result    Result `json:"result" xml:"result"`
}

// CreateDescribeSceneBucketRequest creates a request to invoke DescribeSceneBucket API
func CreateDescribeSceneBucketRequest() (request *DescribeSceneBucketRequest) {
	request = &DescribeSceneBucketRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Airec", "2020-11-26", "DescribeSceneBucket", "/v2/openapi/instances/[instanceId]/scenes/[sceneId]/experiment-bucket", "airec", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeSceneBucketResponse creates a response to parse from DescribeSceneBucket response
func CreateDescribeSceneBucketResponse() (response *DescribeSceneBucketResponse) {
	response = &DescribeSceneBucketResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
