/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2022 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * Based on code M3D code by DarkBeam
 * @reference
 * http://www.fractalforums.com/mandelbulb-3d/custom-formulas-and-transforms-release-t17106/

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_transf_difs_piriform.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfDIFSPiriformIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{ // piriform
	if (fractal->transformCommon.functionEnabledCxFalse
			&& aux->i >= fractal->transformCommon.startIterationsC
			&& aux->i < fractal->transformCommon.stopIterationsC1)
	{
		z.y = fabs(z.y);
		REAL psi = M_PI_F / fractal->transformCommon.int2;
		psi = fabs(fmod(atan2(z.y, z.x) + psi, 2.0f * psi) - psi);
		REAL len = native_sqrt(z.x * z.x + z.y * z.y);
		z.x = native_cos(psi) * len;
		z.y = native_sin(psi) * len;
		z += fractal->transformCommon.offsetA000;
	}

	if (aux->i >= fractal->transformCommon.startIterationsD
			&& aux->i < fractal->transformCommon.stopIterationsD1)
	{
		if (fractal->transformCommon.functionEnabledAxFalse) z.x = fabs(z.x);
		if (fractal->transformCommon.functionEnabledAyFalse) z.y = fabs(z.y);
		if (fractal->transformCommon.functionEnabledAzFalse) z.z = fabs(z.z);
	}

	if (fractal->transformCommon.rotationEnabledFalse
			&& aux->i >= fractal->transformCommon.startIterationsR
			&& aux->i < fractal->transformCommon.stopIterationsR1)
	{
		z = Matrix33MulFloat4(fractal->transformCommon.rotationMatrix, z);
	}

	z += fractal->transformCommon.offset000;
	z *= fractal->transformCommon.scale1;
	aux->DE *= fractal->transformCommon.scale1;

	REAL4 zc = z;

	// swap axis
	if (fractal->transformCommon.functionEnabledSFalse)
	{
		REAL temp = zc.x;
		zc.x = zc.z;
		zc.z = temp;
	}

	zc *= fractal->transformCommon.scale3D111;

	REAL u = pow(zc.x, fractal->transformCommon.scale2);
	REAL r = u * zc.x + zc.y * zc.y + zc.z * zc.z + fractal->transformCommon.offsetB0;
	r = (r < 0.0f) ? 0.0f : native_sqrt(r);
	REAL t = u + fractal->transformCommon.offsetC0;
	t = (t < 0.0f) ? 0.0f : native_sqrt(t);
	t = r - t;

	if (fractal->transformCommon.functionEnabledKFalse)
	{
		zc.z *= fractal->transformCommon.scaleD1;
		if (!fractal->transformCommon.functionEnabledIFalse)
			t = native_sqrt(t * t + zc.z * zc.z);
		else
			t = max(fabs(t), fabs(zc.z));
		// aux->DE += 1.0f;
	}

	// z.x clip
	if (!fractal->transformCommon.functionEnabledCFalse)
	{
		t = max(t, fractal->transformCommon.offsetA0 - zc.x);
	}

	t -= fractal->transformCommon.offset0;

	if (fractal->analyticDE.enabledFalse)
		aux->DE = aux->DE * fractal->analyticDE.scale1 + fractal->analyticDE.offset0;

	REAL colDist = aux->dist;

	if (aux->i >= fractal->transformCommon.startIterationsG
			&& aux->i < fractal->transformCommon.stopIterationsG)
		t = min(aux->dist, t / aux->DE);

	aux->dist = t;

	// aux->color
	if (aux->i >= fractal->foldColor.startIterationsA && aux->i < fractal->foldColor.stopIterationsA)
	{
		REAL addColor = 0.0f;
		addColor += fractal->foldColor.difs0000.x * zc.x;
		if (t != colDist) addColor += fractal->foldColor.difs0000.y;

		if (!fractal->foldColor.auxColorEnabledAFalse)
			aux->color = addColor;
		else
			aux->color += addColor;
	}

	if (fractal->transformCommon.functionEnabledZcFalse
			&& aux->i >= fractal->transformCommon.startIterationsZc
			&& aux->i < fractal->transformCommon.stopIterationsZc)
		z = zc;
	return z;
}