/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2021 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * https://nylander.wordpress.com/2009/07/03/3d-mandelbrot-set-2/
 * Found on http://bugman123.com/Hypercomplex/index.html
 * Quadratic 3D Mandelbulb set, based on D. White's new "triplex squaring formula".
 * Hyperbolic radius added by Darkbeam refer Quadrat3D in M3D

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_mandelbulb_quadrat.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 MandelbulbQuadratIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	if (fractal->transformCommon.functionEnabledAFalse)
	{
		if (fractal->transformCommon.functionEnabledAxFalse) z.x = fabs(z.x);
		if (fractal->transformCommon.functionEnabledAyFalse) z.y = fabs(z.y);
		if (fractal->transformCommon.functionEnabledAzFalse) z.z = fabs(z.z);
	}

	if (fractal->transformCommon.functionEnabled)
	{
		aux->DE = aux->DE * 2.0f * length(z) + 1.0f;
		REAL temp = 0.0f;
		if (fractal->transformCommon.functionEnabledDFalse
				&& aux->i >= fractal->transformCommon.startIterationsD
				&& aux->i < fractal->transformCommon.stopIterationsD1)
			temp = fractal->transformCommon.offset0;

		temp = z.x * z.x + z.y * z.y + temp;
		if (temp == 0.0f)
			z = aux->const_c;
		else if (temp < 0.0f)
			z = (REAL4){0.0f, 0.0f, 0.0f, 0.0f};
		else
		{
			REAL4 Mul = fractal->transformCommon.constantMultiplier122;
			Mul.w = 0.0f;
			REAL ZR = fractal->transformCommon.offset1;
			Mul.z = -Mul.z * z.z * native_sqrt(temp);
			temp = ZR - z.z * z.z / temp;
			Mul.x = Mul.x * (z.x * z.x - z.y * z.y) * temp;
			Mul.y = Mul.y * z.x * z.y * temp;
			z = Mul;

			// offset (Julia)
			z += fractal->transformCommon.additionConstant000;
		}
	}

	if (fractal->transformCommon.functionEnabledFalse)
	{
		aux->DE = aux->DE * 2.0f * length(z) + 1.0f;

		REAL temp = 0.0f;
		if (fractal->transformCommon.functionEnabledTFalse
				&& aux->i >= fractal->transformCommon.startIterationsT
				&& aux->i < fractal->transformCommon.stopIterationsT1)
			temp = fractal->transformCommon.offsetA0;

		temp = z.z * z.z + z.y * z.y + temp;
		if (temp == 0.0f)
			z = aux->const_c;
		else if (temp < 0.0f)
			z = (REAL4){0.0f, 0.0f, 0.0f, 0.0f};
		else
		{
			REAL4 Mul = fractal->transformCommon.constantMultiplier221;
			Mul.w = 0.0f;
			REAL ZR = fractal->transformCommon.offsetA1;
			Mul.x = -Mul.x * z.x * native_sqrt(temp);
			temp = ZR - z.x * z.x / temp;
			Mul.z = Mul.z * (z.z * z.z - z.y * z.y) * temp;
			Mul.y = Mul.y * z.z * z.y * temp;
			z = Mul;

			// offset (Julia)
			z += fractal->transformCommon.additionConstantA000;
		}
	}

	z = Matrix33MulFloat4(fractal->transformCommon.rotationMatrix, z);

	// DE tweak
	if (fractal->analyticDE.enabledFalse)
		aux->DE = aux->DE * fractal->analyticDE.scale1 + fractal->analyticDE.offset0;
	return z;
}