/* Contains main(), handles command-line options
 * Ben Lynn
 */
/*
Copyright (C) 2002 Benjamin Lynn (blynn@cs.stanford.edu)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include <getopt.h>

#include "main.h"
#include "lowlevel.h"
#include "version.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

// use the first one of these that exists
static char *default_device[] = {"/dev/midi00", "/dev/midi", NULL};

char *midi_device = NULL;

int delay_sec = 1;
int delay_usec = 0;

int string_digit_limit = 4;
//any digit_string as long as this is sent
//4: will read up to four digits
//0, 1: will send single digits only

void display_usage()
{
    printf("%s\n", RCENTER_VERSION);
    printf("Command-line options:\n");
    printf("    -d    choose midi device (default is /dev/midi00)\n");
    printf("    -u    specify digit string delay in microseconds (default\
 is one second)\n");
    printf("    -l    specify digit string limit (default is 4)\n");
    printf("    -h    help\n");
    printf("    -V    version\n");
}

int main(int argc, char **argv)
{
    int c = 0, stat_result = -1;
    struct stat stat_struct;

    while (midi_device == NULL && default_device[c] && stat_result == -1) {
      stat_result = stat(default_device[c], &stat_struct);
      if (stat_result == 0)
	midi_device = default_device[c];
      c++;
    }
    if (midi_device == NULL)
      midi_device = default_device[0];

    for(;;) {
	c = getopt(argc, argv, "hVd:u:l:");
	if (c == -1) break;
	switch(c) {
	    case 'h':
		display_usage();
		exit(0);
		break;
	    case 'V':
		printf("Version: %s\n", RCENTER_VERSION);
		printf("Ben Lynn\n");
		exit(0);
		break;
	    case 'u':
		sscanf(optarg, "%d", &delay_usec);
		delay_sec = 0;
		break;
	    case 'l':
		sscanf(optarg, "%d", &string_digit_limit);
		break;
	    case 'd':
		midi_device = optarg;
		break;
	}
    }

    return main_loop();
}
