/*
Copyright (c) 2010-2016, Mathieu Labbe - IntRoLab - Universite de Sherbrooke
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the Universite de Sherbrooke nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef RTABMAP_LINKREFININGDIALOG_H_
#define RTABMAP_LINKREFININGDIALOG_H_

#include "rtabmap/gui/rtabmap_gui_export.h" // DLL export/import defines

#include <rtabmap/core/Link.h>

#include <QDialog>

class Ui_linkRefiningDialog;

namespace rtabmap {

class RTABMAP_GUI_EXPORT LinkRefiningDialog : public QDialog
{
	Q_OBJECT

public:
	LinkRefiningDialog(QWidget * parent = 0);

	virtual ~LinkRefiningDialog();

	void setMinMax(
		int nodeIdMin,
		int nodeIdMax,
		int mapIdMin,
		int mapIdMax);

	Link::Type getLinkType() const;
	void getIntraInterSessions(bool & intra, bool & inter) const;
	bool isRangeByNodeId() const;
	bool isRangeByMapId() const;
	void getRangeNodeId(int & from, int & to) const;
	void getRangeMapId(int & from, int & to) const;

private Q_SLOTS:
	void restoreDefaults();
	void updateIntraInterState();
	void setRangeToNodeId();
	void setRangeToMapId();

private:
	Ui_linkRefiningDialog * ui_;
	int defaultNodeIdMin_;
	int defaultNodeIdMax_;
	int defaultMapIdMin_;
	int defaultMapIdMax_;
};

}

#endif /* RTABMAP_LINKREFININGDIALOG_H_ */
