#include <stdio.h>
#include <ctype.h>


#define MAX_LINE_LEN        500
#define TAI_STR_LEN         24

/*
 * echo "@40000000432a47d53190780c other all up to MAX_LINE_LEN chars" | ./qtaif
 *
 * prints to stdout: 40000000432a47d53190780c
 */
int main(int argc, char *argv[]) {
    char buf[MAX_LINE_LEN];
    char taibuf[TAI_STR_LEN];
    int i;
    
    
    if ( fgets(buf, MAX_LINE_LEN, stdin) == NULL ) {
        fprintf(stderr, "Error: nothing given on standard input. Terminating.\n");
        return 2;
    }
    
    for (i = 0; i < TAI_STR_LEN; i++) {
        taibuf[i] = buf[i+1];
        if (! isxdigit(taibuf[i]) ) {
            fprintf(stderr, "Error: malformed line in input. Terminating.\n");
            return 3;
        }
    }
    taibuf[TAI_STR_LEN] =  '\0';
    
    printf("%s\n", taibuf);
    
    
    return 0;
}

