/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"
	json "encoding/json"
	"fmt"

	v1alpha3 "k8s.io/api/resource/v1alpha3"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	resourcev1alpha3 "k8s.io/client-go/applyconfigurations/resource/v1alpha3"
	testing "k8s.io/client-go/testing"
)

// FakeResourceClaims implements ResourceClaimInterface
type FakeResourceClaims struct {
	Fake *FakeResourceV1alpha3
	ns   string
}

var resourceclaimsResource = v1alpha3.SchemeGroupVersion.WithResource("resourceclaims")

var resourceclaimsKind = v1alpha3.SchemeGroupVersion.WithKind("ResourceClaim")

// Get takes name of the resourceClaim, and returns the corresponding resourceClaim object, and an error if there is any.
func (c *FakeResourceClaims) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha3.ResourceClaim, err error) {
	emptyResult := &v1alpha3.ResourceClaim{}
	obj, err := c.Fake.
		Invokes(testing.NewGetActionWithOptions(resourceclaimsResource, c.ns, name, options), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1alpha3.ResourceClaim), err
}

// List takes label and field selectors, and returns the list of ResourceClaims that match those selectors.
func (c *FakeResourceClaims) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha3.ResourceClaimList, err error) {
	emptyResult := &v1alpha3.ResourceClaimList{}
	obj, err := c.Fake.
		Invokes(testing.NewListActionWithOptions(resourceclaimsResource, resourceclaimsKind, c.ns, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha3.ResourceClaimList{ListMeta: obj.(*v1alpha3.ResourceClaimList).ListMeta}
	for _, item := range obj.(*v1alpha3.ResourceClaimList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested resourceClaims.
func (c *FakeResourceClaims) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchActionWithOptions(resourceclaimsResource, c.ns, opts))

}

// Create takes the representation of a resourceClaim and creates it.  Returns the server's representation of the resourceClaim, and an error, if there is any.
func (c *FakeResourceClaims) Create(ctx context.Context, resourceClaim *v1alpha3.ResourceClaim, opts v1.CreateOptions) (result *v1alpha3.ResourceClaim, err error) {
	emptyResult := &v1alpha3.ResourceClaim{}
	obj, err := c.Fake.
		Invokes(testing.NewCreateActionWithOptions(resourceclaimsResource, c.ns, resourceClaim, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1alpha3.ResourceClaim), err
}

// Update takes the representation of a resourceClaim and updates it. Returns the server's representation of the resourceClaim, and an error, if there is any.
func (c *FakeResourceClaims) Update(ctx context.Context, resourceClaim *v1alpha3.ResourceClaim, opts v1.UpdateOptions) (result *v1alpha3.ResourceClaim, err error) {
	emptyResult := &v1alpha3.ResourceClaim{}
	obj, err := c.Fake.
		Invokes(testing.NewUpdateActionWithOptions(resourceclaimsResource, c.ns, resourceClaim, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1alpha3.ResourceClaim), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeResourceClaims) UpdateStatus(ctx context.Context, resourceClaim *v1alpha3.ResourceClaim, opts v1.UpdateOptions) (result *v1alpha3.ResourceClaim, err error) {
	emptyResult := &v1alpha3.ResourceClaim{}
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceActionWithOptions(resourceclaimsResource, "status", c.ns, resourceClaim, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1alpha3.ResourceClaim), err
}

// Delete takes name of the resourceClaim and deletes it. Returns an error if one occurs.
func (c *FakeResourceClaims) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteActionWithOptions(resourceclaimsResource, c.ns, name, opts), &v1alpha3.ResourceClaim{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeResourceClaims) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionActionWithOptions(resourceclaimsResource, c.ns, opts, listOpts)

	_, err := c.Fake.Invokes(action, &v1alpha3.ResourceClaimList{})
	return err
}

// Patch applies the patch and returns the patched resourceClaim.
func (c *FakeResourceClaims) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha3.ResourceClaim, err error) {
	emptyResult := &v1alpha3.ResourceClaim{}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceActionWithOptions(resourceclaimsResource, c.ns, name, pt, data, opts, subresources...), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1alpha3.ResourceClaim), err
}

// Apply takes the given apply declarative configuration, applies it and returns the applied resourceClaim.
func (c *FakeResourceClaims) Apply(ctx context.Context, resourceClaim *resourcev1alpha3.ResourceClaimApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha3.ResourceClaim, err error) {
	if resourceClaim == nil {
		return nil, fmt.Errorf("resourceClaim provided to Apply must not be nil")
	}
	data, err := json.Marshal(resourceClaim)
	if err != nil {
		return nil, err
	}
	name := resourceClaim.Name
	if name == nil {
		return nil, fmt.Errorf("resourceClaim.Name must be provided to Apply")
	}
	emptyResult := &v1alpha3.ResourceClaim{}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceActionWithOptions(resourceclaimsResource, c.ns, *name, types.ApplyPatchType, data, opts.ToPatchOptions()), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1alpha3.ResourceClaim), err
}

// ApplyStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
func (c *FakeResourceClaims) ApplyStatus(ctx context.Context, resourceClaim *resourcev1alpha3.ResourceClaimApplyConfiguration, opts v1.ApplyOptions) (result *v1alpha3.ResourceClaim, err error) {
	if resourceClaim == nil {
		return nil, fmt.Errorf("resourceClaim provided to Apply must not be nil")
	}
	data, err := json.Marshal(resourceClaim)
	if err != nil {
		return nil, err
	}
	name := resourceClaim.Name
	if name == nil {
		return nil, fmt.Errorf("resourceClaim.Name must be provided to Apply")
	}
	emptyResult := &v1alpha3.ResourceClaim{}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceActionWithOptions(resourceclaimsResource, c.ns, *name, types.ApplyPatchType, data, opts.ToPatchOptions(), "status"), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1alpha3.ResourceClaim), err
}
