/*******************************************************************************
* File:   		localkeygen.h
* Date:   		2004-05-21
* Author: 		Fernando Tarín
* Last Modified:	2004-5-23
*
* Description: Generates keywords for 64 and 128 bit mode
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU Library General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*******************************************************************************/

#ifndef WEPDECRYPT_LOCALKEYGEN_H
#define WEPDECRYPT_LOCALKEYGEN_H

// Key generator modes
#define ALL			0
#define ALPHA		1
#define ALPHANUM	2
#define NUMERIC		3
#define PRINTABLE	4
#define RANDOM		5
#define UDEF		6

int key_cmp(const unsigned char * start_key, const unsigned char * end_key, int number_bits);

int parse_key(const unsigned char * key_to_parse, unsigned char * key, int number_bits);

int initialize_generator(int key_length, unsigned char * start_key, unsigned char * end_key, int generator_mode);

int generate_key(unsigned char * key);

void end_generator(void);

// Old functions

int initialize_generator_begin(int mode_keygen, ...);

int initialize_generator_end(int mode_keygen, ...);

int generate_key_old(unsigned char * key);

#endif
