# License

My version of redo was written without ever seeing redo code by Bernstein or
Grosskurth, so I own the entire copyright.  It's distributed under the terms
of the [Apache License 2.0](https://www.apache.org/licenses/LICENSE-2.0),
which you can find in the file called
[LICENSE](https://github.com/apenwarr/redo/tree/master/LICENSE).  (Previous
versions of redo were distributed under the GNU LGPL, but this [changed in
2018](https://groups.google.com/forum/#!topic/redo-list/wLMZMxtn4wo).)

minimal/do is in the public domain so that it's as easy as possible
to include inside your own projects, to help end users who don't
have a copy of redo.


# How can I help?

Nowadays, redo is good enough for real production use, and some people
are using it for real work.  That said, it has
not reached version 1.0 and there are always going to be bugs.

If you run into a problem, it's really helpful if you report it to the
mailing list below (with or without subscribing first).  We really want to
know if redo is acting weird for you.  Even if the problem turns out to be
operator error, we can use that information to try to improve this
documentation.

Small feature additions are also welcome, but you might want to ask on the
mailing list before you start working on it.  The code is still evolving and
might not be the same by the time you submit your pull request.

Contributions to [redoconf](/cookbook/redoconf-simple/) are very welcome.
For example, you might want to contribute detectors for new libraries or
compilers.

Some of the best things you can do for redo are:

- Convert your projects to using it.  Without users, no project is
  successful.

- Convince your favourite OS distro to build and include (up to date!) redo
  packages.  We especially need someone to help with getting redo included
  in debian.

- Help proofreading this documentation, and send patches or pull requests
  with improvements and additions.

- Join the mailing list (below) to discuss design changes or bugs.

- Tell your friends!


# Mailing list

You should join the `redo-list@googlegroups.com` mailing list!

You can find the mailing list archives here:
<http://groups.google.com/group/redo-list>

It might not look like it, but you can subscribe without having a
Google Account.  Just send a message to
`redo-list+subscribe@googlegroups.com` (note the plus sign).
	
It's okay to send a message directly to the mailing list
without subscribing first.  If you reply to someone who writes to the
list, please leave them in the cc: list, since if they
haven't subscribed, they won't get your reply otherwise. 
