/*
 * Decompiled with CFR 0.152.
 */
package plugin.pretokens.parser;

import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.AbstractPrerequisiteListParser;
import pcgen.persistence.lst.prereq.PrerequisiteParserInterface;

public class PreCampaignParser
extends AbstractPrerequisiteListParser
implements PrerequisiteParserInterface {
    public String[] kindsHandled() {
        return new String[]{"CAMPAIGN"};
    }

    public Prerequisite parse(String kind, String formula, boolean invertResult, boolean overrideQualify) throws PersistenceLayerException {
        Prerequisite prereq = super.parse(kind, formula, invertResult, overrideQualify);
        this.setNoNeedForChar(prereq);
        if (formula.indexOf(91) >= 0) {
            this.negateCampaignChoice(prereq);
        }
        return prereq;
    }

    private void negateCampaignChoice(Prerequisite prereq) {
        int modified = 0;
        for (Prerequisite p : prereq.getPrerequisites()) {
            if (p.getKind() == null) {
                this.negateCampaignChoice(p);
                continue;
            }
            String preKey = p.getKey();
            if (!preKey.startsWith("[") || !preKey.endsWith("]")) continue;
            preKey = preKey.substring(1, preKey.length() - 1);
            p.setKey(preKey);
            p.setOperator(p.getOperator().invert());
            ++modified;
        }
        if (modified > 0) {
            String oper = prereq.getOperand();
            try {
                oper = Integer.toString(Integer.parseInt(oper) + modified);
            }
            catch (NumberFormatException nfe) {
                oper = "(" + oper + ")+" + Integer.toString(modified);
            }
            prereq.setOperand(oper);
        }
    }

    protected boolean allowsNegate() {
        return true;
    }
}

