/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens;

import java.util.ArrayList;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.Ungranted;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractIntToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class UmultLst
extends AbstractIntToken<CDOMObject>
implements CDOMPrimaryToken<CDOMObject> {
    public String getTokenName() {
        return "UMULT";
    }

    protected IntegerKey integerKey() {
        return IntegerKey.UMULT;
    }

    protected int minValue() {
        return 1;
    }

    public ParseResult parseToken(LoadContext context, CDOMObject obj, String value) {
        if (obj instanceof Ungranted) {
            return new ParseResult.Fail("Cannot use " + this.getTokenName() + " on an Ungranted object type: " + obj.getClass().getSimpleName(), context);
        }
        if (".CLEAR".equals(value)) {
            context.getObjectContext().remove(obj, IntegerKey.UMULT);
            return ParseResult.SUCCESS;
        }
        return super.parseToken(context, obj, value);
    }

    public String[] unparse(LoadContext context, CDOMObject obj) {
        Integer mult = context.getObjectContext().getInteger(obj, IntegerKey.UMULT);
        boolean b = context.getObjectContext().wasRemoved(obj, IntegerKey.UMULT);
        ArrayList<String> list = new ArrayList<String>();
        if (b) {
            list.add(".CLEAR");
        }
        if (mult != null) {
            if (mult <= 0) {
                context.addWriteMessage(this.getTokenName() + " must be an integer > 0");
                return null;
            }
            list.add(mult.toString());
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }
}

